/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import tcl.lang.cmd.EncodingCmd;

class UnicodeEncoder
extends Writer {
    private String encoding = null;
    private String requestedEncoding = null;
    private OutputStream out;
    private CharsetEncoder cse = null;

    UnicodeEncoder(OutputStream out, String encoding) {
        this.out = out;
        this.setEncoding(encoding);
    }

    void setEncoding(String encoding) {
        this.requestedEncoding = encoding;
    }

    private void setEncoding() {
        if (this.encoding == null && this.requestedEncoding == null) {
            return;
        }
        if (this.encoding != null && this.encoding.equals(this.requestedEncoding)) {
            return;
        }
        this.encoding = this.requestedEncoding;
        if (this.encoding == null || "symbol".equals(this.encoding)) {
            this.cse = null;
        } else {
            this.cse = Charset.forName(this.encoding).newEncoder();
            this.cse.onMalformedInput(CodingErrorAction.REPLACE);
            this.cse.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cse != null) {
            CharBuffer cb = CharBuffer.allocate(0);
            ByteBuffer bb = ByteBuffer.allocate(1024);
            this.cse.encode(cb, bb, true);
            this.cse.flush(bb);
            bb.flip();
            this.out.write(bb.array(), bb.position(), bb.limit());
        }
        this.out.close();
        this.out = null;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.setEncoding();
        if (this.cse != null) {
            int encodedBufSize = Math.max(256, (int)Math.ceil((float)len * this.cse.averageBytesPerChar()));
            byte[] bbuf = new byte[encodedBufSize];
            ByteBuffer bb = ByteBuffer.wrap(bbuf);
            CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
            CoderResult result = CoderResult.OVERFLOW;
            while (result == CoderResult.OVERFLOW) {
                result = this.cse.encode(cb, bb, false);
                bb.flip();
                this.out.write(bb.array(), bb.position(), bb.limit());
                bb.clear();
            }
            if (cb.remaining() > 0) {
                throw new RuntimeException("Unicode Encoder did not consume all of the input, this is unexpected: pos=" + bb.position() + " limit=" + bb.limit() + " result=" + result);
            }
        } else {
            byte[] bbuf;
            if (this.encoding == null) {
                bbuf = new byte[len];
                int i = 0;
                while (i < len) {
                    bbuf[i] = (byte)(cbuf[i + off] & 0xFF);
                    ++i;
                }
            } else {
                bbuf = EncodingCmd.encodeSymbol(cbuf, off, len);
            }
            this.out.write(bbuf, 0, len);
        }
    }
}

