/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TimerHandler;
import tcl.lang.Util;

public class AfterCmd
implements Command {
    AfterAssocData assocData = null;
    private static final String[] validOpts = new String[]{"cancel", "idle", "info"};
    static final int OPT_CANCEL = 0;
    static final int OPT_IDLE = 1;
    static final int OPT_INFO = 2;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int index;
        Notifier notifier = interp.getNotifier();
        if (this.assocData == null) {
            this.assocData = (AfterAssocData)interp.getAssocData("tclAfter");
            if (this.assocData == null) {
                this.assocData = new AfterAssocData();
                interp.setAssocData("tclAfter", this.assocData);
            }
        }
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        boolean isNumber = false;
        long ms = 0L;
        if (argv[1].isIntType()) {
            ms = TclInteger.getLong(interp, argv[1]);
            isNumber = true;
        } else {
            String s = argv[1].toString();
            if (s.length() > 0 && (Character.isDigit(s.charAt(0)) || s.charAt(0) == '-')) {
                ms = TclInteger.getLong(interp, argv[1]);
                isNumber = true;
            }
        }
        if (isNumber) {
            if (ms < 0L) {
                ms = 0L;
            }
            if (argv.length == 2) {
                long endTime = System.currentTimeMillis() + ms;
                while (true) {
                    try {
                        Thread.sleep(ms);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        long sysTime = System.currentTimeMillis();
                        if (sysTime >= endTime) {
                            return;
                        }
                        ms = endTime - sysTime;
                        continue;
                    }
                    break;
                }
            }
            TclObject cmd = this.getCmdObject(argv);
            cmd.preserve();
            ++this.assocData.lastAfterId;
            TimerInfo timerInfo = new TimerInfo(notifier, ms);
            timerInfo.interp = interp;
            timerInfo.command = cmd;
            timerInfo.id = this.assocData.lastAfterId;
            this.assocData.handlers.add(timerInfo);
            interp.setResult("after#" + timerInfo.id);
            return;
        }
        try {
            index = TclIndex.get(interp, argv[1], validOpts, "option", 0);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "bad argument \"" + argv[1] + "\": must be cancel, idle, info, or a number");
        }
        switch (index) {
            case 0: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "id|command");
                }
                TclObject arg = this.getCmdObject(argv);
                arg.preserve();
                Object info = null;
                int i = 0;
                while (i < this.assocData.handlers.size()) {
                    Object obj = this.assocData.handlers.get(i);
                    if (obj instanceof TimerInfo) {
                        cmd = ((TimerInfo)obj).command;
                        if (cmd == arg || cmd.toString().equals(arg.toString())) {
                            info = obj;
                            break;
                        }
                    } else {
                        cmd = ((IdleInfo)obj).command;
                        if (cmd == arg || cmd.toString().equals(arg.toString())) {
                            info = obj;
                            break;
                        }
                    }
                    ++i;
                }
                if (info == null) {
                    info = this.getAfterEvent(interp, arg.toString());
                }
                arg.release();
                if (info == null) break;
                if (info instanceof TimerInfo) {
                    TimerInfo ti = (TimerInfo)info;
                    ti.cancel();
                    ti.command.release();
                } else {
                    IdleInfo ii = (IdleInfo)info;
                    ii.cancel();
                    ii.command.release();
                }
                int hindex = this.assocData.handlers.indexOf(info);
                if (hindex == -1) {
                    throw new TclRuntimeError("info " + info + " has no handler");
                }
                if (this.assocData.handlers.remove(hindex) != null) break;
                throw new TclRuntimeError("cound not remove handler " + hindex);
            }
            case 1: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "script script ...");
                }
                TclObject cmd = this.getCmdObject(argv);
                cmd.preserve();
                ++this.assocData.lastAfterId;
                IdleInfo idleInfo = new IdleInfo(notifier);
                idleInfo.interp = interp;
                idleInfo.command = cmd;
                idleInfo.id = this.assocData.lastAfterId;
                this.assocData.handlers.add(idleInfo);
                interp.setResult("after#" + idleInfo.id);
                break;
            }
            case 2: {
                if (argv.length == 2) {
                    TclObject list = TclList.newInstance();
                    int i = 0;
                    while (i < this.assocData.handlers.size()) {
                        Object obj = this.assocData.handlers.get(i);
                        int id = obj instanceof TimerInfo ? ((TimerInfo)obj).id : ((IdleInfo)obj).id;
                        TclList.append(interp, list, TclString.newInstance("after#" + id));
                        ++i;
                    }
                    interp.setResult(list);
                    return;
                }
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?id?");
                }
                Object info = this.getAfterEvent(interp, argv[2].toString());
                if (info == null) {
                    throw new TclException(interp, "event \"" + argv[2] + "\" doesn't exist");
                }
                TclObject list = TclList.newInstance();
                TclList.append(interp, list, info instanceof TimerInfo ? ((TimerInfo)info).command : ((IdleInfo)info).command);
                TclList.append(interp, list, TclString.newInstance(info instanceof TimerInfo ? "timer" : "idle"));
                interp.setResult(list);
            }
        }
    }

    private TclObject getCmdObject(TclObject[] argv) throws TclException {
        if (argv.length == 3) {
            return argv[2];
        }
        TclObject cmd = Util.concat(2, argv.length - 1, argv);
        return cmd;
    }

    private Object getAfterEvent(Interp interp, String string) {
        if (!string.startsWith("after#")) {
            return null;
        }
        int id = 0;
        try {
            id = Integer.parseInt(string.substring(6));
        }
        catch (Exception exception) {
            return null;
        }
        int i = 0;
        while (i < this.assocData.handlers.size()) {
            Object obj = this.assocData.handlers.get(i);
            if (obj instanceof TimerInfo ? ((TimerInfo)obj).id == id : ((IdleInfo)obj).id == id) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    class AfterAssocData
    implements AssocData {
        ArrayList handlers = new ArrayList();
        int lastAfterId = 0;

        AfterAssocData() {
        }

        @Override
        public void disposeAssocData(Interp interp) {
            int i = AfterCmd.this.assocData.handlers.size() - 1;
            while (i >= 0) {
                Object info = AfterCmd.this.assocData.handlers.get(i);
                if (AfterCmd.this.assocData.handlers.remove(i) == null) {
                    throw new TclRuntimeError("cound not remove handler " + i);
                }
                if (info instanceof TimerInfo) {
                    TimerInfo ti = (TimerInfo)info;
                    ti.cancel();
                    ti.command.release();
                } else {
                    IdleInfo ii = (IdleInfo)info;
                    ii.cancel();
                    ii.command.release();
                }
                --i;
            }
            AfterCmd.this.assocData = null;
        }
    }

    class IdleInfo
    extends IdleHandler {
        Interp interp;
        TclObject command;
        int id;

        IdleInfo(Notifier n) {
            super(n);
        }

        @Override
        public void processIdleEvent() {
            try {
                try {
                    int index = AfterCmd.this.assocData.handlers.indexOf(this);
                    if (index == -1) {
                        throw new TclRuntimeError("this " + this + " has no handler");
                    }
                    if (AfterCmd.this.assocData.handlers.remove(index) == null) {
                        throw new TclRuntimeError("cound not remove handler " + index);
                    }
                    this.interp.eval(this.command, 131072);
                }
                catch (TclException tclException) {
                    this.interp.addErrorInfo("\n    (\"after\" script)");
                    this.interp.backgroundError();
                    this.command.release();
                    this.command = null;
                }
            }
            finally {
                this.command.release();
                this.command = null;
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(super.toString());
            sb.append("AfterCmd.IdleInfo : " + this.command + "\n");
            return sb.toString();
        }
    }

    class TimerInfo
    extends TimerHandler {
        Interp interp;
        TclObject command;
        int id;

        TimerInfo(Notifier n, long milliseconds) {
            super(n, milliseconds);
        }

        @Override
        public void processTimerEvent() {
            try {
                try {
                    int index = AfterCmd.this.assocData.handlers.indexOf(this);
                    if (index == -1) {
                        throw new TclRuntimeError("this " + this + " has no handler");
                    }
                    if (AfterCmd.this.assocData.handlers.remove(index) == null) {
                        throw new TclRuntimeError("cound not remove handler " + index);
                    }
                    this.interp.eval(this.command, 131072);
                }
                catch (TclException tclException) {
                    this.interp.addErrorInfo("\n    (\"after\" script)");
                    this.interp.backgroundError();
                    this.command.release();
                    this.command = null;
                }
            }
            finally {
                this.command.release();
                this.command = null;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(super.toString());
            sb.append("AfterCmd.TimerInfo : " + this.command + "\n");
            return sb.toString();
        }
    }
}

