/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.Util;
import tcl.lang.Var;

public class ArrayCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"anymore", "donesearch", "exists", "get", "names", "nextelement", "set", "size", "startsearch", "unset"};
    static final int OPT_ANYMORE = 0;
    static final int OPT_DONESEARCH = 1;
    static final int OPT_EXISTS = 2;
    static final int OPT_GET = 3;
    static final int OPT_NAMES = 4;
    static final int OPT_NEXTELEMENT = 5;
    static final int OPT_SET = 6;
    static final int OPT_SIZE = 7;
    static final int OPT_STARTSEARCH = 8;
    static final int OPT_UNSET = 9;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        Var var = null;
        Var array = null;
        boolean notArray = false;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "option arrayName ?arg ...?");
        }
        int index = TclIndex.get(interp, objv[1], validCmds, "option", 0);
        String varName = objv[2].toString();
        Var[] retArray = Var.lookupVar(interp, varName, null, 0, null, false, false);
        if (retArray != null) {
            var = retArray[0];
            array = retArray[1];
        }
        if (var == null || !var.isVarArray() || var.isVarUndefined()) {
            notArray = true;
        }
        if (var != null && var.traces != null && (!var.isVarScalar() || var.isVarUndefined())) {
            String msg = Var.callTraces(interp, array, var, varName, null, 2563);
            if (msg != null) {
                throw new TclVarException(interp, varName, null, "trace array", msg);
            }
            notArray = false;
            retArray = Var.lookupVar(interp, varName, null, 0, null, false, false);
            if (retArray != null) {
                var = retArray[0];
                array = retArray[1];
            }
            if (var == null || !var.isVarArray() || var.isVarUndefined()) {
                notArray = true;
            }
        }
        switch (index) {
            case 0: {
                Iterator iter;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName searchId");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if ((iter = var.getSearch(objv[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if (iter.hasNext()) {
                    interp.setResult(true);
                    break;
                }
                interp.setResult(false);
                break;
            }
            case 1: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName searchId");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                boolean rmOK = true;
                if (var.sidVec != null) {
                    rmOK = var.removeSearch(objv[3].toString());
                }
                if (var.sidVec != null && rmOK) break;
                ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                break;
            }
            case 2: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName");
                }
                interp.setResult(!notArray);
                break;
            }
            case 3: {
                if (objv.length != 3 && objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName ?pattern?");
                }
                if (notArray) {
                    return;
                }
                String pattern = null;
                if (objv.length == 4) {
                    pattern = objv[3].toString();
                }
                TclObject tobj = TclList.newInstance();
                String arrayName = objv[2].toString();
                ArrayList<String> keysToReturn = new ArrayList<String>();
                for (String string : var.getArrayMap().keySet()) {
                    if (pattern != null && !Util.stringMatch(string, pattern)) continue;
                    keysToReturn.add(string);
                }
                for (String string : keysToReturn) {
                    Var var2 = var.getArrayMap().get(string);
                    if (var2 == null || var2.isVarUndefined()) continue;
                    try {
                        String strValue = interp.getVar(arrayName, string, 0).toString();
                        TclList.append(interp, tobj, TclString.newInstance(string));
                        TclList.append(interp, tobj, TclString.newInstance(strValue));
                    }
                    catch (TclException e) {
                        retArray = Var.lookupVar(interp, varName, null, 0, null, false, false);
                        if (retArray != null) {
                            var = retArray[0];
                            array = retArray[1];
                        }
                        if (var != null && var.isVarArray() && !var.isVarUndefined()) continue;
                        throw e;
                    }
                }
                interp.setResult(tobj);
                break;
            }
            case 4: {
                if (objv.length != 3 && objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName ?pattern?");
                }
                if (notArray) {
                    return;
                }
                String pattern = null;
                if (objv.length == 4) {
                    pattern = objv[3].toString();
                }
                Map<String, Var> table = var.getArrayMap();
                TclObject tobj = TclList.newInstance();
                for (Map.Entry<String, Var> entry : table.entrySet()) {
                    String key = entry.getKey();
                    Var elem = entry.getValue();
                    if (elem.isVarUndefined() || pattern != null && !Util.stringMatch(key, pattern)) continue;
                    TclList.append(interp, tobj, TclString.newInstance(key));
                }
                interp.setResult(tobj);
                break;
            }
            case 5: {
                Iterator iter;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName searchId");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if ((iter = var.getSearch(objv[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if (!iter.hasNext()) break;
                Map.Entry entry = (Map.Entry)iter.next();
                String key = (String)entry.getKey();
                Var elem = (Var)entry.getValue();
                if (!elem.isVarUndefined()) {
                    interp.setResult(key);
                    break;
                }
                interp.setResult("");
                break;
            }
            case 6: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName list");
                }
                int size = TclList.getLength(interp, objv[3]);
                if (size % 2 != 0) {
                    throw new TclException(interp, "list must have an even number of elements");
                }
                String name1 = objv[2].toString();
                if (name1.endsWith(")") && name1.contains("(")) {
                    throw new TclVarException(interp, name1, null, "set", "variable isn't array");
                }
                Var.lookupVar(interp, name1, "", 0, "set", true, false);
                int i = 0;
                while (i < size) {
                    String name2 = TclList.index(interp, objv[3], i++).toString();
                    String string = TclList.index(interp, objv[3], i).toString();
                    interp.setVar(name1, name2, TclString.newInstance(string), 0);
                    ++i;
                }
                break;
            }
            case 7: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName");
                }
                if (notArray) {
                    interp.setResult(0L);
                    break;
                }
                Map<String, Var> table = var.getArrayMap();
                int size = 0;
                for (Map.Entry<String, Var> entry : table.entrySet()) {
                    entry.getKey();
                    Var var2 = entry.getValue();
                    if (var2.isVarUndefined()) continue;
                    ++size;
                }
                interp.setResult(size);
                break;
            }
            case 8: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (var.sidVec == null) {
                    var.sidVec = new ArrayList();
                }
                int i = var.getNextIndex();
                String s = "s-" + i + "-" + objv[2].toString();
                Map<String, Var> table = var.getArrayMap();
                Iterator<Map.Entry<String, Var>> iter = table.entrySet().iterator();
                var.sidVec.add(new SearchId(iter, s, i));
                interp.setResult(s);
                break;
            }
            case 9: {
                if (objv.length != 3 && objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName ?pattern?");
                }
                if (notArray) {
                    return;
                }
                if (objv.length == 3) {
                    interp.unsetVar(objv[2], 0);
                    break;
                }
                String pattern = objv[3].toString();
                Map<String, Var> table = var.getArrayMap();
                Iterator<Map.Entry<String, Var>> iter = table.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Var> entry = iter.next();
                    String name = entry.getKey();
                    Var var3 = entry.getValue();
                    if (var3.isVarUndefined() || !Util.stringMatch(name, pattern)) continue;
                    interp.unsetVar(varName, name, 0);
                    iter = table.entrySet().iterator();
                }
                break;
            }
        }
    }

    private static void errorNotArray(Interp interp, String var) throws TclException {
        throw new TclException(interp, "\"" + var + "\" isn't an array");
    }

    static void errorIllegalSearchId(Interp interp, String varName, String sid) throws TclException {
        int val = ArrayCmd.validSearchId(sid.toCharArray(), varName);
        if (val == 1) {
            throw new TclException(interp, "couldn't find search \"" + sid + "\"");
        }
        if (val == 0) {
            throw new TclException(interp, "illegal search identifier \"" + sid + "\"");
        }
        throw new TclException(interp, "search identifier \"" + sid + "\" isn't for variable \"" + varName + "\"");
    }

    private static int validSearchId(char[] pattern, String varName) {
        if (pattern[0] != 's' || pattern[1] != '-' || pattern[2] < '0' || pattern[2] > '9') {
            return 0;
        }
        int i = 3;
        while (i < pattern.length && pattern[i] != '-') {
            if (pattern[i] < '0' || pattern[i] > '9') {
                return 0;
            }
            ++i;
        }
        if (++i >= pattern.length) {
            return 0;
        }
        if (varName.equals(new String(pattern, i, pattern.length - i))) {
            return 1;
        }
        return -1;
    }
}

