/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.cmd.ClockToken;

class ClockRelTimespan {
    private int seconds = 0;
    private int months = 0;
    private int ordMonth = 0;
    private int weekday = 0;
    private int dayOrdinal = 0;

    ClockRelTimespan() {
    }

    void addSeconds(int s) {
        this.seconds += s;
    }

    void addMonths(int m) {
        this.months += m;
    }

    void addOrdMonth(int m, int c) {
        this.months = m;
        this.ordMonth += c;
    }

    void addUnit(ClockToken unit, int amount) {
        if (unit.is(9)) {
            this.addSeconds(unit.getInt() * amount);
        } else if (unit.is(8)) {
            this.addSeconds(unit.getInt() * 60 * amount);
        } else if (unit.is(7)) {
            this.addMonths(unit.getInt() * amount);
        }
    }

    void addUnit(ClockToken unit) {
        this.addUnit(unit, 1);
    }

    void setWeekday(int w, int ord) {
        this.weekday = w;
        this.dayOrdinal = ord;
    }

    void setWeekday(int w) {
        this.setWeekday(w, 1);
    }

    void negate() {
        this.seconds = -this.seconds;
        this.months = -this.months;
    }

    int getSeconds() {
        return this.seconds;
    }

    int getMonths() {
        return this.months;
    }

    int getOrdMonth() {
        return this.ordMonth;
    }

    int getWeekday() {
        return this.weekday;
    }

    int getDayOrdinal() {
        return this.dayOrdinal;
    }
}

