/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.TimeZone;

class ClockToken {
    static final int ISOBASE = 1;
    static final int UNUMBER = 2;
    static final int WORD = 3;
    static final int CHAR = 4;
    static final int MONTH = 5;
    static final int DAY = 6;
    static final int MONTH_UNIT = 7;
    static final int MINUTE_UNIT = 8;
    static final int SEC_UNIT = 9;
    static final int AGO = 10;
    static final int EPOCH = 11;
    static final int ZONE = 12;
    static final int DAYZONE = 13;
    static final int DST = 14;
    static final int MERIDIAN = 15;
    static final int NEXT = 16;
    static final int STARDATE = 17;
    private int kind;
    private int number;
    private String word;
    private char c;
    private TimeZone zone;

    ClockToken(int number, boolean isIsoBase) {
        this.kind = isIsoBase ? 1 : 2;
        this.number = number;
    }

    ClockToken(int kind, int number) {
        this.kind = kind;
        this.number = number;
    }

    ClockToken(int kind, TimeZone zone) {
        this.kind = kind;
        this.zone = zone;
    }

    ClockToken(String word) {
        this.kind = 3;
        this.word = word;
    }

    ClockToken(char c) {
        this.kind = 4;
        this.c = c;
    }

    public boolean isUNumber() {
        return this.kind == 2;
    }

    public boolean isIsoBase() {
        return this.kind == 1;
    }

    public boolean is(char c) {
        return this.kind == 4 && this.c == c;
    }

    public boolean is(int kind) {
        return this.kind == kind;
    }

    public boolean isUnit() {
        return this.kind == 8 || this.kind == 7 || this.kind == 9;
    }

    int getInt() {
        return this.number;
    }

    TimeZone getZone() {
        return this.zone;
    }

    public String toString() {
        if (this.isUNumber()) {
            return "U" + Integer.toString(this.getInt());
        }
        if (this.isIsoBase()) {
            return "I" + Integer.toString(this.getInt());
        }
        if (this.kind == 3) {
            return this.word;
        }
        if (this.kind == 4) {
            return new Character(this.c).toString();
        }
        if (this.kind == 12 || this.kind == 13) {
            return this.zone.getID();
        }
        return "(" + this.kind + "," + this.getInt() + ")";
    }
}

