/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Pipeline;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.channel.PipelineChannel;

public class CloseCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 1, argv, "channelId");
        }
        Channel chan = TclIO.getChannel(interp, argv[1].toString());
        if (chan == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        TclIO.unregisterChannel(interp, chan);
        if (chan.getBlocking() && chan instanceof PipelineChannel) {
            Pipeline pipeline = ((PipelineChannel)chan).getPipeline();
            int[] pids = pipeline.getProcessIdentifiers();
            int[] exitValues = pipeline.getExitValues();
            boolean errorReturned = false;
            int i = 0;
            while (i < exitValues.length) {
                if (exitValues[i] != 0) {
                    errorReturned = true;
                    interp.setErrorCode(TclString.newInstance("CHILDSTATUS " + pids[i] + " " + exitValues[i]));
                }
                ++i;
            }
            String stderrOutput = ((PipelineChannel)chan).getStderrOutput();
            if (stderrOutput.length() > 0) {
                errorReturned = true;
                if (stderrOutput.endsWith("\n")) {
                    stderrOutput = stderrOutput.substring(0, stderrOutput.length() - 1);
                }
            } else if (errorReturned) {
                stderrOutput = "child process exited abnormally";
            }
            if (errorReturned) {
                throw new TclException(interp, stderrOutput);
            }
            pipeline.throwAnyExceptions();
        }
    }
}

