/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.LinkedList;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDict;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class DictCmd
implements Command {
    private static final String[] options = new String[]{"append", "create", "exists", "filter", "for", "get", "incr", "info", "keys", "lappend", "merge", "remove", "replace", "set", "size", "unset", "update", "values", "with"};
    private static final Command[] subcommands = new Command[]{new AppendCmd(), new CreateCmd(), new ExistsCmd(), new FilterCmd(), new ForCmd(), new GetCmd(), new IncrCmd(), new InfoCmd(), new KeysCmd(), new LappendCmd(), new MergeCmd(), new RemoveCmd(), new ReplaceCmd(), new SetCmd(), new SizeCmd(), new UnsetCmd(), new UpdateCmd(), new ValuesCmd(), new WithCmd()};

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "subcommand ?arg ...?");
        }
        int index = TclIndex.get(interp, objv[1], options, "subcommand", 0);
        subcommands[index].cmdProc(interp, objv);
    }

    private static final class AppendCmd
    implements Command {
        private AppendCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "varName key ?value ...?");
            }
            TclObject dictObj = null;
            try {
                dictObj = interp.getVar(objv[2], 0);
            }
            catch (TclException tclException) {
                dictObj = TclDict.newInstance();
                dictObj.preserve();
            }
            if (objv.length == 4) {
                interp.setResult(dictObj);
                return;
            }
            if (dictObj.isShared()) {
                dictObj = dictObj.duplicate();
                dictObj.preserve();
            }
            TclObject key = objv[3];
            TclDict.appendToKey(interp, dictObj, key, objv, 4, objv.length);
            interp.setResult(interp.setVar(objv[2], dictObj, 0));
        }
    }

    private static final class CreateCmd
    implements Command {
        private CreateCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length % 2 != 0) {
                throw new TclNumArgsException(interp, 2, objv, "?key value ...?");
            }
            TclObject dict = TclDict.newInstance();
            if (objv.length > 2) {
                int i = 2;
                while (i < objv.length) {
                    TclDict.put(interp, dict, objv[i], objv[i + 1]);
                    i += 2;
                }
            }
            interp.setResult(dict);
        }
    }

    private static final class ExistsCmd
    implements Command {
        private ExistsCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary key ?key ...?");
            }
            TclObject dict = objv[2];
            int i = 3;
            while (i < objv.length) {
                if ((dict = TclDict.get(interp, dict, objv[i])) == null) {
                    interp.setResult(TclBoolean.newInstance(false));
                    return;
                }
                ++i;
            }
            interp.setResult(TclBoolean.newInstance(true));
        }
    }

    private static final class FilterCmd
    implements Command {
        private static final String[] filterTypes = new String[]{"key", "script", "value"};
        private static final int FILTER_KEY = 0;
        private static final int FILTER_SCRIPT = 1;
        private static final int FILTER_VALUE = 2;

        private FilterCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary filterType ...");
            }
            int index = TclIndex.get(interp, objv[3], filterTypes, "filterType", 0);
            switch (index) {
                case 0: {
                    if (objv.length != 5) {
                        throw new TclNumArgsException(interp, 2, objv, "dictionary key globPattern");
                    }
                    this.filterKey(interp, objv);
                    break;
                }
                case 1: {
                    if (objv.length != 6) {
                        throw new TclNumArgsException(interp, 2, objv, "dictionary script {keyVar valueVar} filterScript");
                    }
                    this.filterScript(interp, objv);
                    break;
                }
                case 2: {
                    if (objv.length != 5) {
                        throw new TclNumArgsException(interp, 2, objv, "dictionary value globPattern");
                    }
                    this.filterValue(interp, objv);
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected index");
                }
            }
        }

        private void filterKey(Interp interp, TclObject[] objv) throws TclException {
            TclObject srcDict = objv[2];
            final TclObject retDict = TclDict.newInstance();
            final String glob = objv[4].toString();
            TclDict.foreach(interp, null, srcDict, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    if (Util.stringMatch(key.toString(), glob)) {
                        TclDict.put(interp, retDict, key, val);
                    }
                    return null;
                }
            });
            interp.setResult(retDict);
        }

        private void filterScript(Interp interp, TclObject[] objv) throws TclException {
            TclObject srcDict = objv[2];
            final TclObject retDict = TclDict.newInstance();
            final TclObject[] vars = TclList.getElements(interp, objv[4]);
            final TclObject script = objv[5];
            if (vars.length != 2) {
                throw new TclException(interp, "must have exactly two variable names");
            }
            TclDict.foreach(interp, null, srcDict, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    interp.setVar(vars[0], key, 0);
                    interp.setVar(vars[1], val, 0);
                    try {
                        interp.eval(script, 0);
                    }
                    catch (TclException e) {
                        if (e.getCompletionCode() == 1) {
                            interp.addErrorInfo("\n    (\"dict filter\" script line " + interp.errorLine + ")");
                        }
                        throw e;
                    }
                    if (TclBoolean.get(interp, interp.getResult())) {
                        TclDict.put(interp, retDict, key, val);
                    }
                    return null;
                }
            });
            interp.setResult(retDict);
        }

        private void filterValue(Interp interp, TclObject[] objv) throws TclException {
            TclObject srcDict = objv[2];
            final TclObject retDict = TclDict.newInstance();
            final String glob = objv[4].toString();
            TclDict.foreach(interp, null, srcDict, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    if (Util.stringMatch(val.toString(), glob)) {
                        TclDict.put(interp, retDict, key, val);
                    }
                    return null;
                }
            });
            interp.setResult(retDict);
        }
    }

    private static final class ForCmd
    implements Command {
        private ForCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 5) {
                throw new TclNumArgsException(interp, 2, objv, "{keyVar valueVar} dictionary script");
            }
            final TclObject[] vars = TclList.getElements(interp, objv[2]);
            TclObject dict = objv[3];
            final TclObject script = objv[4];
            if (vars.length != 2) {
                throw new TclException(interp, "must have exactly two variable names");
            }
            TclDict.foreach(interp, null, dict, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    interp.setVar(vars[0], key, 0);
                    interp.setVar(vars[1], val, 0);
                    try {
                        interp.eval(script, 0);
                    }
                    catch (TclException e) {
                        if (e.getCompletionCode() == 1) {
                            interp.addErrorInfo("\n    (\"dict for\" body line " + interp.errorLine + ")");
                        }
                        throw e;
                    }
                    return null;
                }
            });
        }
    }

    private static final class GetCmd
    implements Command {
        private GetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 3) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary ?key key ...?");
            }
            TclObject dict = objv[2];
            if (objv.length == 3) {
                interp.setResult(dict);
                return;
            }
            int i = 3;
            while (i < objv.length) {
                if ((dict = TclDict.get(interp, dict, objv[i])) == null) {
                    throw new TclException(interp, "key \"" + objv[i].toString() + "\" not known in dictionary");
                }
                ++i;
            }
            interp.setResult(dict);
        }
    }

    private static final class IncrCmd
    implements Command {
        private IncrCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            TclObject value;
            if (objv.length < 4 || objv.length > 5) {
                throw new TclNumArgsException(interp, 2, objv, "varName key ?increment?");
            }
            TclObject dictObj = null;
            try {
                dictObj = interp.getVar(objv[2], 0);
            }
            catch (TclException tclException) {
                dictObj = TclDict.newInstance();
                dictObj.preserve();
            }
            TclObject key = objv[3];
            int increment = 1;
            if (objv.length == 5) {
                increment = TclInteger.get(interp, objv[4]);
            }
            if (dictObj.isShared()) {
                dictObj = dictObj.duplicate();
            }
            if ((value = TclDict.get(interp, dictObj, key)) == null) {
                value = TclInteger.newInstance(0L);
            }
            if (value.isShared()) {
                value = value.duplicate();
            }
            TclInteger.incr(interp, value, increment);
            TclDict.put(interp, dictObj, key, value);
            interp.setResult(interp.setVar(objv[2], dictObj, 0));
        }
    }

    private static final class InfoCmd
    implements Command {
        private InfoCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 3) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary");
            }
            final StringBuffer buf = new StringBuffer();
            int size = TclDict.size(interp, objv[2]);
            buf.append(size + " entries in table\n");
            buf.append("Entries (and ref-counts):\n");
            TclDict.foreach(interp, null, objv[2], new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    buf.append(String.valueOf(key.toString()) + "(" + key.getRefCount() + ") = " + val.toString() + "(" + val.getRefCount() + ")\n");
                    return null;
                }
            });
            interp.setResult(buf.toString());
        }
    }

    private static final class KeysCmd
    implements Command {
        private KeysCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 3 || objv.length > 4) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary ?pattern?");
            }
            TclObject dict = objv[2];
            final String glob = objv.length == 4 ? objv[3].toString() : null;
            final TclObject result = TclList.newInstance();
            TclDict.foreach(interp, null, dict, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    if (glob == null || Util.stringMatch(key.toString(), glob)) {
                        TclList.append(interp, result, key);
                    }
                    return null;
                }
            });
            interp.setResult(result);
        }
    }

    private static final class LappendCmd
    implements Command {
        private LappendCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            TclObject key;
            TclObject list;
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "varName key ?value ...?");
            }
            TclObject dictObj = null;
            try {
                dictObj = interp.getVar(objv[2], 0);
            }
            catch (TclException tclException) {
                dictObj = TclDict.newInstance();
                dictObj.preserve();
            }
            if (objv.length == 4) {
                interp.setResult(dictObj);
                return;
            }
            if (dictObj.isShared()) {
                dictObj = dictObj.duplicate();
            }
            if ((list = TclDict.get(interp, dictObj, key = objv[3])) == null) {
                list = TclList.newInstance();
                list.preserve();
            } else if (list.isShared()) {
                list = list.duplicate();
                list.preserve();
            }
            int i = 4;
            while (i < objv.length) {
                TclList.append(interp, list, objv[i]);
                ++i;
            }
            TclDict.put(interp, dictObj, key, list);
            dictObj.invalidateStringRep();
            interp.setResult(interp.setVar(objv[2], dictObj, 0));
        }
    }

    private static final class MergeCmd
    implements Command {
        private MergeCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            final TclObject retDict = TclDict.newInstance();
            int i = 2;
            while (i < objv.length) {
                TclDict.foreach(interp, null, objv[i], new TclDict.Visitor(){

                    @Override
                    public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                        TclDict.put(interp, retDict, key, val);
                        return null;
                    }
                });
                ++i;
            }
            interp.setResult(retDict);
        }
    }

    private static final class RemoveCmd
    implements Command {
        private RemoveCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 3) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary ?key ...?");
            }
            TclObject dict = objv[2];
            if (dict.isShared()) {
                dict = dict.duplicate();
            }
            int i = 3;
            while (i < objv.length) {
                TclDict.remove(interp, dict, objv[i]);
                ++i;
            }
            interp.setResult(dict);
        }
    }

    private static final class ReplaceCmd
    implements Command {
        private ReplaceCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 3 || objv.length % 2 != 1) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary ?key value ...?");
            }
            TclObject dict = objv[2];
            if (dict.isShared()) {
                dict = dict.duplicate();
            }
            int i = 3;
            while (i < objv.length) {
                TclDict.put(interp, dict, objv[i], objv[i + 1]);
                i += 2;
            }
            interp.setResult(dict);
        }
    }

    private static final class SetCmd
    implements Command {
        private SetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 5) {
                throw new TclNumArgsException(interp, 2, objv, "varName key ?key ...? value");
            }
            TclObject dict = null;
            try {
                dict = interp.getVar(objv[2], 0);
            }
            catch (TclException tclException) {
                dict = TclDict.newInstance();
                dict.preserve();
            }
            if (dict.isShared()) {
                dict = dict.duplicate();
            }
            TclObject value = objv[objv.length - 1];
            TclDict.putKeyList(interp, dict, objv, 3, objv.length - 4, value);
            dict.invalidateStringRep();
            interp.setResult(interp.setVar(objv[2], dict, 0));
        }
    }

    private static final class SizeCmd
    implements Command {
        private SizeCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 3) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary");
            }
            interp.setResult(TclDict.size(interp, objv[2]));
        }
    }

    private static final class UnsetCmd
    implements Command {
        private UnsetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "varName key ?key ...?");
            }
            TclObject dict = null;
            try {
                dict = interp.getVar(objv[2], 0);
            }
            catch (TclException tclException) {
                dict = TclDict.newInstance();
                dict.preserve();
            }
            if (dict.isShared()) {
                dict = dict.duplicate();
            }
            TclDict.removeKeyList(interp, dict, objv, 3, objv.length - 3);
            dict.invalidateStringRep();
            interp.setResult(interp.setVar(objv[2], dict, 0));
        }
    }

    private static final class UpdateCmd
    implements Command {
        private UpdateCmd() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            block29: {
                if (objv.length < 5 || objv.length % 2 != 0) {
                    throw new TclNumArgsException(interp, 2, objv, "varName key varName ?key varName ...? script");
                }
                dict = null;
                try {
                    dict = interp.getVar(objv[2], 0);
                }
                catch (TclException v0) {
                    dict = TclDict.newInstance();
                    dict.preserve();
                }
                i = 3;
                while (i < objv.length - 1) {
                    val = TclDict.get(interp, dict, objv[i]);
                    if (val != null) {
                        interp.setVar(objv[i + 1], val, 0);
                    } else {
                        try {
                            interp.unsetVar(objv[i + 1], 0);
                        }
                        catch (TclException v1) {}
                    }
                    i += 2;
                }
                script = objv[objv.length - 1];
                try {
                    try {
                        interp.eval(script, 0);
                        break block29;
                    }
                    catch (TclException e) {
                        if (e.getCompletionCode() == 1) {
                            interp.addErrorInfo("\n    (body of \"dict update\")");
                        }
                        throw e;
                    }
                }
                catch (Throwable var6_8) {
                    try {
                        interp.getVar(objv[2], 0);
                    }
                    catch (TclException v2) {
                        interp.resetResult();
                        return;
                    }
                    if (dict.isShared()) {
                        dict = dict.duplicate();
                    }
                    i = 3;
                    ** while (i < objv.length - 1)
                }
lbl-1000:
                // 1 sources

                {
                    newVal = null;
                    try {
                        newVal = interp.getVar(objv[i + 1], 0);
                    }
                    catch (TclException v3) {
                        newVal = null;
                    }
                    if (newVal != null) {
                        TclDict.put(interp, dict, objv[i], newVal);
                    } else {
                        TclDict.remove(interp, dict, objv[i]);
                    }
                    i += 2;
                    continue;
                }
lbl56:
                // 1 sources

                interp.setResult(interp.setVar(objv[2], dict, 0));
                throw var6_8;
            }
            try {
                interp.getVar(objv[2], 0);
            }
            catch (TclException v4) {
                interp.resetResult();
                return;
            }
            if (dict.isShared()) {
                dict = dict.duplicate();
            }
            i = 3;
            while (i < objv.length - 1) {
                newVal = null;
                try {
                    newVal = interp.getVar(objv[i + 1], 0);
                }
                catch (TclException v5) {
                    newVal = null;
                }
                if (newVal != null) {
                    TclDict.put(interp, dict, objv[i], newVal);
                } else {
                    TclDict.remove(interp, dict, objv[i]);
                }
                i += 2;
            }
            interp.setResult(interp.setVar(objv[2], dict, 0));
        }
    }

    private static final class ValuesCmd
    implements Command {
        private ValuesCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 3 || objv.length > 4) {
                throw new TclNumArgsException(interp, 2, objv, "dictionary ?pattern?");
            }
            TclObject dict = objv[2];
            final String glob = objv.length == 4 ? objv[3].toString() : null;
            final TclObject result = TclList.newInstance();
            TclDict.foreach(interp, null, dict, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    if (glob == null || Util.stringMatch(val.toString(), glob)) {
                        TclList.append(interp, result, val);
                    }
                    return null;
                }
            });
            interp.setResult(result);
        }
    }

    private static final class WithCmd
    implements Command {
        private WithCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "dictVar ?key ...? script");
            }
            TclObject dict = interp.getVar(objv[2], 0);
            TclObject script = objv[objv.length - 1];
            TclObject current = dict;
            int i = 3;
            while (i < objv.length - 1) {
                if ((current = TclDict.get(interp, current, objv[i])) == null) {
                    throw new TclException(interp, "key \"" + objv[i].toString() + "\" not known in dictionary");
                }
                ++i;
            }
            dict.preserve();
            final LinkedList keyList = new LinkedList();
            TclDict.foreach(interp, null, current, new TclDict.Visitor(){

                @Override
                public Object visit(Interp interp, Object accum, TclObject key, TclObject val) throws TclException {
                    interp.setVar(key, val, 0);
                    keyList.add(key);
                    return null;
                }
            });
            try {
                interp.eval(script, 0);
            }
            catch (TclException e) {
                if (e.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (body of \"dict with\")");
                }
                throw e;
            }
            try {
                interp.getVar(objv[2], 0);
            }
            catch (TclException tclException) {
                interp.resetResult();
                return;
            }
            TclObject tmp = TclDict.newInstance();
            for (TclObject key : keyList) {
                TclObject val = null;
                try {
                    val = interp.getVar(key, 0);
                }
                catch (TclException tclException) {
                    val = null;
                }
                if (val == null) continue;
                TclDict.put(interp, tmp, key, val);
            }
            if (objv.length == 4) {
                dict = tmp;
            } else {
                if (dict.isShared()) {
                    dict = dict.duplicate();
                    dict.preserve();
                }
                current = dict;
                int i2 = 3;
                while (i2 < objv.length - 2) {
                    TclObject next = TclDict.get(interp, current, objv[i2]);
                    if (next == null) {
                        interp.resetResult();
                        return;
                    }
                    if (next.isShared()) {
                        next = next.duplicate();
                        next.preserve();
                        TclDict.put(interp, current, objv[i2], next);
                    }
                    current = next;
                    ++i2;
                }
                TclDict.put(interp, current, objv[objv.length - 2], tmp);
            }
            interp.setResult(interp.setVar(objv[2], dict, 0));
        }
    }
}

