/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public class EncodingCmd
implements Command {
    public static String systemTclEncoding = null;
    public static String systemJavaEncoding = null;
    static Hashtable<String, EncodingMap> encodeHash;
    static EncodingMap[] encodings;
    private static final char[] symbolEncoding0x40to0x7A;
    private static final char[] symbolEncoding0xA0to0xFF;
    private static final String[] validCmds;
    static final int OPT_CONVERTFROM = 0;
    static final int OPT_CONVERTTO = 1;
    static final int OPT_NAMES = 2;
    static final int OPT_SYSTEM = 3;

    static {
        encodings = new EncodingMap[]{new EncodingMap("identity", "UTF8", 1), new EncodingMap("symbol", "ASCII", 1), new EncodingMap("utf-8", "UTF8", 1), new EncodingMap("utf-16", "UTF16", 2), new EncodingMap("unicode", "ISO-10646-UCS-2", 2), new EncodingMap("ascii", "ASCII", 1), new EncodingMap("big5", "Big5", 0), new EncodingMap("cp1250", "Cp1250", 1), new EncodingMap("cp1251", "Cp1251", 1), new EncodingMap("ansi-1251", "Cp1251", 1), new EncodingMap("cp1252", "Cp1252", 1), new EncodingMap("cp1253", "Cp1253", 1), new EncodingMap("cp1254", "Cp1254", 1), new EncodingMap("cp1255", "Cp1255", 1), new EncodingMap("cp1256", "Cp1256", 1), new EncodingMap("cp1257", "Cp1257", 1), new EncodingMap("cp1258", "Cp1258", 1), new EncodingMap("cp437", "Cp437", 1), new EncodingMap("cp737", "Cp737", 1), new EncodingMap("cp775", "Cp775", 1), new EncodingMap("cp850", "Cp850", 1), new EncodingMap("cp852", "Cp852", 1), new EncodingMap("cp855", "Cp855", 1), new EncodingMap("cp857", "Cp857", 1), new EncodingMap("cp860", "Cp860", 1), new EncodingMap("cp861", "Cp861", 1), new EncodingMap("cp862", "Cp862", 1), new EncodingMap("cp863", "Cp863", 1), new EncodingMap("cp864", "Cp864", 1), new EncodingMap("cp865", "Cp865", 1), new EncodingMap("cp866", "Cp866", 1), new EncodingMap("cp869", "Cp869", 1), new EncodingMap("cp874", "Cp874", 1), new EncodingMap("cp932", "Cp943", 0), new EncodingMap("cp936", "Cp936", 0), new EncodingMap("cp949", "Cp949", 0), new EncodingMap("cp950", "Cp950", 0), new EncodingMap("euc-cn", "EUC_cn", 0), new EncodingMap("euc-jp", "EUC_jp", 0), new EncodingMap("euc-kr", "EUC_kr", 0), new EncodingMap("iso2022", "ISO-2022-JP-2", -1), new EncodingMap("iso2022-jp", "ISO-2022-JP-2", -1), new EncodingMap("iso2022-kr", "ISO2022KR", -1), new EncodingMap("iso8859-1", "ISO-8859-1", 1), new EncodingMap("ansi_x3.4-1968", "ISO-8859-1", 1), new EncodingMap("iso8859-2", "ISO-8859-2", 1), new EncodingMap("iso8859-3", "ISO-8859-3", 1), new EncodingMap("iso8859-4", "ISO-8859-4", 1), new EncodingMap("iso8859-5", "ISO-8859-5", 1), new EncodingMap("iso8859-6", "ISO-8859-6", 1), new EncodingMap("iso8859-7", "ISO-8859-7", 1), new EncodingMap("iso8859-8", "ISO-8859-8", 1), new EncodingMap("iso8859-9", "ISO-8859-9", 1), new EncodingMap("iso8859-10", "ISO-8859-10", 1), new EncodingMap("iso8859-11", "ISO-8859-11", 1), new EncodingMap("iso8859-12", "ISO-8859-12", 1), new EncodingMap("iso8859-13", "ISO-8859-13", 1), new EncodingMap("iso8859-14", "ISO-8859-14", 1), new EncodingMap("iso8859-15", "ISO-8859-15", 1), new EncodingMap("jis0201", "JIS0201", 1), new EncodingMap("jis0208", "JIS0208", 2), new EncodingMap("jis0212", "JIS0212", 2), new EncodingMap("koi8-r", "KOI8_r", 1), new EncodingMap("macCentEuro", "MacCentEuro", 1), new EncodingMap("macCroatian", "MacCroatian", 1), new EncodingMap("macCyrillic", "MacCyrillic", 1), new EncodingMap("macDingbats", "MacDingbats", 1), new EncodingMap("macGreek", "MacGreek", 1), new EncodingMap("macIceland", "MacIceland", 1), new EncodingMap("macJapan", "MacJapan", 0), new EncodingMap("macRoman", "MacRoman", 1), new EncodingMap("macRomania", "MacRomania", 1), new EncodingMap("macSymbol", "MacSymbol", 1), new EncodingMap("macThai", "MacThai", 1), new EncodingMap("macTurkish", "MacTurkish", 1), new EncodingMap("macUkraine", "MacUkraine", 1), new EncodingMap("shiftjis", "Shift_JIS", 0)};
        encodeHash = new Hashtable();
        int i = 0;
        while (i < encodings.length) {
            EncodingMap map = encodings[i];
            String tclKey = "tcl," + map.tclName;
            String javaKey = "java," + map.javaName;
            encodeHash.put(tclKey, map);
            encodeHash.put(javaKey, map);
            ++i;
        }
        Charset defaultCharset = Charset.defaultCharset();
        Set<String> aliases = defaultCharset.aliases();
        ArrayList<String> all = new ArrayList<String>(aliases.size() + 1);
        all.add(defaultCharset.name());
        all.addAll(aliases);
        Iterator iterator = all.iterator();
        String enc = null;
        while (iterator.hasNext()) {
            enc = (String)iterator.next();
            String key = "java," + enc;
            EncodingMap map = encodeHash.get(key);
            if (map == null) {
                enc = null;
                continue;
            }
            systemTclEncoding = map.tclName;
            systemJavaEncoding = map.javaName;
            break;
        }
        if (enc == null || enc.length() == 0) {
            systemTclEncoding = "iso8859-1";
            systemJavaEncoding = "ISO-8859-1";
        }
        symbolEncoding0x40to0x7A = new char[]{'\u2245', '\u0391', '\u0392', '\u03a7', '\u0394', '\u0395', '\u03a6', '\u0393', '\u0397', '\u0399', '\u03d1', '\u039a', '\u039b', '\u039c', '\u039d', '\u039f', '\u03a0', '\u0398', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03c2', '\u03a9', '\u039e', '\u03a8', '\u0396', '[', '\u2234', ']', '\u22a5', '_', '\uf8e5', '\u03b1', '\u03b2', '\u03c7', '\u03b4', '\u03b5', '\u03c6', '\u03b3', '\u03b7', '\u03b9', '\u03d5', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03bf', '\u03c0', '\u03b8', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03d6', '\u03c9', '\u03be', '\u03c8', '\u03b6'};
        char[] cArray = new char[96];
        cArray[1] = 978;
        cArray[2] = 8242;
        cArray[3] = 8804;
        cArray[4] = 8260;
        cArray[5] = 8734;
        cArray[6] = 402;
        cArray[7] = 9827;
        cArray[8] = 9830;
        cArray[9] = 9829;
        cArray[10] = 9824;
        cArray[11] = 8596;
        cArray[12] = 8592;
        cArray[13] = 8593;
        cArray[14] = 8594;
        cArray[15] = 8595;
        cArray[16] = 176;
        cArray[17] = 177;
        cArray[18] = 8243;
        cArray[19] = 8805;
        cArray[20] = 215;
        cArray[21] = 8733;
        cArray[22] = 8706;
        cArray[23] = 8226;
        cArray[24] = 247;
        cArray[25] = 8800;
        cArray[26] = 8801;
        cArray[27] = 8776;
        cArray[28] = 8230;
        cArray[29] = 63718;
        cArray[30] = 63719;
        cArray[31] = 8629;
        cArray[32] = 8501;
        cArray[33] = 8465;
        cArray[34] = 8476;
        cArray[35] = 8472;
        cArray[36] = 8855;
        cArray[37] = 8853;
        cArray[38] = 8709;
        cArray[39] = 8745;
        cArray[40] = 8746;
        cArray[41] = 8835;
        cArray[42] = 8839;
        cArray[43] = 8836;
        cArray[44] = 8834;
        cArray[45] = 8838;
        cArray[46] = 8712;
        cArray[47] = 8713;
        cArray[48] = 8736;
        cArray[49] = 8711;
        cArray[50] = 174;
        cArray[51] = 169;
        cArray[52] = 8482;
        cArray[53] = 8719;
        cArray[54] = 8730;
        cArray[55] = 8901;
        cArray[56] = 172;
        cArray[57] = 8743;
        cArray[58] = 8744;
        cArray[59] = 8660;
        cArray[60] = 8656;
        cArray[61] = 8657;
        cArray[62] = 8658;
        cArray[63] = 8659;
        cArray[64] = 8900;
        cArray[65] = 9001;
        cArray[66] = 63720;
        cArray[67] = 63721;
        cArray[68] = 63722;
        cArray[69] = 8721;
        cArray[70] = 63723;
        cArray[71] = 63724;
        cArray[72] = 63725;
        cArray[73] = 63726;
        cArray[74] = 63727;
        cArray[75] = 63728;
        cArray[76] = 63729;
        cArray[77] = 63730;
        cArray[78] = 63731;
        cArray[79] = 63732;
        cArray[80] = 63743;
        cArray[81] = 9002;
        cArray[82] = 8747;
        cArray[83] = 8992;
        cArray[84] = 63733;
        cArray[85] = 8993;
        cArray[86] = 63734;
        cArray[87] = 63735;
        cArray[88] = 63736;
        cArray[89] = 63737;
        cArray[90] = 63738;
        cArray[91] = 63739;
        cArray[92] = 63740;
        cArray[93] = 63741;
        cArray[94] = 63742;
        symbolEncoding0xA0to0xFF = cArray;
        validCmds = new String[]{"convertfrom", "convertto", "names", "system"};
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg ...?");
        }
        int index = TclIndex.get(interp, objv[1], validCmds, "option", 0);
        switch (index) {
            case 0: 
            case 1: {
                TclObject data;
                String tclEncoding;
                if (objv.length == 3) {
                    tclEncoding = systemTclEncoding;
                    data = objv[2];
                } else if (objv.length == 4) {
                    tclEncoding = objv[2].toString();
                    data = objv[3];
                } else {
                    throw new TclNumArgsException(interp, 2, objv, "?encoding? data");
                }
                String javaEncoding = EncodingCmd.getJavaName(tclEncoding);
                if (javaEncoding == null) {
                    throw new TclException(interp, "unknown encoding \"" + tclEncoding + "\"");
                }
                try {
                    if (index == 0) {
                        if (tclEncoding.equals("identity")) {
                            TclByteArray.getLength(interp, data);
                            interp.setResult(data);
                            break;
                        }
                        if (tclEncoding.equals("symbol")) {
                            char[] cbuf = new char[TclByteArray.getLength(interp, data)];
                            EncodingCmd.decodeSymbol(TclByteArray.getBytes(interp, data), cbuf, 0, cbuf.length);
                            interp.setResult(new String(cbuf));
                            break;
                        }
                        interp.setResult(TclByteArray.decodeToString(interp, data, tclEncoding));
                        break;
                    }
                    if (tclEncoding.equals("identity")) {
                        if (data.isByteArrayType()) {
                            interp.setResult(data);
                            break;
                        }
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.toString().length() * 3);
                        DataOutputStream dos = new DataOutputStream(bos);
                        dos.writeUTF(data.toString());
                        byte[] bytes = bos.toByteArray();
                        interp.setResult(TclByteArray.newInstance(bytes, 2, bytes.length - 2));
                        break;
                    }
                    if (tclEncoding.equals("symbol")) {
                        byte[] bbuf = EncodingCmd.encodeSymbol(data.toString().toCharArray(), 0, data.toString().length());
                        interp.setResult(TclByteArray.newInstance(bbuf, 0, bbuf.length));
                        break;
                    }
                    TclObject rv = TclByteArray.newInstance(data.toString().getBytes(javaEncoding));
                    interp.setResult(rv);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new TclException(interp, "Encoding.cmdProc() error: unsupported java encoding \"" + javaEncoding + "\"");
                }
                catch (IOException e) {
                    throw new TclException(interp, e.getMessage());
                }
            }
            case 2: {
                if (objv.length > 2) {
                    throw new TclNumArgsException(interp, 2, objv, null);
                }
                TclObject list = TclList.newInstance();
                int i = 0;
                while (i < encodings.length) {
                    EncodingMap map = encodings[i];
                    if (EncodingCmd.isSupported(map.javaName)) {
                        TclList.append(interp, list, TclString.newInstance(map.tclName));
                    }
                    ++i;
                }
                interp.setResult(list);
                break;
            }
            case 3: {
                if (objv.length > 3) {
                    throw new TclNumArgsException(interp, 2, objv, "?encoding?");
                }
                if (objv.length == 2) {
                    interp.setResult(systemTclEncoding);
                    break;
                }
                String tclEncoding = objv[2].toString();
                String javaEncoding = EncodingCmd.getJavaName(tclEncoding);
                if (javaEncoding == null) {
                    throw new TclException(interp, "unknown encoding \"" + tclEncoding + "\"");
                }
                if (!EncodingCmd.isSupported(javaEncoding)) {
                    throw new TclException(interp, "Encoding.cmdProc() error: unsupported java encoding \"" + javaEncoding + "\"");
                }
                systemTclEncoding = tclEncoding;
                systemJavaEncoding = javaEncoding;
                if (!interp.systemEncodingChangesStdoutStderr) break;
                Channel chan = TclIO.getChannel(interp, "stdout");
                if (chan != null) {
                    chan.setEncoding(systemJavaEncoding);
                }
                if ((chan = TclIO.getChannel(interp, "stderr")) != null) {
                    chan.setEncoding(systemJavaEncoding);
                }
                interp.systemEncodingChangesStdoutStderr = true;
                break;
            }
            default: {
                throw new TclRuntimeError("Encoding.cmdProc() error: incorrect index returned from TclIndex.get()");
            }
        }
    }

    public static int getBytesPerChar(String name) {
        String key = "java," + name;
        EncodingMap map = encodeHash.get(key);
        if (map == null) {
            throw new RuntimeException("Invalid encoding \"" + name + "\"");
        }
        return map.bytesPerChar;
    }

    public static String getJavaName(String name) {
        String key = "tcl," + name;
        EncodingMap map = encodeHash.get(key);
        if (map == null) {
            return null;
        }
        return map.javaName;
    }

    static String getTclName(String name) {
        String key = "java," + name;
        EncodingMap map = encodeHash.get(key);
        if (map == null) {
            return null;
        }
        return map.tclName;
    }

    static boolean isSupported(String name) {
        Charset cs;
        String key = "java," + name;
        EncodingMap map = encodeHash.get(key);
        if (map == null) {
            return false;
        }
        try {
            cs = Charset.forName(name);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new TclRuntimeError("illegal charset name \"" + name + "\"");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return false;
        }
        return cs.canEncode();
    }

    public static void decodeSymbol(byte[] bbuf, char[] cbuf, int off, int len) {
        int i = 0;
        while (i < len) {
            int byteVal = bbuf[i] & 0xFF;
            cbuf[i + off] = byteVal < 64 ? (char)byteVal : (byteVal < 123 ? symbolEncoding0x40to0x7A[byteVal - 64] : (byteVal < 160 ? (char)byteVal : symbolEncoding0xA0to0xFF[byteVal - 160]));
            ++i;
        }
    }

    public static byte[] encodeSymbol(char[] cbuf, int off, int len) {
        byte[] bbuf = new byte[len];
        int i = off;
        while (i < off + len) {
            if (cbuf[i] <= '\u00ff') {
                bbuf[i - off] = (byte)(cbuf[i] & 0xFF);
            } else {
                boolean notFound = true;
                int j = 0;
                while (notFound && j < symbolEncoding0x40to0x7A.length) {
                    if (cbuf[i] == symbolEncoding0x40to0x7A[j]) {
                        notFound = false;
                        bbuf[i - off] = (byte)(j + 64);
                    }
                    ++j;
                }
                j = 0;
                while (notFound && j < symbolEncoding0xA0to0xFF.length) {
                    if (cbuf[i] == symbolEncoding0xA0to0xFF[j]) {
                        notFound = false;
                        bbuf[i - off] = (byte)(j + 160);
                    }
                    ++j;
                }
                if (notFound) {
                    bbuf[i - off] = 63;
                }
            }
            ++i;
        }
        return bbuf;
    }

    static class EncodingMap {
        String tclName;
        String javaName;
        int bytesPerChar;

        public EncodingMap(String tclName, String javaName, int bytesPerChar) {
            this.tclName = tclName;
            this.javaName = javaName;
            this.bytesPerChar = bytesPerChar;
        }
    }
}

