/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Pipeline;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.TclByteArrayChannel;
import tcl.lang.process.Redirect;

public class ExecCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean keepNewline = false;
        int firstWord = 1;
        while (firstWord < argv.length) {
            String argStr = argv[firstWord].toString();
            if (argStr.length() <= 0 || argStr.charAt(0) != '-') break;
            if (!argStr.equals("-keepnewline")) {
                if (argStr.equals("--")) {
                    ++firstWord;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + argStr + "\": must be -keepnewline or --");
            }
            keepNewline = true;
            ++firstWord;
        }
        if (argv.length <= firstWord) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? arg ?arg ...?");
        }
        Pipeline pipeline = new Pipeline(interp, argv, firstWord);
        if (pipeline.getStdinRedirect() == null) {
            pipeline.setStdinRedirect(Redirect.inherit());
        }
        TclByteArrayChannel stdoutChannel = null;
        if (pipeline.getStdoutRedirect() == null && !pipeline.isExecInBackground()) {
            stdoutChannel = new TclByteArrayChannel(interp);
            pipeline.setStdoutRedirect(new Redirect(stdoutChannel, false));
        }
        TclByteArrayChannel stderrChannel = null;
        if (pipeline.getStderrRedirect() == null && !pipeline.isExecInBackground()) {
            stderrChannel = new TclByteArrayChannel(interp);
            pipeline.setStderrRedirect(new Redirect(stderrChannel, false));
        }
        pipeline.exec();
        if (pipeline.isExecInBackground()) {
            int[] pids;
            TclObject rv = TclList.newInstance();
            int[] nArray = pids = pipeline.getProcessIdentifiers();
            int n = pids.length;
            int n2 = 0;
            while (n2 < n) {
                int pid = nArray[n2];
                TclList.append(interp, rv, TclInteger.newInstance(pid));
                ++n2;
            }
            interp.setResult(rv);
            Thread t = new Thread(pipeline);
            t.setDaemon(true);
            t.setName("ExecCmd background pipeline (" + interp.toString() + ")");
            t.start();
            pipeline.throwAnyExceptions();
            return;
        }
        pipeline.waitForExitAndCleanup(false);
        boolean errorReturned = false;
        String stderrString = "";
        String stdoutString = "";
        if (stderrChannel != null) {
            try {
                stderrChannel.close();
            }
            catch (IOException e) {
                throw new TclException(interp, e.getMessage());
            }
            stderrString = stderrChannel.getTclString().toString();
            boolean bl = errorReturned = stderrString.length() > 0 && !pipeline.isErrorRedirectedToResult();
        }
        if (stdoutChannel != null) {
            try {
                stdoutChannel.close();
            }
            catch (IOException e) {
                throw new TclException(interp, e.getMessage());
            }
            stdoutString = stdoutChannel.getTclString().toString();
        }
        int[] pids = pipeline.getProcessIdentifiers();
        int[] exitValues = pipeline.getExitValues();
        int i = 0;
        while (i < exitValues.length) {
            if (exitValues[i] != 0) {
                errorReturned = true;
                interp.setErrorCode(TclString.newInstance("CHILDSTATUS " + pids[i] + " " + exitValues[i]));
            }
            ++i;
        }
        if (errorReturned) {
            if (stderrString.length() == 0) {
                stderrString = "child process exited abnormally";
            }
            if (!keepNewline && stderrString.endsWith("\n")) {
                stderrString = stderrString.substring(0, stderrString.length() - 1);
            }
            throw new TclException(interp, String.valueOf(stdoutString) + stderrString);
        }
        if (!keepNewline && stdoutString.endsWith("\n")) {
            stdoutString = stdoutString.substring(0, stdoutString.length() - 1);
        }
        if (!keepNewline && stderrString.endsWith("\n")) {
            stderrString = stderrString.substring(0, stderrString.length() - 1);
        }
        if (pipeline.isErrorRedirectedToResult()) {
            interp.setResult(String.valueOf(stderrString) + stdoutString);
        } else {
            interp.setResult(stdoutString);
        }
        pipeline.throwAnyExceptions();
    }
}

