/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.AbstractSocketChannel;
import tcl.lang.channel.Channel;
import tcl.lang.channel.SocketChannel;
import tcl.lang.cmd.EncodingCmd;

public class FconfigureCmd
implements Command {
    private static final String[] commonValidCommands = new String[]{"-blocking", "-buffering", "-buffersize", "-encoding", "-eofchar", "-translation"};
    private static final String[] socketValidCommands = new String[]{"-blocking", "-buffering", "-buffersize", "-encoding", "-eofchar", "-translation", "-peername", "-sockname"};
    static final int OPT_BLOCKING = 0;
    static final int OPT_BUFFERING = 1;
    static final int OPT_BUFFERSIZE = 2;
    static final int OPT_ENCODING = 3;
    static final int OPT_EOFCHAR = 4;
    static final int OPT_TRANSLATION = 5;
    static final int OPT_PEERNAME = 6;
    static final int OPT_SOCKNAME = 7;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String javaEncoding;
        String[] validCmds;
        if (argv.length < 2 || argv.length % 2 == 1 && argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "channelId ?optionName? ?value? ?optionName value?...");
        }
        Channel chan = TclIO.getChannel(interp, argv[1].toString());
        if (chan == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        String[] stringArray = validCmds = chan instanceof AbstractSocketChannel ? socketValidCommands : commonValidCommands;
        if (argv.length == 2) {
            TclObject list = TclList.newInstance();
            TclList.append(interp, list, TclString.newInstance("-blocking"));
            TclList.append(interp, list, TclBoolean.newInstance(chan.getBlocking()));
            TclList.append(interp, list, TclString.newInstance("-buffering"));
            TclList.append(interp, list, TclString.newInstance(TclIO.getBufferingString(chan.getBuffering())));
            TclList.append(interp, list, TclString.newInstance("-buffersize"));
            TclList.append(interp, list, TclInteger.newInstance(chan.getBufferSize()));
            TclList.append(interp, list, TclString.newInstance("-encoding"));
            javaEncoding = chan.getEncoding();
            String tclEncoding = javaEncoding == null ? "binary" : EncodingCmd.getTclName(javaEncoding);
            TclList.append(interp, list, TclString.newInstance(tclEncoding));
            TclList.append(interp, list, TclString.newInstance("-eofchar"));
            if (chan.isReadOnly()) {
                eofChar = chan.getInputEofChar();
                TclList.append(interp, list, eofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(eofChar));
            } else if (chan.isWriteOnly()) {
                eofChar = chan.getOutputEofChar();
                TclList.append(interp, list, eofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(eofChar));
            } else if (chan.isReadWrite()) {
                char inEofChar = chan.getInputEofChar();
                char outEofChar = chan.getOutputEofChar();
                TclObject eofchar_pair = TclList.newInstance();
                TclList.append(interp, eofchar_pair, inEofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(inEofChar));
                TclList.append(interp, eofchar_pair, outEofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(outEofChar));
                TclList.append(interp, list, eofchar_pair);
            } else {
                eofChar = chan.getInputEofChar();
                TclList.append(interp, list, eofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(eofChar));
            }
            TclList.append(interp, list, TclString.newInstance("-translation"));
            if (chan.isReadOnly()) {
                TclList.append(interp, list, TclString.newInstance(TclIO.getTranslationString(chan.getInputTranslation())));
            } else if (chan.isWriteOnly()) {
                TclList.append(interp, list, TclString.newInstance(TclIO.getTranslationString(chan.getOutputTranslation())));
            } else if (chan.isReadWrite()) {
                TclObject translation_pair = TclList.newInstance();
                TclList.append(interp, translation_pair, TclString.newInstance(TclIO.getTranslationString(chan.getInputTranslation())));
                TclList.append(interp, translation_pair, TclString.newInstance(TclIO.getTranslationString(chan.getOutputTranslation())));
                TclList.append(interp, list, translation_pair);
            } else {
                TclList.append(interp, list, TclString.newInstance(TclIO.getTranslationString(chan.getInputTranslation())));
            }
            if (chan instanceof SocketChannel) {
                TclList.append(interp, list, TclString.newInstance("-peername"));
                TclList.append(interp, list, ((AbstractSocketChannel)chan).getPeerName(interp));
            }
            if (chan instanceof AbstractSocketChannel) {
                TclList.append(interp, list, TclString.newInstance("-sockname"));
                TclList.append(interp, list, ((AbstractSocketChannel)chan).getSockName(interp));
            }
            interp.setResult(list);
        }
        if (argv.length == 3) {
            if (chan instanceof AbstractSocketChannel && argv[2].toString().equals("-error")) {
                interp.setResult(((AbstractSocketChannel)chan).getError(interp));
                return;
            }
            int index = 0;
            try {
                index = TclIndex.get(interp, argv[2], validCmds, "option", 0);
            }
            catch (TclException tclException) {
                throw new TclException(interp, "bad option \"" + argv[2] + "\": should be one of -blocking, -buffering, -buffersize, -encoding, -eofchar, or -translation");
            }
            switch (index) {
                case 0: {
                    interp.setResult(chan.getBlocking());
                    break;
                }
                case 1: {
                    interp.setResult(TclIO.getBufferingString(chan.getBuffering()));
                    break;
                }
                case 2: {
                    interp.setResult(chan.getBufferSize());
                    break;
                }
                case 3: {
                    javaEncoding = chan.getEncoding();
                    if (javaEncoding == null) {
                        interp.setResult("binary");
                        break;
                    }
                    interp.setResult(EncodingCmd.getTclName(javaEncoding));
                    break;
                }
                case 4: {
                    if (chan.isReadOnly()) {
                        char eofChar = chan.getInputEofChar();
                        interp.setResult(eofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(eofChar));
                        break;
                    }
                    if (chan.isWriteOnly()) {
                        char eofChar = chan.getOutputEofChar();
                        interp.setResult(eofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(eofChar));
                        break;
                    }
                    if (chan.isReadWrite()) {
                        char inEofChar = chan.getInputEofChar();
                        char outEofChar = chan.getOutputEofChar();
                        TclObject eofchar_pair = TclList.newInstance();
                        TclList.append(interp, eofchar_pair, inEofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(inEofChar));
                        TclList.append(interp, eofchar_pair, outEofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(outEofChar));
                        interp.setResult(eofchar_pair);
                        break;
                    }
                    TclObject list = TclList.newInstance();
                    char eofChar = chan.getOutputEofChar();
                    TclList.append(interp, list, eofChar == '\u0000' ? TclString.newInstance("") : TclString.newInstance(eofChar));
                    interp.setResult(list);
                    break;
                }
                case 5: {
                    if (chan.isReadOnly()) {
                        interp.setResult(TclIO.getTranslationString(chan.getInputTranslation()));
                        break;
                    }
                    if (chan.isWriteOnly()) {
                        interp.setResult(TclIO.getTranslationString(chan.getOutputTranslation()));
                        break;
                    }
                    if (chan.isReadWrite()) {
                        TclObject translation_pair = TclList.newInstance();
                        TclList.append(interp, translation_pair, TclString.newInstance(TclIO.getTranslationString(chan.getInputTranslation())));
                        TclList.append(interp, translation_pair, TclString.newInstance(TclIO.getTranslationString(chan.getOutputTranslation())));
                        interp.setResult(translation_pair);
                        break;
                    }
                    interp.setResult(TclIO.getTranslationString(chan.getInputTranslation()));
                    break;
                }
                case 6: {
                    interp.setResult(((AbstractSocketChannel)chan).getPeerName(interp));
                    break;
                }
                case 7: {
                    interp.setResult(((AbstractSocketChannel)chan).getSockName(interp));
                    break;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
        int i = 3;
        while (i < argv.length) {
            int index;
            try {
                index = TclIndex.get(interp, argv[i - 1], commonValidCommands, "option", 0);
            }
            catch (TclException tclException) {
                throw new TclException(interp, "bad option \"" + argv[i - 1] + "\": should be one of -blocking, -buffering, -buffersize, -encoding, -eofchar, or -translation");
            }
            switch (index) {
                case 0: {
                    chan.setBlocking(TclBoolean.get(interp, argv[i]));
                    break;
                }
                case 1: {
                    int id = TclIO.getBufferingID(argv[i].toString());
                    if (id == -1) {
                        throw new TclException(interp, "bad value for -buffering: must be one of full, line, or none");
                    }
                    chan.setBuffering(id);
                    break;
                }
                case 2: {
                    chan.setBufferSize(TclInteger.getInt(interp, argv[i]));
                    break;
                }
                case 3: {
                    String tclEncoding = argv[i].toString();
                    if (tclEncoding.equals("") || tclEncoding.equals("binary") || tclEncoding.equals("identity")) {
                        chan.setEncoding(null);
                        break;
                    }
                    String javaEncoding2 = EncodingCmd.getJavaName(tclEncoding);
                    if (javaEncoding2 == null) {
                        throw new TclException(interp, "unknown encoding \"" + tclEncoding + "\"");
                    }
                    if (!EncodingCmd.isSupported(javaEncoding2)) {
                        throw new TclException(interp, "unsupported encoding \"" + tclEncoding + "\"");
                    }
                    chan.setEncoding(javaEncoding2);
                    break;
                }
                case 4: {
                    char inputEofChar;
                    char outputEofChar;
                    int length = TclList.getLength(interp, argv[i]);
                    if (length > 2) {
                        throw new TclException(interp, "bad value for -eofchar: should be a list of zero, one, or two elements");
                    }
                    if (length == 0) {
                        outputEofChar = '\u0000';
                        inputEofChar = '\u0000';
                    } else if (length == 1) {
                        s = TclList.index(interp, argv[i], 0).toString();
                        inputEofChar = outputEofChar = s.charAt(0);
                    } else {
                        s = TclList.index(interp, argv[i], 0).toString();
                        inputEofChar = s.charAt(0);
                        s = TclList.index(interp, argv[i], 1).toString();
                        outputEofChar = s.charAt(0);
                    }
                    chan.setInputEofChar(inputEofChar);
                    chan.setOutputEofChar(outputEofChar);
                    break;
                }
                case 5: {
                    int outputTranslation;
                    String outputTranslationArg;
                    int inputTranslation;
                    String inputTranslationArg;
                    int length = TclList.getLength(interp, argv[i]);
                    if (length < 1 || length > 2) {
                        throw new TclException(interp, "bad value for -translation: must be a one or two element list");
                    }
                    if (length == 2) {
                        inputTranslationArg = TclList.index(interp, argv[i], 0).toString();
                        inputTranslation = TclIO.getTranslationID(inputTranslationArg);
                        outputTranslationArg = TclList.index(interp, argv[i], 1).toString();
                        outputTranslation = TclIO.getTranslationID(outputTranslationArg);
                    } else {
                        outputTranslationArg = inputTranslationArg = argv[i].toString();
                        outputTranslation = inputTranslation = TclIO.getTranslationID(outputTranslationArg);
                    }
                    if (inputTranslation == -1 || outputTranslation == -1) {
                        throw new TclException(interp, "bad value for -translation: must be one of auto, binary, cr, lf, crlf, or platform");
                    }
                    if (chan.isReadOnly()) {
                        chan.setInputTranslation(inputTranslation);
                        if (!inputTranslationArg.equals("binary")) break;
                        chan.setEncoding(null);
                        break;
                    }
                    if (chan.isWriteOnly()) {
                        chan.setOutputTranslation(outputTranslation);
                        if (!outputTranslationArg.equals("binary")) break;
                        chan.setEncoding(null);
                        break;
                    }
                    if (!chan.isReadWrite()) break;
                    chan.setInputTranslation(inputTranslation);
                    chan.setOutputTranslation(outputTranslation);
                    if (!inputTranslationArg.equals("binary") && !outputTranslationArg.equals("binary")) break;
                    chan.setEncoding(null);
                    break;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
            i += 2;
        }
    }
}

