/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.channel.Channel;
import tcl.lang.channel.Fcopy;

public class FcopyCmd
implements Command {
    private static final String[] validOpts = new String[]{"-size", "-command"};
    private static final int OPT_SIZE = 0;
    private static final int OPT_COMMAND = 1;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        long size = -1L;
        String callback = null;
        if (objv.length != 3 && objv.length != 5 && objv.length != 7) {
            throw new TclNumArgsException(interp, 1, objv, "input output ?-size size? ?-command callback?");
        }
        int argIndex = 3;
        while (argIndex < objv.length) {
            int option = TclIndex.get(interp, objv[argIndex], validOpts, "switch", 0);
            switch (option) {
                case 1: {
                    callback = objv[++argIndex].toString();
                    break;
                }
                case 0: {
                    size = TclInteger.getLong(interp, objv[++argIndex]);
                }
            }
            ++argIndex;
        }
        Channel source = TclIO.getChannel(interp, objv[1].toString());
        Channel destination = TclIO.getChannel(interp, objv[2].toString());
        if (source == null) {
            throw new TclException(interp, "can not find channel named \"" + objv[1] + "\"");
        }
        if (destination == null) {
            throw new TclException(interp, "can not find channel named \"" + objv[2] + "\"");
        }
        Fcopy fcopy = new Fcopy(interp, source, destination, size, callback);
        interp.setResult(fcopy.start());
    }
}

