/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class FileCmd
implements Command {
    private static final String[] validCmds = new String[]{"atime", "attributes", "channels", "copy", "delete", "dirname", "executable", "exists", "extension", "isdirectory", "isfile", "join", "link", "lstat", "mtime", "mkdir", "nativename", "normalize", "owned", "pathtype", "readable", "readlink", "rename", "rootname", "separator", "size", "split", "stat", "system", "tail", "type", "volumes", "writable"};
    private static final int OPT_ATIME = 0;
    private static final int OPT_ATTRIBUTES = 1;
    private static final int OPT_CHANNELS = 2;
    private static final int OPT_COPY = 3;
    private static final int OPT_DELETE = 4;
    private static final int OPT_DIRNAME = 5;
    private static final int OPT_EXECUTABLE = 6;
    private static final int OPT_EXISTS = 7;
    private static final int OPT_EXTENSION = 8;
    private static final int OPT_ISDIRECTORY = 9;
    private static final int OPT_ISFILE = 10;
    private static final int OPT_JOIN = 11;
    private static final int OPT_LINK = 12;
    private static final int OPT_LSTAT = 13;
    private static final int OPT_MTIME = 14;
    private static final int OPT_MKDIR = 15;
    private static final int OPT_NATIVENAME = 16;
    private static final int OPT_NORMALIZE = 17;
    private static final int OPT_OWNED = 18;
    private static final int OPT_PATHTYPE = 19;
    private static final int OPT_READABLE = 20;
    private static final int OPT_READLINK = 21;
    private static final int OPT_RENAME = 22;
    private static final int OPT_ROOTNAME = 23;
    private static final int OPT_SEPARATOR = 24;
    private static final int OPT_SIZE = 25;
    private static final int OPT_SPLIT = 26;
    private static final int OPT_STAT = 27;
    private static final int OPT_SYSTEM = 28;
    private static final int OPT_TAIL = 29;
    private static final int OPT_TYPE = 30;
    private static final int OPT_VOLUMES = 31;
    private static final int OPT_WRITABLE = 32;
    private static final String[] validOptions = new String[]{"-force", "--"};
    private static final int OPT_FORCE = 0;
    private static final int OPT_LAST = 1;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        File fileObj = null;
        switch (opt) {
            case 0: {
                if (argv.length < 3 || argv.length > 4) {
                    throw new TclNumArgsException(interp, 2, argv, "name ?time?");
                }
                if (!FileUtil.getNewFileObj(interp, argv[2].toString()).exists() || argv[2].toString().length() == 0) {
                    throw new TclPosixException(interp, 2, true, "could not read \"" + argv[2] + "\"");
                }
                if (argv.length == 4) {
                    try {
                        Integer.parseInt(argv[3].toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TclException(interp, "expected integer but got \"" + argv[3] + "\"");
                    }
                }
                throw new TclException(interp, "sorry, \"file atime\" is not available due to JVM restrictions.");
            }
            case 1: {
                fileObj = null;
                if (argv.length >= 3) {
                    String fn = argv[2].toString();
                    fileObj = FileUtil.getNewFileObj(interp, fn);
                    if (fn.length() == 0 || !fileObj.exists()) {
                        throw new TclPosixException(interp, 2, true, "could not read \"" + fn + "\"");
                    }
                }
                switch (argv.length) {
                    case 3: {
                        interp.setResult("-JTCL_DOES_NOT_SUPPORT_ATTRIBUTES FILE_ATTRIBUTES_NOT_SUPPORTED");
                        return;
                    }
                    case 4: 
                    case 5: {
                        if (!argv[3].toString().equals("-JTCL_DOES_NOT_SUPPORT_ATTRIBUTES")) break;
                        if (argv.length == 4) {
                            interp.setResult("FILE_ATTRIBUTES_NOT_SUPPORTED");
                        }
                        return;
                    }
                }
                throw new TclException(interp, "Sorry, \"file attributes\" is not available to due JVM restrictions");
            }
            case 2: {
                if (argv.length > 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?pattern?");
                }
                try {
                    TclIO.getChannelNames(interp, argv.length == 2 ? null : TclString.newInstance(argv[2]));
                }
                catch (TclException tclException) {
                    throw new TclException(interp, "Could not get channel names.");
                }
                return;
            }
            case 3: {
                FileCmd.fileCopyRename(interp, argv, true);
                return;
            }
            case 4: {
                FileCmd.fileDelete(interp, argv);
                return;
            }
            case 5: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                String path = argv[2].toString();
                TclObject[] splitArrayObj = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, path));
                if (splitArrayObj.length > 1) {
                    interp.setResult(FileUtil.joinPath(interp, splitArrayObj, 0, splitArrayObj.length - 1));
                } else if (splitArrayObj.length == 0 || FileUtil.getPathType(path) == 0) {
                    if (JACL.PLATFORM == 2) {
                        interp.setResult(":");
                    } else {
                        interp.setResult(".");
                    }
                } else {
                    interp.setResult(splitArrayObj[0].toString());
                }
                return;
            }
            case 6: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    interp.setResult(FileUtil.isExecutable(FileUtil.getNewFileObj(interp, argv[2].toString())));
                }
                return;
            }
            case 7: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    try {
                        fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                        interp.setResult(fileObj.exists());
                    }
                    catch (TclException tclException) {
                        interp.setResult(false);
                    }
                }
                return;
            }
            case 8: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileCmd.getExtension(argv[2].toString()));
                return;
            }
            case 9: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                    interp.setResult(fileObj.isDirectory());
                }
                return;
            }
            case 10: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(fileObj.isFile());
                return;
            }
            case 11: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name ?name ...?");
                }
                interp.setResult(FileUtil.joinPath(interp, argv, 2, argv.length));
                return;
            }
            case 12: {
                if (argv.length < 3 || argv.length > 5) {
                    throw new TclNumArgsException(interp, 2, argv, "?-linktype? linkname ?target?");
                }
                String linkName = null;
                String targetName = null;
                if ("-symbolic".equals(argv[2].toString()) || "-hard".equals(argv[2].toString())) {
                    linkName = argv[3].toString();
                    targetName = argv.length == 5 ? argv[4].toString() : null;
                    throw new TclException(interp, "sorry, creating links with \"file link\" is not available due to JVM restrictions.");
                }
                if (argv.length == 5) {
                    throw new TclException(interp, "bad switch \"" + argv[2] + "\": must be -symbolic or -hard");
                }
                linkName = argv[2].toString();
                targetName = argv.length == 4 ? argv[3].toString() : null;
                File link = FileUtil.getNewFileObj(interp, linkName);
                if (targetName != null) {
                    if (link.exists()) {
                        throw new TclException(interp, "could not create new link \"" + linkName + "\": that path already exists");
                    }
                    File target = FileUtil.getNewFileObj(interp, targetName);
                    if (!target.exists()) {
                        throw new TclException(interp, "could not create new link \"" + linkName + "\" since target \"" + targetName + "\" doesn't exist");
                    }
                    throw new TclException(interp, "sorry, creating a link with \"file link\" is not available due to JVM restrictions.");
                }
                if (!link.exists() || linkName.length() == 0) {
                    throw new TclPosixException(interp, 2, true, "could not read link \"" + linkName + "\"");
                }
                File targetOfLink = FileUtil.getLinkTarget(link);
                if (targetOfLink == null) {
                    throw new TclException(interp, "could not read link \"" + linkName + "\": invalid argument");
                }
                interp.setResult(targetOfLink.getAbsolutePath());
                return;
            }
            case 14: {
                if (argv.length < 3 || argv.length > 4) {
                    throw new TclNumArgsException(interp, 2, argv, "name ?time?");
                }
                if (argv[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                if (argv.length == 4) {
                    long newTime = TclInteger.getLong(interp, argv[3]) * 1000L;
                    fileObj.setLastModified(newTime);
                } else {
                    interp.setResult(FileCmd.getMtime(interp, argv[2].toString(), fileObj));
                }
                return;
            }
            case 15: {
                FileCmd.fileMakeDirs(interp, argv);
                return;
            }
            case 16: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileUtil.translateFileName(interp, argv[2].toString()));
                return;
            }
            case 17: {
                TclObject fName = null;
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "filename");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult("");
                } else {
                    fName = FileUtil.getNormalizedPath(interp, argv[2]);
                    if (fName == null) {
                        throw new TclException(interp, "Cannot normalize this path!");
                    }
                    interp.setResult(fName);
                }
                return;
            }
            case 18: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                    interp.setResult(FileCmd.isOwner(interp, fileObj));
                }
                return;
            }
            case 19: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                switch (FileUtil.getPathType(argv[2].toString())) {
                    case 0: {
                        interp.setResult("relative");
                        return;
                    }
                    case 1: {
                        interp.setResult("volumerelative");
                        return;
                    }
                    case 2: {
                        interp.setResult("absolute");
                    }
                }
                return;
            }
            case 20: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                    interp.setResult(fileObj.canRead());
                }
                return;
            }
            case 21: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                if (!fileObj.exists() || argv[2].toString().length() == 0) {
                    throw new TclPosixException(interp, 2, true, "could not readlink \"" + argv[2] + "\"");
                }
                File target = FileUtil.getLinkTarget(fileObj);
                if (target == null) {
                    throw new TclException(interp, "could not readlink \"" + argv[2] + "\": invalid argument");
                }
                interp.setResult(target.getPath());
                return;
            }
            case 22: {
                FileCmd.fileCopyRename(interp, argv, false);
                return;
            }
            case 23: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                String fileName = argv[2].toString();
                String extension = FileCmd.getExtension(fileName);
                int diffLength = fileName.length() - extension.length();
                interp.setResult(fileName.substring(0, diffLength));
                return;
            }
            case 24: {
                String arg;
                if (argv.length > 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv.length == 2) {
                    arg = null;
                } else {
                    arg = argv[2].toString();
                    if (arg.length() == 0) {
                        throw new TclException(interp, "Unrecognised path");
                    }
                }
                String separator = FileUtil.getSeparators(arg);
                interp.setResult(separator);
                return;
            }
            case 25: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                if (!fileObj.exists()) {
                    throw new TclPosixException(interp, 2, true, "could not read \"" + argv[2].toString() + "\"");
                }
                interp.setResult(fileObj.length());
                return;
            }
            case 26: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileUtil.splitPath(interp, argv[2].toString()));
                return;
            }
            case 13: 
            case 27: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "name varName");
                }
                if (argv[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                FileCmd.getAndStoreStatData(interp, argv[2].toString(), argv[3].toString(), opt == 13);
                return;
            }
            case 28: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (!FileUtil.getNewFileObj(interp, argv[2].toString()).exists() || argv[2].toString().length() == 0) {
                    throw new TclException(interp, "Unrecognised path");
                }
                interp.setResult("native");
                return;
            }
            case 29: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileCmd.getTail(interp, argv[2].toString()));
                return;
            }
            case 30: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    throw new TclException(interp, "could not read \"\": no such file or directory");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(FileCmd.getType(interp, argv[2].toString(), fileObj));
                return;
            }
            case 31: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 2, argv, null);
                }
                File[] roots = File.listRoots();
                if (roots != null) {
                    TclObject list = TclList.newInstance();
                    int i = 0;
                    while (i < roots.length) {
                        String root = roots[i].getPath();
                        TclList.append(interp, list, TclString.newInstance(root));
                        ++i;
                    }
                    interp.setResult(list);
                }
                return;
            }
            case 32: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                if (argv[2].toString().length() == 0) {
                    interp.setResult(false);
                } else {
                    fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                    interp.setResult(fileObj.canWrite());
                }
                return;
            }
        }
        throw new TclRuntimeError("file command with opt " + argv[1].toString() + " is not implemented");
    }

    private static boolean isOwner(Interp interp, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            return false;
        }
        boolean owner = true;
        Util.isUnix();
        return owner;
    }

    private static int getMtime(Interp interp, String fileName, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + fileName + "\"");
        }
        return (int)(fileObj.lastModified() / 1000L);
    }

    private static String getType(Interp interp, String fileName, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + fileName + "\"");
        }
        if (FileUtil.getLinkTarget(fileObj) != null) {
            return "link";
        }
        if (fileObj.isFile()) {
            return "file";
        }
        if (fileObj.isDirectory()) {
            return "directory";
        }
        return "link";
    }

    private static void getAndStoreStatData(Interp interp, String fileName, String varName, boolean lstat) throws TclException {
        File target;
        File fileObj = FileUtil.getNewFileObj(interp, fileName);
        if (lstat && (target = FileUtil.getLinkTarget(fileObj)) != null) {
            fileObj = target;
        }
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + fileName + "\"");
        }
        try {
            int mtime = FileCmd.getMtime(interp, fileName, fileObj);
            TclObject mtimeObj = TclInteger.newInstance(mtime);
            TclInteger.newInstance(mtime);
            TclObject ctimeObj = TclInteger.newInstance(mtime);
            interp.setVar(varName, "ctime", ctimeObj, 0);
            interp.setVar(varName, "mtime", mtimeObj, 0);
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.getMessage());
        }
        catch (TclException tclException) {
            throw new TclException(interp, "can't set \"" + varName + "(dev)\": variable isn't array");
        }
        try {
            TclObject sizeObj = TclInteger.newInstance(fileObj.length());
            interp.setVar(varName, "size", sizeObj, 0);
        }
        catch (Exception exception) {}
        try {
            TclObject typeObj = TclString.newInstance(FileCmd.getType(interp, fileName, fileObj));
            interp.setVar(varName, "type", typeObj, 0);
        }
        catch (Exception exception) {}
        try {
            TclObject uidObj = TclBoolean.newInstance(FileCmd.isOwner(interp, fileObj));
            interp.setVar(varName, "uid", uidObj, 0);
        }
        catch (TclException tclException) {}
    }

    private static String getExtension(String path) {
        if (path.length() < 1) {
            return "";
        }
        int lastSepIndex = -1;
        switch (JACL.PLATFORM) {
            case 1: {
                String tmpPath = path.replace('\\', '/').replace(':', '/');
                lastSepIndex = tmpPath.lastIndexOf(47);
                break;
            }
            case 2: {
                lastSepIndex = path.lastIndexOf(58);
                if (lastSepIndex != -1) break;
                lastSepIndex = path.lastIndexOf(47);
                break;
            }
            default: {
                lastSepIndex = path.lastIndexOf(47);
            }
        }
        if (++lastSepIndex >= path.length()) {
            return "";
        }
        String lastSep = path.substring(lastSepIndex);
        int dotIndex = lastSep.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return lastSep.substring(dotIndex);
    }

    private static String getTail(Interp interp, String path) throws TclException {
        TclObject splitResult = FileUtil.splitAndTranslate(interp, path);
        int last = TclList.getLength(interp, splitResult) - 1;
        if (last >= 0 && (last > 0 || FileUtil.getPathType(path) == 0)) {
            TclObject tailObj = TclList.index(interp, splitResult, last);
            return tailObj.toString();
        }
        return "";
    }

    private static void fileMakeDirs(Interp interp, TclObject[] argv) throws TclException {
        boolean madeDir = false;
        int currentDir = 2;
        while (currentDir < argv.length) {
            String dirName = argv[currentDir].toString();
            if (dirName.length() == 0) {
                throw new TclPosixException(interp, 2, true, "can't create directory \"\"");
            }
            File dirObj = FileUtil.getNewFileObj(interp, dirName);
            if (dirObj.exists()) {
                if (!dirObj.isDirectory()) {
                    throw new TclPosixException(interp, 17, true, "can't create directory \"" + dirName + "\"");
                }
            } else {
                try {
                    madeDir = dirObj.mkdir();
                    if (!madeDir) {
                        madeDir = dirObj.mkdirs();
                    }
                }
                catch (SecurityException e) {
                    throw new TclException(interp, e.getMessage());
                }
                if (!madeDir) {
                    throw new TclPosixException(interp, 13, true, "can't create directory \"" + dirName + "\":  best guess at reason");
                }
            }
            ++currentDir;
        }
    }

    private static void fileDelete(Interp interp, TclObject[] argv) throws TclException {
        boolean force = false;
        int firstSource = 2;
        boolean last = false;
        while (firstSource < argv.length && !last) {
            int opt;
            if (!argv[firstSource].toString().startsWith("-")) break;
            try {
                opt = TclIndex.get(interp, argv[firstSource], validOptions, "option", 1);
            }
            catch (TclException e) {
                throw new TclException(interp, e.getMessage().replace("must", "should"));
            }
            switch (opt) {
                case 0: {
                    force = true;
                    break;
                }
                case 1: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + opt + " index to validOptions");
                }
            }
            ++firstSource;
        }
        if (firstSource >= argv.length) {
            throw new TclNumArgsException(interp, 2, argv, "?options? file ?file ...?");
        }
        int i = firstSource;
        while (i < argv.length) {
            if (argv[i].toString().length() > 0) {
                FileCmd.deleteOneFile(interp, FileUtil.getNewFileObj(interp, argv[i].toString()), force);
            }
            ++i;
        }
    }

    private static void deleteOneFile(Interp interp, File fileObj, boolean force) throws TclException {
        boolean isDeleted = true;
        String fileName = fileObj.getPath();
        if (!fileObj.exists()) {
            return;
        }
        if (fileObj.isDirectory() && fileObj.list().length > 0) {
            if (force) {
                String[] fileList = fileObj.list();
                int i = 0;
                while (i < fileList.length) {
                    FileCmd.deleteOneFile(interp, new File(fileObj, fileList[i]), force);
                    ++i;
                }
            } else {
                throw new TclPosixException(interp, 66, "error deleting \"" + fileObj.getName() + "\": directory not empty");
            }
        }
        try {
            isDeleted = fileObj.delete();
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.getMessage());
        }
        if (!isDeleted) {
            throw new TclPosixException(interp, 13, true, "error deleting \"" + fileName + "\":  best guess at reason");
        }
    }

    private static void fileCopyRename(Interp interp, TclObject[] argv, boolean copyFlag) throws TclException {
        int firstSource = 2;
        boolean force = false;
        boolean last = false;
        while (firstSource < argv.length && !last) {
            int opt;
            if (!argv[firstSource].toString().startsWith("-")) break;
            try {
                opt = TclIndex.get(interp, argv[firstSource], validOptions, "option", 1);
            }
            catch (TclException e) {
                throw new TclException(interp, e.getMessage().replace("must", "should"));
            }
            switch (opt) {
                case 0: {
                    force = true;
                    break;
                }
                case 1: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + opt + " index to validOptions");
                }
            }
            ++firstSource;
        }
        if (firstSource >= argv.length - 1) {
            throw new TclNumArgsException(interp, firstSource, argv, "?options? source ?source ...? target");
        }
        int target = argv.length - 1;
        String targetName = argv[target].toString();
        File targetObj = FileUtil.getNewFileObj(interp, targetName);
        if (targetObj.isDirectory()) {
            int source = firstSource;
            while (source < target) {
                String sourceName = argv[source].toString();
                if (targetName.length() == 0) {
                    FileCmd.copyRenameOneFile(interp, sourceName, targetName, copyFlag, force);
                } else {
                    String tailName = FileCmd.getTail(interp, sourceName);
                    TclObject[] joinArrayObj = new TclObject[]{TclString.newInstance(targetName), TclString.newInstance(tailName)};
                    String fullTargetName = FileUtil.joinPath(interp, joinArrayObj, 0, 2);
                    FileCmd.copyRenameOneFile(interp, sourceName, fullTargetName, copyFlag, force);
                }
                ++source;
            }
        } else {
            if (firstSource + 1 != target) {
                String action = copyFlag ? "copying" : "renaming";
                throw new TclPosixException(interp, 20, "error " + action + ": target \"" + argv[target].toString() + "\" is not a directory");
            }
            String sourceName = argv[firstSource].toString();
            FileCmd.copyRenameOneFile(interp, sourceName, targetName, copyFlag, force);
        }
    }

    private static void copyRenameOneFile(Interp interp, String sourceName, String targetName, boolean copyFlag, boolean force) throws TclException {
        if (force && sourceName.equals(targetName)) {
            return;
        }
        String action = copyFlag ? "copying" : "renaming";
        File sourceFileObj = FileUtil.getNewFileObj(interp, sourceName);
        if (!sourceFileObj.exists() || sourceName.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + action + " \"" + sourceName + "\"");
        }
        if (targetName.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + action + " \"" + sourceName + "\" to \"" + targetName + "\"");
        }
        File targetFileObj = FileUtil.getNewFileObj(interp, targetName);
        if (targetFileObj.exists() && !force) {
            throw new TclPosixException(interp, 17, true, "error " + action + " \"" + sourceName + "\" to \"" + targetName + "\"");
        }
        if (sourceFileObj.isDirectory() && !targetFileObj.isDirectory() && targetFileObj.exists()) {
            throw new TclPosixException(interp, 21, "can't overwrite file \"" + targetName + "\" with directory \"" + sourceName + "\"");
        }
        if (targetFileObj.isDirectory() && !sourceFileObj.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite directory \"" + targetName + "\" with file \"" + sourceName + "\"");
        }
        if (targetFileObj.getParent() != null && !targetFileObj.getParentFile().exists()) {
            throw new TclPosixException(interp, 2, true, "error " + action + " \"" + sourceName + "\" to \"" + targetName + "\"");
        }
        if (!copyFlag) {
            if (!sourceFileObj.renameTo(targetFileObj)) {
                if (targetFileObj.isDirectory()) {
                    throw new TclPosixException(interp, 17, true, "error renaming \"" + sourceName + "\" to \"" + targetName + "\"");
                }
                throw new TclPosixException(interp, 13, true, "error renaming \"" + sourceName + "\" to \"" + targetName + "\":  best guess at reason");
            }
        } else if (sourceFileObj.isDirectory()) {
            if (!targetFileObj.mkdir()) {
                throw new TclPosixException(interp, 13, true, "error copying \"" + sourceName + "\" to \"" + targetName + "\":  best guess at reason");
            }
            File[] fileArray = sourceFileObj.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileCmd.copyRenameOneFile(interp, f.getPath(), new File(targetFileObj, f.getName()).getPath(), true, force);
                ++n2;
            }
        } else {
            try {
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(sourceFileObj));
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(targetFileObj));
                byte[] buff = new byte[1024];
                int numChars = bin.read(buff, 0, 1024);
                while (numChars != -1) {
                    bout.write(buff, 0, numChars);
                    numChars = bin.read(buff, 0, 1024);
                }
                bin.close();
                bout.close();
            }
            catch (IOException e) {
                throw new TclException(interp, "error copying: " + e.getMessage());
            }
        }
    }
}

