/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class ForeachCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int nSize;
        int x;
        if (objv.length < 4 || objv.length % 2 != 0) {
            throw new TclNumArgsException(interp, 1, objv, "varList list ?varList list ...? command");
        }
        TclObject[] name = new TclObject[(objv.length - 2) / 2];
        TclObject[] value = new TclObject[(objv.length - 2) / 2];
        int maxIter = 0;
        TclObject command = objv[objv.length - 1];
        boolean done = false;
        int i = 0;
        while (i < objv.length - 2) {
            x = i / 2;
            name[x] = objv[i + 1];
            value[x] = objv[i + 2];
            nSize = TclList.getLength(interp, name[x]);
            int vSize = TclList.getLength(interp, value[x]);
            if (nSize == 0) {
                throw new TclException(interp, "foreach varlist is empty");
            }
            int iter = (vSize + nSize - 1) / nSize;
            if (maxIter < iter) {
                maxIter = iter;
            }
            i += 2;
        }
        int c = 0;
        while (!done && c < maxIter) {
            i = 0;
            while (i < objv.length - 2) {
                x = i / 2;
                nSize = TclList.getLength(interp, name[x]);
                int base = nSize * c;
                int j = 0;
                while (j < nSize) {
                    try {
                        if (base + j >= TclList.getLength(interp, value[x])) {
                            interp.setVar(TclList.index(interp, name[x], j), TclString.newInstance(""), 0);
                        } else {
                            interp.setVar(TclList.index(interp, name[x], j), TclList.index(interp, value[x], base + j), 0);
                        }
                    }
                    catch (TclException tclException) {
                        throw new TclException(interp, "couldn't set loop variable: \"" + TclList.index(interp, name[x], j) + "\"");
                    }
                    ++j;
                }
                i += 2;
            }
            try {
                interp.eval(command, 0);
            }
            catch (TclException e) {
                switch (e.getCompletionCode()) {
                    case 3: {
                        done = true;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        interp.addErrorInfo("\n    (\"foreach\" body line " + interp.errorLine + ")");
                        throw e;
                    }
                    default: {
                        throw e;
                    }
                }
            }
            ++c;
        }
        interp.resetResult();
    }
}

