/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public class GetsCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        boolean writeToVar = false;
        String varName = "";
        if (argv.length < 2 || argv.length > 3) {
            throw new TclNumArgsException(interp, 1, argv, "channelId ?varName?");
        }
        if (argv.length == 3) {
            writeToVar = true;
            varName = argv[2].toString();
        }
        if ((chan = TclIO.getChannel(interp, argv[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        try {
            TclObject line = TclString.newInstance(new StringBuffer(64));
            int lineLen = chan.read(interp, line, 2, 0);
            if (lineLen < 0) {
                if (!chan.eof() && !chan.isBlocked(interp)) {
                    throw new TclPosixException(interp, 5, true, "error reading \"" + argv[1].toString() + "\"");
                }
                lineLen = -1;
            }
            if (writeToVar) {
                interp.setVar(varName, line, 0);
                interp.setResult(lineLen);
            } else {
                interp.setResult(line);
            }
        }
        catch (IOException e) {
            throw new TclRuntimeError("GetsCmd.cmdProc() Error: IOException when getting " + chan.getChanName() + ": " + e.getMessage());
        }
    }
}

