/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Stack;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

public class GlobCmd
implements Command {
    private static final int TYPE_BLOCKSPECIAL = 1;
    private static final int TYPE_CHARSPECIAL = 2;
    private static final int TYPE_DIRECTORY = 4;
    private static final int TYPE_REGULARFILE = 8;
    private static final int TYPE_LINK = 16;
    private static final int TYPE_PIPE = 32;
    private static final int TYPE_SOCKET = 64;
    private static final int TYPE_PERM_R = 128;
    private static final int TYPE_PERM_W = 256;
    private static final int TYPE_PERM_X = 512;
    private static final int TYPE_READONLY = 1024;
    private static final int TYPE_HIDDEN = 2048;
    private static final int TYPE_MACINTOSH = 4096;
    private static final String[] validOptions = new String[]{"-directory", "-join", "-nocomplain", "-path", "-tails", "-types", "--"};
    private static final int OPT_DIRECTORY = 0;
    private static final int OPT_JOIN = 1;
    private static final int OPT_NOCOMPLAIN = 2;
    private static final int OPT_PATH = 3;
    private static final int OPT_TAILS = 4;
    private static final int OPT_TYPES = 5;
    private static final int OPT_LAST = 6;

    /*
     * Unable to fully structure code
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        noComplain = false;
        join = false;
        dirMode = false;
        pathMode = false;
        tails = false;
        types = 0;
        topDirectory = null;
        prefix = "";
        firstNonSwitchArgumentIndex = 1;
        joined = "";
        if (argv.length == 1) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? name ?name ...?");
        }
        last = false;
        while (firstNonSwitchArgumentIndex < argv.length && !last) {
            if (!argv[firstNonSwitchArgumentIndex].toString().startsWith("-")) break;
            opt = TclIndex.get(interp, argv[firstNonSwitchArgumentIndex], GlobCmd.validOptions, "option", 0);
            switch (opt) {
                case 2: {
                    noComplain = true;
                    break;
                }
                case 0: {
                    if (argv.length < 3) {
                        throw new TclException(interp, "missing argument to \"-directory\"");
                    }
                    if (pathMode) {
                        throw new TclException(interp, "\"-directory\" cannot be used with \"-path\"");
                    }
                    dirMode = true;
                    topDirectory = new File(FileUtil.translateFileName(interp, argv[++firstNonSwitchArgumentIndex].toString()));
                    break;
                }
                case 1: {
                    join = true;
                    break;
                }
                case 3: {
                    if (firstNonSwitchArgumentIndex == argv.length - 1) {
                        throw new TclException(interp, "missing argument to \"-path\"");
                    }
                    if (dirMode) {
                        throw new TclException(interp, "\"-path\" cannot be used with \"-directory\"");
                    }
                    pathMode = true;
                    path = new File(FileUtil.translateFileName(interp, argv[++firstNonSwitchArgumentIndex].toString()));
                    topDirectory = path.getParentFile();
                    prefix = path.getName();
                    break;
                }
                case 4: {
                    tails = true;
                    break;
                }
                case 5: {
                    if (firstNonSwitchArgumentIndex == argv.length - 1) {
                        throw new TclException(interp, "missing argument to \"-types\"");
                    }
                    var20_32 = typeObjs = TclList.getElements(interp, argv[++firstNonSwitchArgumentIndex]);
                    var19_30 = typeObjs.length;
                    var18_29 = 0;
                    while (var18_29 < var19_30) {
                        t = var20_32[var18_29];
                        ts = t.toString();
                        if (ts.length() != 1) ** GOTO lbl88
                        switch (ts.charAt(0)) {
                            case 'd': {
                                types |= 4;
                                ** GOTO lbl102
                            }
                            case 'b': {
                                types |= 1;
                                ** GOTO lbl102
                            }
                            case 'c': {
                                types |= 2;
                                ** GOTO lbl102
                            }
                            case 'f': {
                                types |= 8;
                                ** GOTO lbl102
                            }
                            case 'l': {
                                types |= 16;
                                ** GOTO lbl102
                            }
                            case 'p': {
                                types |= 32;
                                ** GOTO lbl102
                            }
                            case 's': {
                                types |= 64;
                                ** GOTO lbl102
                            }
                            case 'r': {
                                types |= 128;
                                ** GOTO lbl102
                            }
                            case 'w': {
                                types |= 256;
                                ** GOTO lbl102
                            }
                            case 'x': {
                                types |= 512;
                                ** GOTO lbl102
                            }
                            default: {
                                throw new TclException(interp, "bad argument to \"-types\": " + ts);
                            }
                        }
lbl88:
                        // 1 sources

                        if ("hidden".equals(ts)) {
                            types |= 2048;
                        } else if ("readonly".equals(ts)) {
                            types |= 1024;
                        } else if (ts.contains("macintosh")) {
                            if ((types & 4096) != 0) {
                                throw new TclException(interp, "only one MacOS type or creator argument to \"-types\" allowed");
                            }
                            types |= 4096;
                        } else {
                            if (typeObjs.length > 1) {
                                throw new TclException(interp, "only one MacOS type or creator argument to \"-types\" allowed");
                            }
                            throw new TclException(interp, "bad argument to \"-types\": " + ts);
                        }
lbl102:
                        // 13 sources

                        ++var18_29;
                    }
                    break;
                }
                case 6: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "GlobCmd.cmdProc: bad option " + opt + " index to validOptions");
                }
            }
            ++firstNonSwitchArgumentIndex;
        }
        if (firstNonSwitchArgumentIndex >= argv.length) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? name ?name ...?");
        }
        if (tails && !dirMode && !pathMode) {
            throw new TclException(interp, "\"-tails\" must be used with either \"-directory\" or \"-path\"");
        }
        resultList = TclList.newInstance();
        resultList.preserve();
        try {
            patternList = new ArrayList<StringBuffer>();
            if (join) {
                joined = FileUtil.joinPath(interp, argv, firstNonSwitchArgumentIndex, argv.length);
                if (argv[firstNonSwitchArgumentIndex].toString().length() == 0) {
                    joined = "/" + joined;
                }
                patternList.add(new StringBuffer());
                this.expandBraceExpressions(interp, joined, 0, patternList, false);
            } else {
                i = firstNonSwitchArgumentIndex;
                while (i < argv.length) {
                    argExpansion = new ArrayList<StringBuffer>();
                    argExpansion.add(new StringBuffer());
                    this.expandBraceExpressions(interp, argv[i].toString(), 0, argExpansion, false);
                    patternList.addAll(argExpansion);
                    ++i;
                }
            }
            patterns = new String[patternList.size()];
            i = 0;
            while (i < patternList.size()) {
                patterns[i] = ((StringBuffer)patternList.get(i)).toString();
                if (patterns[i].length() == 0) {
                    patterns[i] = ".";
                }
                if (topDirectory == null) {
                    isDir = patterns[i].endsWith(File.separator);
                    patterns[i] = String.valueOf(FileUtil.translateFileName(interp, patterns[i])) + (isDir != false ? File.separator : "");
                }
                ++i;
            }
            var19_31 = patterns;
            var18_29 = patterns.length;
            var17_27 = 0;
            while (var17_27 < var18_29) {
                pattern = var19_31[var17_27];
                this.getResultsForOnePattern(interp, pattern, types, topDirectory, prefix, tails, resultList);
                ++var17_27;
            }
        }
        catch (TclException e) {
            resultList.release();
            if (noComplain) {
                interp.setResult("");
                return;
            }
            throw e;
        }
        try {
            if (TclList.getLength(interp, resultList) == 0 && !noComplain) {
                sep = "";
                ret = new StringBuffer();
                ret.append("no files matched glob pattern");
                ret.append(join != false || argv.length - firstNonSwitchArgumentIndex == 1 ? " \"" : "s \"");
                if (join) {
                    ret.append(joined);
                } else {
                    i = firstNonSwitchArgumentIndex;
                    while (i < argv.length) {
                        ret.append(String.valueOf(sep) + argv[i].toString());
                        if (i == firstNonSwitchArgumentIndex) {
                            sep = " ";
                        }
                        ++i;
                    }
                }
                ret.append("\"");
                throw new TclException(interp, ret.toString());
            }
            if (TclList.getLength(interp, resultList) > 0) {
                interp.setResult(resultList);
            }
        }
        finally {
            resultList.release();
        }
    }

    private static void stringBufferListAppend(ArrayList<StringBuffer> a, char c) {
        for (StringBuffer sb : a) {
            sb.append(c);
        }
    }

    private int expandBraceExpressions(Interp interp, String pattern, int nextIndex, ArrayList<StringBuffer> expandedPatterns, boolean inBrace) throws TclException {
        boolean lastCharWasBackslash = false;
        block5: while (nextIndex < pattern.length()) {
            char c = pattern.charAt(nextIndex++);
            if (lastCharWasBackslash) {
                lastCharWasBackslash = false;
                GlobCmd.stringBufferListAppend(expandedPatterns, c);
                continue;
            }
            switch (c) {
                case '{': {
                    ArrayList<StringBuffer> alternation = new ArrayList<StringBuffer>();
                    --nextIndex;
                    while (nextIndex < pattern.length() && pattern.charAt(nextIndex) != '}') {
                        ArrayList<StringBuffer> oneAlternative = new ArrayList<StringBuffer>();
                        oneAlternative.add(new StringBuffer());
                        nextIndex = this.expandBraceExpressions(interp, pattern, nextIndex + 1, oneAlternative, true);
                        alternation.addAll(oneAlternative);
                    }
                    ++nextIndex;
                    ArrayList<StringBuffer> newExpandedPatterns = new ArrayList<StringBuffer>(expandedPatterns.size() * alternation.size());
                    for (StringBuffer alternationSb : alternation) {
                        for (StringBuffer prefix : expandedPatterns) {
                            newExpandedPatterns.add(new StringBuffer(String.valueOf(prefix.toString()) + alternationSb.toString()));
                        }
                    }
                    expandedPatterns.clear();
                    expandedPatterns.addAll(newExpandedPatterns);
                    break;
                }
                case ',': 
                case '}': {
                    if (inBrace) {
                        return nextIndex - 1;
                    }
                    if (c != '}') continue block5;
                    throw new TclException(interp, "unmatched close-brace in file name");
                }
                case '\\': {
                    if (nextIndex < pattern.length() && pattern.charAt(nextIndex) == File.separatorChar) continue block5;
                    lastCharWasBackslash = true;
                    GlobCmd.stringBufferListAppend(expandedPatterns, c);
                    break;
                }
                default: {
                    GlobCmd.stringBufferListAppend(expandedPatterns, c);
                }
            }
        }
        if (nextIndex >= pattern.length() && inBrace) {
            throw new TclException(interp, "unmatched open-brace in file name");
        }
        return nextIndex;
    }

    private void getResultsForOnePattern(Interp interp, String pattern, int types, File topDirectory, String prefix, boolean tails, TclObject resultList) throws TclException {
        Stack<GlobPair> stack = new Stack<GlobPair>();
        boolean hasTrailingSeparator = pattern.endsWith(File.separator);
        if (topDirectory == null) {
            pattern = FileUtil.translateFileName(interp, pattern);
        }
        TclObject splitPattern = FileUtil.splitPath(interp, pattern);
        boolean patternIsAbsolutePath = false;
        boolean ignoreZerothComponent = false;
        if (FileUtil.getPathType(pattern) == 2) {
            if (topDirectory == null) {
                patternIsAbsolutePath = true;
                if (TclList.getLength(interp, splitPattern) == 1) {
                    TclList.append(interp, resultList, TclString.newInstance(pattern));
                    return;
                }
            } else {
                patternIsAbsolutePath = false;
                ignoreZerothComponent = true;
            }
        }
        TclObject[] patternComponents = TclList.getElements(interp, splitPattern);
        GlobFilter[] componentGlobFilters = new GlobFilter[patternComponents.length];
        int i = 0;
        while (i < componentGlobFilters.length) {
            componentGlobFilters[i] = new GlobFilter(prefix, patternComponents[i].toString(), types, hasTrailingSeparator || i != componentGlobFilters.length - 1);
            ++i;
        }
        if (patternIsAbsolutePath) {
            stack.push(new GlobPair(new File(patternComponents[0].toString()), 1));
        } else {
            stack.push(new GlobPair(topDirectory, ignoreZerothComponent ? 1 : 0));
        }
        while (!stack.empty()) {
            String[] globResults;
            GlobPair globPair = (GlobPair)stack.pop();
            if (globPair.dir == null) {
                globResults = componentGlobFilters[globPair.componentIndex].list(interp.getWorkingDir());
            } else {
                File dir;
                if (globPair.dir.isAbsolute()) {
                    dir = globPair.dir;
                } else {
                    TclObject[] path = new TclObject[]{TclString.newInstance(interp.getWorkingDir().getAbsolutePath()), TclString.newInstance(globPair.dir.getPath())};
                    dir = new File(FileUtil.joinPath(interp, path, 0, 2));
                }
                globResults = componentGlobFilters[globPair.componentIndex].list(dir);
            }
            if (globResults == null) {
                return;
            }
            boolean atBottom = globPair.componentIndex == componentGlobFilters.length - 1;
            String[] stringArray = globResults;
            int n = globResults.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File f = new File(globPair.dir, name);
                if (atBottom) {
                    String filename;
                    String string = filename = tails ? f.getName() : f.getPath();
                    if (hasTrailingSeparator) {
                        filename = String.valueOf(filename) + File.separator;
                    }
                    TclList.append(interp, resultList, TclString.newInstance(filename));
                } else {
                    stack.push(new GlobPair(f, globPair.componentIndex + 1));
                }
                ++n2;
            }
        }
    }

    final class GlobFilter
    implements FilenameFilter {
        private String prefix;
        private String pattern;
        private boolean caseSensitive = true;
        private int types = 0;

        GlobFilter(String prefix, String pattern, int types, boolean mustBeDirectory) {
            this.prefix = prefix;
            this.caseSensitive = JACL.PLATFORM != 1;
            this.pattern = this.caseSensitive ? pattern : pattern.toUpperCase();
            this.types = types;
            if (mustBeDirectory) {
                this.types = 4;
            }
        }

        public String[] list(File dir) {
            String[] results = dir.list(this);
            boolean acceptDot = this.accept(dir, ".");
            boolean acceptDotDot = this.accept(dir, "..");
            int extra = 0;
            if (acceptDot) {
                ++extra;
            }
            if (acceptDotDot) {
                ++extra;
            }
            if (extra == 0) {
                return results;
            }
            String[] extraResults = new String[results.length + extra];
            System.arraycopy(results, 0, extraResults, 0, results.length);
            extra = results.length;
            if (acceptDot) {
                extraResults[extra++] = ".";
            }
            if (acceptDotDot) {
                extraResults[extra++] = "..";
            }
            return extraResults;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean typesTest;
            if (!this.caseSensitive) {
                name = name.toUpperCase();
            }
            if (this.prefix.length() > 0 && !name.startsWith(this.prefix)) {
                return false;
            }
            if (name.startsWith(".")) {
                if (JACL.PLATFORM == 0) {
                    if ((this.types & 0x800) == 0 && !this.pattern.startsWith(".")) {
                        return false;
                    }
                } else {
                    if (name.equals(".") && !this.pattern.startsWith(".")) {
                        return false;
                    }
                    if (name.equals("..") && !this.pattern.startsWith("..")) {
                        return false;
                    }
                }
            }
            if (!Util.stringMatch(name.substring(this.prefix.length()), this.pattern)) {
                return false;
            }
            if (this.types == 0) {
                return true;
            }
            File testFile = name.equals(".") ? dir.getAbsoluteFile() : (name.equals("..") ? dir.getAbsoluteFile().getParentFile() : new File(dir, name));
            if ((this.types & 0x7F) != 0) {
                typesTest = false;
                if ((this.types & 0x63) != 0) {
                    boolean bl = typesTest = typesTest || !testFile.isFile() && !testFile.isDirectory();
                }
                if ((this.types & 4) != 0) {
                    boolean bl = typesTest = typesTest || testFile.isDirectory();
                }
                if ((this.types & 8) != 0) {
                    boolean bl = typesTest = typesTest || testFile.isFile();
                }
                if ((this.types & 0x10) != 0) {
                    typesTest = typesTest || FileUtil.getLinkTarget(testFile) != null;
                }
            } else {
                typesTest = true;
            }
            if ((this.types & 0x80) != 0) {
                boolean bl = typesTest = typesTest && testFile.canRead();
            }
            if ((this.types & 0x100) != 0) {
                boolean bl = typesTest = typesTest && testFile.canWrite();
            }
            if ((this.types & 0x200) != 0) {
                boolean bl = typesTest = typesTest && FileUtil.isExecutable(testFile);
            }
            if ((this.types & 0x400) != 0) {
                boolean bl = typesTest = typesTest && testFile.canRead() && !testFile.canWrite();
            }
            if ((this.types & 0x800) != 0) {
                typesTest = typesTest && testFile.isHidden();
            }
            return typesTest;
        }
    }

    private final class GlobPair {
        File dir;
        int componentIndex;

        GlobPair(File dir, int index) {
            this.dir = dir;
            this.componentIndex = index;
        }
    }
}

