/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class IfCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        boolean value = false;
        boolean executedBody = false;
        int i = 1;
        while (true) {
            if (i >= objv.length) {
                throw new TclException(interp, "wrong # args: no expression after \"" + objv[i - 1] + "\" argument");
            }
            try {
                if (!executedBody) {
                    value = interp.expr.evalBoolean(interp, objv[i].toString());
                }
            }
            catch (TclException e) {
                switch (e.getCompletionCode()) {
                    case 1: {
                        interp.addErrorInfo("\n    (\"if\" test expression)");
                    }
                }
                throw e;
            }
            if (++i < objv.length && objv[i].toString().equals("then")) {
                ++i;
            }
            if (i >= objv.length) {
                throw new TclException(interp, "wrong # args: no script following \"" + objv[i - 1] + "\" argument");
            }
            if (value && !executedBody) {
                executedBody = true;
                try {
                    interp.eval(objv[i], 0);
                }
                catch (TclException e) {
                    switch (e.getCompletionCode()) {
                        case 1: {
                            interp.addErrorInfo("\n    (\"if\" then script line " + interp.errorLine + ")");
                        }
                    }
                    throw e;
                }
            }
            if (++i >= objv.length) {
                if (!executedBody) {
                    interp.resetResult();
                }
                return;
            }
            if (!objv[i].toString().equals("elseif")) break;
            objv[i].fixCommandStart();
            ++i;
        }
        if (objv[i].toString().equals("else")) {
            objv[i].fixCommandStart();
            if (++i >= objv.length) {
                throw new TclException(interp, "wrong # args: no script following \"else\" argument");
            }
            if (i != objv.length - 1) {
                throw new TclException(interp, "wrong # args: extra words after \"else\" clause in \"if\" command");
            }
        } else if (i != objv.length - 1) {
            throw new TclException(interp, "wrong # args: extra words after \"else\" clause in \"if\" command");
        }
        try {
            if (!executedBody) {
                executedBody = true;
                interp.eval(objv[i], 0);
            }
        }
        catch (TclException e) {
            switch (e.getCompletionCode()) {
                case 1: {
                    interp.addErrorInfo("\n    (\"if\" else script line " + interp.errorLine + ")");
                }
            }
            throw e;
        }
    }
}

