/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Var;

public class IncrCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        long incrAmount;
        if (objv.length != 2 && objv.length != 3) {
            throw new TclNumArgsException(interp, 1, objv, "varName ?increment?");
        }
        if (objv.length == 2) {
            incrAmount = 1L;
        } else {
            try {
                incrAmount = TclInteger.getLong(interp, objv[2]);
            }
            catch (TclException e) {
                interp.addErrorInfo("\n    (reading increment)");
                throw e;
            }
        }
        TclObject newValue = Var.incrVar(interp, objv[1].toString(), null, incrAmount, 512);
        interp.setResult(newValue);
    }
}

