/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.MathFunction;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.lang.cmd.InterpCmd;
import tcl.lang.cmd.NamespaceCmd;

public class InfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"args", "body", "cmdcount", "commands", "complete", "default", "exists", "functions", "globals", "hostname", "level", "library", "loaded", "locals", "nameofexecutable", "patchlevel", "procs", "script", "sharedlibextension", "tclversion", "vars"};
    static final int OPT_ARGS = 0;
    static final int OPT_BODY = 1;
    static final int OPT_CMDCOUNT = 2;
    static final int OPT_COMMANDS = 3;
    static final int OPT_COMPLETE = 4;
    static final int OPT_DEFAULT = 5;
    static final int OPT_EXISTS = 6;
    static final int OPT_FUNCTIONS = 7;
    static final int OPT_GLOBALS = 8;
    static final int OPT_HOSTNAME = 9;
    static final int OPT_LEVEL = 10;
    static final int OPT_LIBRARY = 11;
    static final int OPT_LOADED = 12;
    static final int OPT_LOCALS = 13;
    static final int OPT_NAMEOFEXECUTABLE = 14;
    static final int OPT_PATCHLEVEL = 15;
    static final int OPT_PROCS = 16;
    static final int OPT_SCRIPT = 17;
    static final int OPT_SHAREDLIBEXTENSION = 18;
    static final int OPT_TCLVERSION = 19;
    static final int OPT_VARS = 20;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg arg ...?");
        }
        int index = TclIndex.get(interp, objv[1], validCmds, "option", 0);
        switch (index) {
            case 0: {
                InfoCmd.InfoArgsCmd(interp, objv);
                break;
            }
            case 1: {
                InfoCmd.InfoBodyCmd(interp, objv);
                break;
            }
            case 2: {
                InfoCmd.InfoCmdCountCmd(interp, objv);
                break;
            }
            case 3: {
                InfoCmd.InfoCommandsCmd(interp, objv);
                break;
            }
            case 4: {
                InfoCmd.InfoCompleteCmd(interp, objv);
                break;
            }
            case 5: {
                InfoCmd.InfoDefaultCmd(interp, objv);
                break;
            }
            case 6: {
                InfoCmd.InfoExistsCmd(interp, objv);
                break;
            }
            case 7: {
                this.InfoFunctionsCmd(interp, objv);
                break;
            }
            case 8: {
                InfoCmd.InfoGlobalsCmd(interp, objv);
                break;
            }
            case 9: {
                InfoCmd.InfoHostnameCmd(interp, objv);
                break;
            }
            case 10: {
                InfoCmd.InfoLevelCmd(interp, objv);
                break;
            }
            case 11: {
                InfoCmd.InfoLibraryCmd(interp, objv);
                break;
            }
            case 12: {
                InfoCmd.InfoLoadedCmd(interp, objv);
                break;
            }
            case 13: {
                InfoCmd.InfoLocalsCmd(interp, objv);
                break;
            }
            case 14: {
                InfoCmd.InfoNameOfExecutableCmd(interp, objv);
                break;
            }
            case 15: {
                InfoCmd.InfoPatchLevelCmd(interp, objv);
                break;
            }
            case 16: {
                InfoCmd.InfoProcsCmd(interp, objv);
                break;
            }
            case 17: {
                InfoCmd.InfoScriptCmd(interp, objv);
                break;
            }
            case 18: {
                InfoCmd.InfoSharedlibCmd(interp, objv);
                break;
            }
            case 19: {
                InfoCmd.InfoTclVersionCmd(interp, objv);
                break;
            }
            case 20: {
                InfoCmd.InfoVarsCmd(interp, objv);
            }
        }
    }

    private static void InfoArgsCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "procname");
        }
        String name = objv[2].toString();
        Procedure proc = Procedure.findProc(interp, name);
        if (proc == null) {
            throw new TclException(interp, "\"" + name + "\" isn't a procedure");
        }
        TclObject listObj = TclList.newInstance();
        int i = 0;
        while (i < proc.argList.length) {
            TclObject s = TclString.newInstance(proc.argList[i][0]);
            TclList.append(interp, listObj, s);
            ++i;
        }
        interp.setResult(listObj);
    }

    private static void InfoBodyCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "procname");
        }
        String name = objv[2].toString();
        Procedure proc = Procedure.findProc(interp, name);
        if (proc == null) {
            throw new TclException(interp, "\"" + name + "\" isn't a procedure");
        }
        interp.setResult(proc.body.toString());
    }

    private static void InfoCmdCountCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.cmdCount);
    }

    private static void InfoCommandsCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace ns;
        String simplePattern;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        boolean specificNsInPattern = false;
        if (objv.length == 2) {
            simplePattern = null;
            ns = currNs;
            specificNsInPattern = false;
        } else if (objv.length == 3) {
            String pattern = objv[2].toString();
            Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, pattern, null, 0, gnfqnr);
            ns = gnfqnr.ns;
            simplePattern = gnfqnr.simpleName;
            if (ns != null) {
                specificNsInPattern = simplePattern.compareTo(pattern) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        if (ns != null) {
            String cmdName;
            for (Map.Entry<String, WrappedCommand> entry : ns.cmdTable.entrySet()) {
                TclObject elemObj;
                cmdName = entry.getKey();
                if (simplePattern != null && !Util.stringMatch(cmdName, simplePattern)) continue;
                if (specificNsInPattern) {
                    WrappedCommand cmd = entry.getValue();
                    elemObj = TclString.newInstance(interp.getCommandFullName(cmd));
                } else {
                    elemObj = TclString.newInstance(cmdName);
                }
                TclList.append(interp, list, elemObj);
            }
            if (ns != globalNs && !specificNsInPattern) {
                for (Map.Entry<String, WrappedCommand> entry : globalNs.cmdTable.entrySet()) {
                    cmdName = entry.getKey();
                    if (simplePattern != null && !Util.stringMatch(cmdName, simplePattern) || ns.cmdTable.get(cmdName) != null) continue;
                    TclList.append(interp, list, TclString.newInstance(cmdName));
                }
            }
        }
        interp.setResult(list);
    }

    private static void InfoCompleteCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "command");
        }
        interp.setResult(Interp.commandComplete(objv[2].toString()));
    }

    private static void InfoDefaultCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 5) {
            throw new TclNumArgsException(interp, 2, objv, "procname arg varname");
        }
        String procName = objv[2].toString();
        String argName = objv[3].toString();
        Procedure proc = Procedure.findProc(interp, procName);
        if (proc == null) {
            throw new TclException(interp, "\"" + procName + "\" isn't a procedure");
        }
        int i = 0;
        while (i < proc.argList.length) {
            if (argName.equals(proc.argList[i][0].toString())) {
                String varName = objv[4].toString();
                try {
                    if (proc.argList[i][1] != null) {
                        interp.setVar(varName, proc.argList[i][1], 0);
                        interp.setResult(1L);
                    } else {
                        interp.setVar(varName, "", 0);
                        interp.setResult(0L);
                    }
                }
                catch (TclException tclException) {
                    throw new TclException(interp, "couldn't store default value in variable \"" + varName + "\"");
                }
                return;
            }
            ++i;
        }
        throw new TclException(interp, "procedure \"" + procName + "\" doesn't have an argument \"" + argName + "\"");
    }

    private static void InfoExistsCmd(Interp interp, TclObject[] objv) throws TclException {
        Var var = null;
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "varName");
        }
        String varName = objv[2].toString();
        Var[] result = Var.lookupVar(interp, varName, null, 0, "access", false, false);
        if (result != null) {
            var = result[0];
        }
        if (var != null && !var.isVarUndefined()) {
            interp.setResult(true);
        } else {
            interp.setResult(false);
        }
    }

    private void InfoFunctionsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        Expression mathFns = new Expression();
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = objv[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        Set<Map.Entry<String, MathFunction>> set = mathFns.mathFuncTable.entrySet();
        for (Map.Entry<String, MathFunction> entry : set) {
            String varName = entry.getKey();
            if (pattern != null && !Util.stringMatch(varName, pattern)) continue;
            TclList.append(interp, list, TclString.newInstance(varName));
        }
        interp.setResult(list);
    }

    private static void InfoGlobalsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = NamespaceCmd.tail(objv[2].toString());
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        for (Map.Entry<String, Var> entry : globalNs.varTable.entrySet()) {
            String varName = entry.getKey();
            Var var = entry.getValue();
            if (var.isVarUndefined() || pattern != null && !Util.stringMatch(varName, pattern)) continue;
            TclList.append(interp, list, TclString.newInstance(varName));
        }
        interp.setResult(list);
    }

    private static void InfoHostnameCmd(Interp interp, TclObject[] objv) throws TclException {
        String name = null;
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (name != null) {
            interp.setResult(name);
            return;
        }
        interp.setResult("unable to determine name of host");
    }

    private static void InfoLevelCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length == 2) {
            if (interp.varFrame == null) {
                interp.setResult(0L);
            } else {
                interp.setResult(interp.varFrame.level);
            }
            return;
        }
        if (objv.length == 3) {
            int level = TclInteger.getInt(interp, objv[2]);
            if (level <= 0) {
                if (interp.varFrame == null) {
                    throw new TclException(interp, "bad level \"" + objv[2].toString() + "\"");
                }
                level += interp.varFrame.level;
            }
            CallFrame frame = interp.varFrame;
            while (frame != null) {
                if (frame.level == level) break;
                frame = frame.callerVar;
            }
            if (frame == null || frame.objv == null) {
                throw new TclException(interp, "bad level \"" + objv[2].toString() + "\"");
            }
            TclObject list = TclList.newInstance();
            int i = 0;
            while (i < frame.objv.length) {
                TclList.append(interp, list, TclString.newInstance(frame.objv[i]));
                ++i;
            }
            interp.setResult(list);
            return;
        }
        throw new TclNumArgsException(interp, 2, objv, "?number?");
    }

    private static void InfoLibraryCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        try {
            interp.setResult(interp.getVar("tcl_library", 1));
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "no library has been specified for Tcl");
        }
    }

    private static void InfoLoadedCmd(Interp interp, TclObject[] objv) throws TclException {
        Interp slaveInterp;
        if (objv.length != 2 && objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "?interp?");
        }
        if (objv.length == 3 && (slaveInterp = InterpCmd.getInterp(interp, objv[2])) == null) {
            throw new TclException(interp, "could not find interpreter \"" + objv[2].toString() + "\"");
        }
        interp.setResult(TclString.newInstance(""));
    }

    private static void InfoLocalsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = objv[2].toString();
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame) {
            return;
        }
        TclObject list = TclList.newInstance();
        Var.AppendLocals(interp, list, pattern, false);
        interp.setResult(list);
    }

    private static void InfoNameOfExecutableCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        String nameOfExecutable = interp.getNameOfExecutable();
        boolean createExecFile = false;
        File execFile = null;
        if (nameOfExecutable == null) {
            createExecFile = true;
        } else {
            execFile = new File(nameOfExecutable);
            if (!execFile.exists()) {
                createExecFile = true;
            }
        }
        if (createExecFile) {
            boolean isWindows = Util.isWindows();
            String eol = isWindows ? "\r\n" : "\n";
            String suffix = isWindows ? ".bat" : ".sh";
            try {
                execFile = File.createTempFile("jtcl", suffix);
                nameOfExecutable = execFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new TclException(interp, "Could not create temp file for [info nameofexecutable]");
            }
            String javaExecutable = "java";
            String javaHome = System.getProperty("java.home");
            if (javaHome != null) {
                String execSuffix = isWindows ? ".exe" : "";
                File javaPath = new File(new File(new File(javaHome), "bin"), "java" + execSuffix);
                if (javaPath.exists()) {
                    javaExecutable = javaPath.getPath();
                } else {
                    javaPath = new File(new File(new File(new File(javaHome), "jre"), "sh"), "java");
                    if (javaPath.exists()) {
                        javaExecutable = javaPath.getPath();
                    }
                }
            }
            String execLine = isWindows ? "@echo off" + eol : "#!" + eol + "exec ";
            execLine = String.valueOf(execLine) + "\"" + javaExecutable + "\"";
            String classpath = System.getProperty("java.class.path");
            if (classpath != null) {
                execLine = String.valueOf(execLine) + " -classpath \"" + classpath + "\" ";
            }
            execLine = String.valueOf(execLine) + interp.getShellClassName();
            execLine = String.valueOf(execLine) + (isWindows ? " %*" : " ${1+\"$@\"}") + eol;
            FileWriter out = null;
            try {
                out = new FileWriter(execFile);
                out.write(execLine);
                out.close();
            }
            catch (Exception exception) {
                throw new TclException(interp, "Could not write temp file [info nameofexecutable]");
            }
            execFile.deleteOnExit();
            if (!isWindows) {
                try {
                    Process process = Runtime.getRuntime().exec("chmod +x " + execFile.getPath());
                    process.waitFor();
                    process.destroy();
                }
                catch (Exception exception) {
                    throw new TclException(interp, "Couldn't set executable file as executable [name of executable]");
                }
            }
            interp.setNameOfExecutable(nameOfExecutable);
        }
        interp.setResult(nameOfExecutable);
    }

    private static void InfoPatchLevelCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.getVar("tcl_patchLevel", 1));
    }

    private static void InfoProcsCmd(Interp interp, TclObject[] objv) throws TclException {
        String pattern;
        Namespace namespace = Namespace.getCurrentNamespace(interp);
        String namespaceName = null;
        if (objv.length == 2) {
            pattern = null;
        } else if (objv.length == 3) {
            pattern = objv[2].toString();
            int nsEnd = pattern.lastIndexOf("::");
            if (nsEnd >= 0) {
                namespaceName = pattern.substring(0, nsEnd + 2);
                namespace = Namespace.findNamespace(interp, namespaceName, null, 0);
                pattern = pattern.substring(nsEnd + 2);
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        TclObject list = TclList.newInstance();
        if (namespace != null) {
            for (Map.Entry<String, WrappedCommand> entry : namespace.cmdTable.entrySet()) {
                String cmdName = entry.getKey();
                WrappedCommand cmd = entry.getValue();
                WrappedCommand realCmd = Namespace.getOriginalCommand(cmd);
                if (!Procedure.isProc(cmd) && (realCmd == null || !Procedure.isProc(realCmd)) || pattern != null && !Util.stringMatch(cmdName, pattern)) continue;
                String result = String.valueOf(namespaceName == null ? "" : String.valueOf(namespace.toString()) + "::") + cmdName;
                if (result.startsWith("::::")) {
                    result = result.substring(2);
                }
                TclList.append(interp, list, TclString.newInstance(result));
            }
        }
        interp.setResult(list);
    }

    private static void InfoScriptCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length == 3) {
            interp.scriptFile = objv[2].toString();
        } else if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, "?filename?");
        }
        interp.setResult(interp.scriptFile);
    }

    private static void InfoSharedlibCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(".jar");
    }

    private static void InfoTclVersionCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        interp.setResult(interp.getVar("tcl_version", 1));
    }

    private static void InfoVarsCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace ns;
        String simplePattern;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        boolean specificNsInPattern = false;
        if (objv.length == 2) {
            simplePattern = null;
            ns = currNs;
            specificNsInPattern = false;
        } else if (objv.length == 3) {
            String pattern = objv[2].toString();
            Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, pattern, null, 0, gnfqnr);
            ns = gnfqnr.ns;
            simplePattern = gnfqnr.simpleName;
            if (ns != null) {
                specificNsInPattern = simplePattern.compareTo(pattern) != 0;
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?pattern?");
        }
        if (ns == null) {
            return;
        }
        TclObject list = TclList.newInstance();
        if (interp.varFrame == null || !interp.varFrame.isProcCallFrame || specificNsInPattern) {
            Var var;
            String varName;
            for (Map.Entry<String, Var> entry : ns.varTable.entrySet()) {
                varName = entry.getKey();
                var = entry.getValue();
                if (var.isVarUndefined() && !var.isVarNamespace() || simplePattern != null && !Util.stringMatch(varName, simplePattern)) continue;
                TclObject elemObj = specificNsInPattern ? TclString.newInstance(Var.getVariableFullName(interp, var)) : TclString.newInstance(varName);
                TclList.append(interp, list, elemObj);
            }
            if (ns != globalNs && !specificNsInPattern) {
                for (Map.Entry<String, Var> entry : globalNs.varTable.entrySet()) {
                    varName = entry.getKey();
                    var = entry.getValue();
                    if (var.isVarUndefined() && !var.isVarNamespace() || simplePattern != null && !Util.stringMatch(varName, simplePattern) || ns.varTable.get(varName) != null) continue;
                    TclList.append(interp, list, TclString.newInstance(varName));
                }
            }
        } else {
            Var.AppendLocals(interp, list, simplePattern, true);
        }
        interp.setResult(list);
    }
}

