/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Var;

public class LappendCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        TclObject newValue = null;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "varName ?value value ...?");
        }
        if (objv.length == 2) {
            try {
                newValue = interp.getVar(objv[1], 0);
            }
            catch (TclException tclException) {
                TclObject varValue = TclList.newInstance();
                try {
                    newValue = interp.setVar(objv[1], varValue, 0);
                }
                finally {
                    if (newValue == null) {
                        varValue.release();
                    }
                }
                interp.resetResult();
                return;
            }
            TclList.getLength(interp, newValue);
        } else {
            newValue = LappendCmd.lappendVar(interp, objv[1].toString(), objv, 2);
        }
        interp.setResult(newValue);
    }

    public static TclObject lappendVar(Interp interp, String varName, TclObject[] values, int valuesInd) throws TclException {
        TclObject newValue;
        int len;
        TclObject varValue;
        boolean createdNewObj = false;
        boolean createVar = true;
        try {
            varValue = interp.getVar(varName, 0);
        }
        catch (TclException tclException) {
            if (Var.isArrayVarname(varName)) {
                int part1End = varName.indexOf(40);
                Var[] result = Var.lookupVar(interp, varName.substring(0, part1End), null, 0, "read", false, false);
                if (result != null && result[0].isVarUndefined()) {
                    Var.callTraces(interp, null, result[0], varName.substring(0, part1End), varName.substring(part1End + 1, varName.length() - 1), 16);
                }
                createVar = false;
            }
            varValue = TclList.newInstance();
            createdNewObj = true;
        }
        if (!createdNewObj && varValue.isShared()) {
            varValue = varValue.duplicate();
            createdNewObj = true;
        }
        if ((len = values.length) - valuesInd == 1) {
            TclList.append(interp, varValue, values[valuesInd]);
        } else {
            TclList.append(interp, varValue, values, valuesInd, len);
        }
        try {
            newValue = interp.setVar(varName, varValue, 0);
        }
        catch (TclException e) {
            if (createdNewObj && !createVar) {
                varValue.release();
            }
            throw e;
        }
        return newValue;
    }
}

