/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class LinsertCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 1, argv, "list index element ?element ...?");
        }
        int size = TclList.getLength(interp, argv[1]);
        int index = Util.getIntForIndex(interp, argv[2], size);
        TclObject list = argv[1];
        boolean isDuplicate = false;
        if (list.isShared()) {
            list = list.duplicate();
            isDuplicate = true;
        }
        try {
            TclList.insert(interp, list, index, argv, 3, argv.length - 1);
            interp.setResult(list);
        }
        catch (TclException e) {
            if (isDuplicate) {
                list.release();
            }
            throw e;
        }
    }
}

