/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.regex.PatternSyntaxException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Regex;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class LsearchCmd
implements Command {
    private static final String[] options = new String[]{"-all", "-ascii", "-decreasing", "-dictionary", "-exact", "-glob", "-increasing", "-inline", "-integer", "-not", "-real", "-regexp", "-sorted", "-start"};
    static final int LSEARCH_ALL = 0;
    static final int LSEARCH_ASCII = 1;
    static final int LSEARCH_DECREASING = 2;
    static final int LSEARCH_DICTIONARY = 3;
    static final int LSEARCH_EXACT = 4;
    static final int LSEARCH_GLOB = 5;
    static final int LSEARCH_INCREASING = 6;
    static final int LSEARCH_INLINE = 7;
    static final int LSEARCH_INTEGER = 8;
    static final int LSEARCH_NOT = 9;
    static final int LSEARCH_REAL = 10;
    static final int LSEARCH_REGEXP = 11;
    static final int LSEARCH_SORTED = 12;
    static final int LSEARCH_START = 13;
    static final int ASCII = 0;
    static final int DICTIONARY = 1;
    static final int INTEGER = 2;
    static final int REAL = 3;
    static final int EXACT = 0;
    static final int GLOB = 1;
    static final int REGEXP = 2;
    static final int SORTED = 3;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int mode = 1;
        int dataType = 0;
        int offset = 0;
        boolean isIncreasing = true;
        boolean allMatches = false;
        boolean inlineReturn = false;
        boolean negatedMatch = false;
        TclObject start = null;
        TclObject resultList = null;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "?options? list pattern");
        }
        int i = 1;
        while (i < objv.length - 2) {
            int opt = TclIndex.get(interp, objv[i], options, "option", 0);
            switch (opt) {
                case 0: {
                    allMatches = true;
                    break;
                }
                case 1: {
                    dataType = 0;
                    break;
                }
                case 2: {
                    isIncreasing = false;
                    break;
                }
                case 3: {
                    dataType = 1;
                    break;
                }
                case 4: {
                    mode = 0;
                    break;
                }
                case 5: {
                    mode = 1;
                    break;
                }
                case 6: {
                    isIncreasing = true;
                    break;
                }
                case 7: {
                    inlineReturn = true;
                    break;
                }
                case 8: {
                    dataType = 2;
                    break;
                }
                case 9: {
                    negatedMatch = true;
                    break;
                }
                case 10: {
                    dataType = 3;
                    break;
                }
                case 11: {
                    mode = 2;
                    break;
                }
                case 12: {
                    mode = 3;
                    break;
                }
                case 13: {
                    if (i > objv.length - 4) {
                        throw new TclException(interp, "missing starting index");
                    }
                    start = objv[++i].duplicate();
                }
            }
            ++i;
        }
        TclObject[] listv = TclList.getElements(interp, objv[objv.length - 2]);
        if (start != null) {
            offset = Util.getIntForIndex(interp, start, listv.length - 1);
            if (offset < 0) {
                offset = 0;
            }
            if (offset > listv.length - 1) {
                if (allMatches || inlineReturn) {
                    interp.resetResult();
                } else {
                    interp.setResult(TclInteger.newInstance(-1L));
                }
                return;
            }
        }
        TclObject patObj = objv[objv.length - 1].duplicate();
        String patternBytes = null;
        int patInt = 0;
        double patDouble = 0.0;
        int length = 0;
        if (mode == 0 || mode == 3) {
            switch (dataType) {
                case 0: 
                case 1: {
                    patternBytes = patObj.toString();
                    length = patternBytes.length();
                    break;
                }
                case 2: {
                    patInt = TclInteger.getInt(interp, patObj);
                    break;
                }
                case 3: {
                    patDouble = TclDouble.get(interp, patObj);
                }
            }
        } else {
            patternBytes = patObj.toString();
            length = patternBytes.length();
        }
        int index = -1;
        if (mode == 3 && !allMatches && !negatedMatch) {
            int match = 0;
            int lower = offset - 1;
            int upper = listv.length;
            while (lower + 1 != upper) {
                int i2 = lower + upper >>> 1;
                switch (dataType) {
                    case 0: {
                        String bytes = listv[i2].toString();
                        match = patternBytes.compareTo(bytes);
                        break;
                    }
                    case 1: {
                        String bytes = listv[i2].toString();
                        match = LsearchCmd.DictionaryCompare(patternBytes, bytes);
                        break;
                    }
                    case 2: {
                        int objInt = TclInteger.getInt(interp, listv[i2]);
                        if (patInt == objInt) {
                            match = 0;
                            break;
                        }
                        if (patInt < objInt) {
                            match = -1;
                            break;
                        }
                        match = 1;
                        break;
                    }
                    case 3: {
                        double objDouble = TclDouble.get(interp, listv[i2]);
                        match = patDouble == objDouble ? 0 : (patDouble < objDouble ? -1 : 1);
                    }
                }
                if (match == 0) {
                    index = i2;
                    upper = i2;
                    continue;
                }
                if (match > 0) {
                    if (isIncreasing) {
                        lower = i2;
                        continue;
                    }
                    upper = i2;
                    continue;
                }
                if (isIncreasing) {
                    upper = i2;
                    continue;
                }
                lower = i2;
            }
        } else {
            if (allMatches) {
                resultList = TclList.newInstance();
            }
            int i3 = offset;
            while (i3 < listv.length) {
                boolean match = false;
                switch (mode) {
                    case 0: 
                    case 3: {
                        switch (dataType) {
                            case 0: {
                                String bytes = listv[i3].toString();
                                int elemLen = bytes.length();
                                if (length != elemLen) break;
                                match = bytes.equals(patternBytes);
                                break;
                            }
                            case 1: {
                                String bytes = listv[i3].toString();
                                match = LsearchCmd.DictionaryCompare(bytes, patternBytes) == 0;
                                break;
                            }
                            case 2: {
                                int objInt = TclInteger.getInt(interp, listv[i3]);
                                match = objInt == patInt;
                                break;
                            }
                            case 3: {
                                double objDouble = TclDouble.get(interp, listv[i3]);
                                match = objDouble == patDouble;
                            }
                        }
                        break;
                    }
                    case 1: {
                        match = Util.stringMatch(listv[i3].toString(), patternBytes);
                        break;
                    }
                    case 2: {
                        try {
                            Regex regexp = new Regex(patObj.toString(), listv[i3].toString(), 0);
                            match = regexp.match();
                            break;
                        }
                        catch (PatternSyntaxException ex) {
                            throw new TclException(interp, Regex.getPatternSyntaxMessage(ex));
                        }
                    }
                }
                if (negatedMatch) {
                    boolean bl = match = !match;
                }
                if (match) {
                    if (!allMatches) {
                        index = i3;
                        break;
                    }
                    if (inlineReturn) {
                        TclList.append(interp, resultList, listv[i3]);
                    } else {
                        TclList.append(interp, resultList, TclInteger.newInstance(i3));
                    }
                }
                ++i3;
            }
        }
        if (allMatches) {
            interp.setResult(resultList);
        } else if (!inlineReturn) {
            interp.setResult(index);
        } else if (index < 0) {
            interp.resetResult();
        } else {
            interp.setResult(listv[index]);
        }
    }

    private static int DictionaryCompare(String left, String right) {
        int diff;
        char[] leftArr = left.toCharArray();
        char[] rightArr = right.toCharArray();
        int lInd = 0;
        int rInd = 0;
        int secondaryDiff = 0;
        block0: while (true) {
            if (rInd < rightArr.length && Character.isDigit(rightArr[rInd]) && lInd < leftArr.length && Character.isDigit(leftArr[lInd])) {
                int zeros = 0;
                while (rightArr[rInd] == '0' && rInd + 1 < rightArr.length && Character.isDigit(rightArr[rInd + 1])) {
                    ++rInd;
                    --zeros;
                }
                while (leftArr[lInd] == '0' && lInd + 1 < leftArr.length && Character.isDigit(leftArr[lInd + 1])) {
                    ++lInd;
                    ++zeros;
                }
                if (secondaryDiff == 0) {
                    secondaryDiff = zeros;
                }
                diff = 0;
                do {
                    if (diff == 0 && lInd < leftArr.length && rInd < rightArr.length) {
                        diff = leftArr[lInd] - rightArr[rInd];
                    }
                    ++lInd;
                    if (++rInd < rightArr.length && Character.isDigit(rightArr[rInd])) continue;
                    if (lInd < leftArr.length && Character.isDigit(leftArr[lInd])) {
                        return 1;
                    }
                    if (diff == 0) continue block0;
                    return diff;
                } while (lInd < leftArr.length && Character.isDigit(leftArr[lInd]));
                return -1;
            }
            if (lInd >= leftArr.length || rInd >= rightArr.length) {
                if (lInd < leftArr.length) {
                    diff = -rightArr[rInd];
                    break;
                }
                if (rInd < rightArr.length) {
                    diff = leftArr[lInd];
                    break;
                }
                diff = 0;
                break;
            }
            char leftChar = leftArr[lInd++];
            char rightChar = rightArr[rInd++];
            char leftLower = Character.toLowerCase(leftChar);
            char rightLower = Character.toLowerCase(rightChar);
            diff = leftLower - rightLower;
            if (diff != 0) {
                return diff;
            }
            if (secondaryDiff != 0) continue;
            if (Character.isUpperCase(leftChar) && Character.isLowerCase(rightChar)) {
                secondaryDiff = -1;
                continue;
            }
            if (!Character.isUpperCase(rightChar) || !Character.isLowerCase(leftChar)) continue;
            secondaryDiff = 1;
        }
        if (diff == 0) {
            diff = secondaryDiff;
        }
        return diff;
    }
}

