/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;

public class LsetCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        TclObject finalValue;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "listVar index ?index...? value");
        }
        TclObject list = Var.getVar(interp, objv[1].toString(), null, 512);
        if (list == null) {
            throw new TclException(interp, "Cannot find variable name " + objv[1].toString());
        }
        if (objv.length == 4) {
            finalValue = LsetCmd.list(interp, list, objv[2], objv[3]);
        } else {
            TclObject[] indices = new TclObject[objv.length - 3];
            if (objv.length > 4) {
                int i = 0;
                while (i < objv.length - 3) {
                    indices[i] = objv[i + 2];
                    ++i;
                }
            }
            finalValue = LsetCmd.flat(interp, list, objv.length - 3, indices, objv[objv.length - 1]);
        }
        if (finalValue == null) {
            throw new TclException(interp, "Substitution has failed!");
        }
        list = Var.setVar(interp, objv[1].toString(), null, finalValue, 512);
        finalValue.release();
        if (list == null) {
            throw new TclException(interp, "Cannot update variable");
        }
        interp.setResult(list);
    }

    private static final TclObject flat(Interp interp, TclObject list, int indexCount, TclObject[] indexArray, TclObject value) throws TclException {
        boolean duplicated;
        boolean result = false;
        int index = 0;
        ArrayList<TclObject> chainList = new ArrayList<TclObject>();
        if (indexCount == 0) {
            value.preserve();
            return value;
        }
        if (list.isShared()) {
            duplicated = true;
            list = list.duplicate();
            list.preserve();
        } else {
            duplicated = false;
        }
        TclObject retValue = list;
        int i = 0;
        while (true) {
            int elemCount;
            ArrayList elems;
            try {
                elems = TclList.getElementsList(interp, list);
                elemCount = elems.size();
            }
            catch (TclException tclException) {
                break;
            }
            index = Util.getIntForIndex(interp, indexArray[i], elemCount - 1);
            if (index < 0 || index >= elemCount) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(interp, "list index out of range");
            }
            if (i >= indexCount - 1) {
                result = false;
                break;
            }
            TclObject subList = (TclObject)elems.get(index);
            if (subList.isShared()) {
                subList = subList.duplicate();
                try {
                    TclList.setElement(interp, list, index, subList);
                }
                catch (TclException tclException) {
                    break;
                }
            }
            chainList.add(list);
            list = subList;
            ++i;
        }
        if (!result) {
            try {
                TclList.lsetElement(interp, list, index, value);
                int chainListLen = chainList.size();
                int i2 = 0;
                while (i2 < chainListLen) {
                    TclObject tobj = (TclObject)chainList.get(i2);
                    tobj.invalidateStringRep();
                    ++i2;
                }
                list.invalidateStringRep();
                if (!duplicated) {
                    retValue.preserve();
                }
                return retValue;
            }
            catch (TclException e) {
                if (duplicated) {
                    retValue.release();
                }
                throw e;
            }
        }
        if (duplicated) {
            retValue.release();
        }
        return null;
    }

    private static final TclObject list(Interp interp, TclObject list, TclObject indexArg, TclObject value) throws TclException {
        boolean duplicated;
        int indexCount;
        TclObject[] indices;
        ArrayList<TclObject> chainList;
        boolean result;
        int index;
        block27: {
            index = 0;
            result = false;
            chainList = new ArrayList<TclObject>();
            if (!indexArg.isListType()) {
                try {
                    index = Util.getIntForIndex(null, indexArg, 0);
                    return LsetCmd.flat(interp, list, 1, TclList.getElements(interp, indexArg), value);
                }
                catch (TclException e) {
                    try {
                        indices = TclList.getElements(null, indexArg);
                        indexCount = indices.length;
                        break block27;
                    }
                    catch (TclException tclException) {
                        interp.setResult(TclString.newInstance(e.getMessage()));
                        throw e;
                    }
                }
            }
            try {
                indices = TclList.getElements(null, indexArg);
                indexCount = indices.length;
            }
            catch (TclException tclException) {
                return LsetCmd.flat(interp, list, 1, TclList.getElements(interp, indexArg), value);
            }
        }
        if (indexCount == 0) {
            value.preserve();
            return value;
        }
        if (list.isShared()) {
            duplicated = true;
            list = list.duplicate();
            list.preserve();
        } else {
            duplicated = false;
        }
        TclObject retValue = list;
        int i = 0;
        while (true) {
            int elemCount;
            ArrayList elems;
            try {
                elems = TclList.getElementsList(interp, list);
                elemCount = elems.size();
            }
            catch (TclException tclException) {
                break;
            }
            try {
                indices = TclList.getElements(interp, indexArg);
                indexCount = indices.length;
            }
            catch (TclException tclException) {
                break;
            }
            index = Util.getIntForIndex(interp, indices[i], elemCount - 1);
            if (index < 0 || index >= elemCount) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(interp, "list index out of range");
            }
            if (i >= indexCount - 1) {
                result = false;
                break;
            }
            TclObject subList = (TclObject)elems.get(index);
            if (subList.isShared()) {
                subList = subList.duplicate();
                try {
                    TclList.setElement(interp, list, index, subList);
                }
                catch (TclException tclException) {
                    break;
                }
            }
            chainList.add(list);
            list = subList;
            ++i;
        }
        if (!result) {
            try {
                TclList.lsetElement(interp, list, index, value);
                int chainListLen = chainList.size();
                int i2 = 0;
                while (i2 < chainListLen) {
                    TclObject tobj = (TclObject)chainList.get(i2);
                    tobj.invalidateStringRep();
                    ++i2;
                }
                list.invalidateStringRep();
                if (!duplicated) {
                    retValue.preserve();
                }
                return retValue;
            }
            catch (TclException e) {
                if (duplicated) {
                    retValue.release();
                }
                throw e;
            }
        }
        if (duplicated) {
            retValue.release();
        }
        return null;
    }
}

