/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class LsortCmd
implements Command {
    private static final String[] validOpts = new String[]{"-ascii", "-command", "-decreasing", "-dictionary", "-increasing", "-index", "-integer", "-real", "-unique"};
    static final int OPT_ASCII = 0;
    static final int OPT_COMMAND = 1;
    static final int OPT_DECREASING = 2;
    static final int OPT_DICTIONARY = 3;
    static final int OPT_INCREASING = 4;
    static final int OPT_INDEX = 5;
    static final int OPT_INTEGER = 6;
    static final int OPT_REAL = 7;
    static final int OPT_UNIQUE = 8;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?options? list");
        }
        String command = null;
        int sortMode = 0;
        int sortIndex = -1;
        boolean sortIncreasing = true;
        boolean unique = false;
        int i = 1;
        while (i < argv.length - 1) {
            int index = TclIndex.get(interp, argv[i], validOpts, "option", 0);
            switch (index) {
                case 0: {
                    sortMode = 0;
                    break;
                }
                case 1: {
                    if (i == argv.length - 2) {
                        throw new TclException(interp, "\"-command\" option must be followed by comparison command");
                    }
                    sortMode = 3;
                    command = argv[i + 1].toString();
                    ++i;
                    break;
                }
                case 2: {
                    sortIncreasing = false;
                    break;
                }
                case 3: {
                    sortMode = 4;
                    break;
                }
                case 4: {
                    sortIncreasing = true;
                    break;
                }
                case 5: {
                    if (i == argv.length - 2) {
                        throw new TclException(interp, "\"-index\" option must be followed by list index");
                    }
                    sortIndex = Util.getIntForIndex(interp, argv[i + 1], -2);
                    ++i;
                    break;
                }
                case 6: {
                    sortMode = 1;
                    break;
                }
                case 7: {
                    sortMode = 2;
                    break;
                }
                case 8: {
                    unique = true;
                }
            }
            ++i;
        }
        TclObject list = argv[argv.length - 1];
        boolean isDuplicate = false;
        if (list.isShared()) {
            list = list.duplicate();
            isDuplicate = true;
        }
        try {
            TclList.sort(interp, list, sortMode, sortIndex, sortIncreasing, unique, command);
            interp.setResult(list);
        }
        catch (TclException e) {
            if (isDuplicate) {
                list.release();
            }
            throw e;
        }
    }
}

