/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class NamespaceCmd
implements InternalRep,
Command {
    Namespace.ResolvedNsName otherValue = null;
    private static final String[] validCmds = new String[]{"children", "code", "current", "delete", "eval", "exists", "export", "forget", "import", "inscope", "origin", "parent", "qualifiers", "tail", "which"};
    private static final int OPT_CHILDREN = 0;
    private static final int OPT_CODE = 1;
    private static final int OPT_CURRENT = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_EVAL = 4;
    private static final int OPT_EXISTS = 5;
    private static final int OPT_EXPORT = 6;
    private static final int OPT_FORGET = 7;
    private static final int OPT_IMPORT = 8;
    private static final int OPT_INSCOPE = 9;
    private static final int OPT_ORIGIN = 10;
    private static final int OPT_PARENT = 11;
    private static final int OPT_QUALIFIERS = 12;
    private static final int OPT_TAIL = 13;
    private static final int OPT_WHICH = 14;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "subcommand ?arg ...?");
        }
        int opt = TclIndex.get(interp, objv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                NamespaceCmd.childrenCmd(interp, objv);
                return;
            }
            case 1: {
                NamespaceCmd.codeCmd(interp, objv);
                return;
            }
            case 2: {
                NamespaceCmd.currentCmd(interp, objv);
                return;
            }
            case 3: {
                NamespaceCmd.deleteCmd(interp, objv);
                return;
            }
            case 4: {
                NamespaceCmd.evalCmd(interp, objv);
                return;
            }
            case 5: {
                NamespaceCmd.existsCmd(interp, objv);
                return;
            }
            case 6: {
                NamespaceCmd.exportCmd(interp, objv);
                return;
            }
            case 7: {
                NamespaceCmd.forgetCmd(interp, objv);
                return;
            }
            case 8: {
                NamespaceCmd.importCmd(interp, objv);
                return;
            }
            case 9: {
                NamespaceCmd.inscopeCmd(interp, objv);
                return;
            }
            case 10: {
                NamespaceCmd.originCmd(interp, objv);
                return;
            }
            case 11: {
                NamespaceCmd.parentCmd(interp, objv);
                return;
            }
            case 12: {
                NamespaceCmd.qualifiersCmd(interp, objv);
                return;
            }
            case 13: {
                NamespaceCmd.tailCmd(interp, objv);
                return;
            }
            case 14: {
                NamespaceCmd.whichCmd(interp, objv);
                return;
            }
        }
    }

    private static void childrenCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace ns;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        String pattern = null;
        if (objv.length == 2) {
            ns = Namespace.getCurrentNamespace(interp);
        } else if (objv.length == 3 || objv.length == 4) {
            ns = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
            if (ns == null) {
                throw new TclException(interp, "unknown namespace \"" + objv[2].toString() + "\" in namespace children command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?name? ?pattern?");
        }
        StringBuffer buffer = new StringBuffer();
        if (objv.length == 4) {
            String name = objv[3].toString();
            if (name.startsWith("::")) {
                pattern = name;
            } else {
                buffer.append(ns.fullName);
                if (ns != globalNs) {
                    buffer.append("::");
                }
                buffer.append(name);
                pattern = buffer.toString();
            }
        }
        TclObject list = TclList.newInstance();
        for (Map.Entry<String, Namespace> entry : ns.childTable.entrySet()) {
            Namespace childNs = entry.getValue();
            if (pattern != null && !Util.stringMatch(childNs.fullName, pattern)) continue;
            TclObject elem = TclString.newInstance(childNs.fullName);
            TclList.append(interp, list, elem);
        }
        interp.setResult(list);
    }

    private static void codeCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "arg");
        }
        String arg = objv[2].toString();
        int length = arg.length();
        if (length > 17 && arg.charAt(0) == 'n' && arg.startsWith("namespace")) {
            int p_ind = 9;
            while (p_ind < length && arg.charAt(p_ind) == ' ') {
                ++p_ind;
            }
            if (length - p_ind >= 7 && arg.charAt(p_ind) == 'i' && arg.startsWith("inscope", p_ind)) {
                interp.setResult(objv[2]);
                return;
            }
        }
        TclObject list = TclList.newInstance();
        TclList.append(interp, list, TclString.newInstance("::namespace"));
        TclList.append(interp, list, TclString.newInstance("inscope"));
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        TclObject obj = currNs == Namespace.getGlobalNamespace(interp) ? TclString.newInstance("::") : TclString.newInstance(currNs.fullName);
        TclList.append(interp, list, obj);
        TclList.append(interp, list, objv[2]);
        interp.setResult(list);
    }

    private static void currentCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, null);
        }
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        if (currNs == Namespace.getGlobalNamespace(interp)) {
            interp.setResult("::");
        } else {
            interp.setResult(currNs.fullName);
        }
    }

    private static void deleteCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace namespace;
        String name;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?name name...?");
        }
        int i = 2;
        while (i < objv.length) {
            name = objv[i].toString();
            namespace = Namespace.findNamespace(interp, name, null, 0);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + objv[i].toString() + "\" in namespace delete command");
            }
            ++i;
        }
        i = 2;
        while (i < objv.length) {
            name = objv[i].toString();
            namespace = Namespace.findNamespace(interp, name, null, 0);
            if (namespace != null) {
                Namespace.deleteNamespace(namespace);
            }
            ++i;
        }
    }

    private static void evalCmd(Interp interp, TclObject[] objv) throws TclException {
        String name;
        if (objv.length < 4) {
            throw new TclNumArgsException(interp, 2, objv, "name arg ?arg...?");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
        if (namespace == null && (namespace = Namespace.createNamespace(interp, name = objv[2].toString(), null)) == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        CallFrame frame = interp.newCallFrame();
        frame.objv = new TclObject[objv.length];
        System.arraycopy(objv, 0, frame.objv, 0, objv.length);
        Namespace.pushCallFrame(interp, frame, namespace, false);
        try {
            try {
                if (objv.length == 4) {
                    interp.eval(objv[3], 0);
                } else {
                    TclObject obj = Util.concat(3, objv.length, objv);
                    interp.eval(obj, 0);
                }
            }
            catch (TclException ex) {
                if (ex.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    (in namespace eval \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
                    interp.errAlreadyLogged = false;
                }
                throw ex;
            }
        }
        finally {
            Namespace.popCallFrame(interp);
        }
    }

    private static void existsCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "name");
        }
        Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
        interp.setResult(namespace != null);
    }

    private static void exportCmd(Interp interp, TclObject[] objv) throws TclException {
        int patternCt;
        String string;
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        boolean resetListFirst = false;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?-clear? ?pattern pattern...?");
        }
        int firstArg = 2;
        if (firstArg < objv.length && (string = objv[firstArg].toString()).equals("-clear")) {
            resetListFirst = true;
            ++firstArg;
        }
        if ((patternCt = objv.length - firstArg) == 0) {
            if (firstArg > 2) {
                return;
            }
            TclObject list = TclList.newInstance();
            Namespace.appendExportList(interp, currNs, list);
            interp.setResult(list);
            return;
        }
        int i = firstArg;
        while (i < objv.length) {
            String pattern = objv[i].toString();
            Namespace.exportList(interp, currNs, pattern, i == firstArg ? resetListFirst : false);
            ++i;
        }
    }

    private static void forgetCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?pattern pattern...?");
        }
        int i = 2;
        while (i < objv.length) {
            String pattern = objv[i].toString();
            Namespace.forgetImport(interp, null, pattern);
            ++i;
        }
    }

    private static void importCmd(Interp interp, TclObject[] objv) throws TclException {
        String string;
        boolean allowOverwrite = false;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 2, objv, "?-force? ?pattern pattern...?");
        }
        int firstArg = 2;
        if (firstArg < objv.length && (string = objv[firstArg].toString()).equals("-force")) {
            allowOverwrite = true;
            ++firstArg;
        }
        int i = firstArg;
        while (i < objv.length) {
            String pattern = objv[i].toString();
            Namespace.importList(interp, null, pattern, allowOverwrite);
            ++i;
        }
    }

    private static void inscopeCmd(Interp interp, TclObject[] objv) throws TclException {
        block15: {
            if (objv.length < 4) {
                throw new TclNumArgsException(interp, 2, objv, "name arg ?arg...?");
            }
            Namespace namespace = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
            if (namespace == null) {
                throw new TclException(interp, "unknown namespace \"" + objv[2].toString() + "\" in inscope namespace command");
            }
            CallFrame frame = interp.newCallFrame();
            frame.objv = new TclObject[objv.length];
            System.arraycopy(objv, 0, frame.objv, 0, objv.length);
            Namespace.pushCallFrame(interp, frame, namespace, false);
            try {
                try {
                    if (objv.length == 4) {
                        interp.eval(objv[3], 0);
                        break block15;
                    }
                    TclObject[] concatObjv = new TclObject[2];
                    TclObject list = TclList.newInstance();
                    int i = 4;
                    while (i < objv.length) {
                        try {
                            TclList.append(interp, list, objv[i]);
                        }
                        catch (TclException ex) {
                            list.release();
                            throw ex;
                        }
                        ++i;
                    }
                    concatObjv[0] = objv[3];
                    concatObjv[1] = list;
                    list.preserve();
                    TclObject cmd = Util.concat(0, 1, concatObjv);
                    try {
                        interp.eval(cmd, 0);
                    }
                    finally {
                        list.release();
                    }
                }
                catch (TclException ex) {
                    if (ex.getCompletionCode() == 1) {
                        interp.addErrorInfo("\n    (in namespace inscope \"" + namespace.fullName + "\" script line " + interp.errorLine + ")");
                    }
                    throw ex;
                }
            }
            finally {
                Namespace.popCallFrame(interp);
            }
        }
    }

    private static void originCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "name");
        }
        WrappedCommand command = Namespace.findCommand(interp, objv[2].toString(), null, 0);
        if (command == null) {
            throw new TclException(interp, "invalid command name \"" + objv[2].toString() + "\"");
        }
        WrappedCommand origCommand = Namespace.getOriginalCommand(command);
        if (origCommand == null) {
            interp.setResult(interp.getCommandFullName(command));
        } else {
            interp.setResult(interp.getCommandFullName(origCommand));
        }
    }

    private static void parentCmd(Interp interp, TclObject[] objv) throws TclException {
        Namespace ns;
        if (objv.length == 2) {
            ns = Namespace.getCurrentNamespace(interp);
        } else if (objv.length == 3) {
            ns = NamespaceCmd.getNamespaceFromObj(interp, objv[2]);
            if (ns == null) {
                throw new TclException(interp, "unknown namespace \"" + objv[2].toString() + "\" in namespace parent command");
            }
        } else {
            throw new TclNumArgsException(interp, 2, objv, "?name?");
        }
        if (ns.parent != null) {
            interp.setResult(ns.parent.fullName);
        }
    }

    private static void qualifiersCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "string");
        }
        String name = objv[2].toString();
        int p = name.length();
        while (--p >= 0) {
            if (name.charAt(p) != ':' || p <= 0 || name.charAt(p - 1) != ':') continue;
            p -= 2;
            while (p >= 0 && name.charAt(p) == ':') {
                --p;
            }
            break block0;
        }
        if (p >= 0) {
            interp.setResult(name.substring(0, p + 1));
        }
    }

    private static void tailCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 3) {
            throw new TclNumArgsException(interp, 2, objv, "string");
        }
        String name = objv[2].toString();
        String tail = NamespaceCmd.tail(name);
        interp.setResult(tail);
    }

    public static String tail(String qname) {
        int i = qname.lastIndexOf("::");
        String tail = i == -1 ? qname : ((i += 2) >= qname.length() ? "" : qname.substring(i));
        return tail;
    }

    private static void whichCmd(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 2, objv, "?-command? ?-variable? name");
        }
        int argIndex = 2;
        int lookup = 0;
        String arg = objv[2].toString();
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            if (arg.equals("-command")) {
                lookup = 0;
            } else if (arg.equals("-variable")) {
                lookup = 1;
            } else {
                throw new TclNumArgsException(interp, 2, objv, "?-command? ?-variable? name");
            }
            argIndex = 3;
        }
        if (objv.length != argIndex + 1) {
            throw new TclNumArgsException(interp, 2, objv, "?-command? ?-variable? name");
        }
        switch (lookup) {
            case 0: {
                arg = objv[argIndex].toString();
                WrappedCommand cmd = Namespace.findCommand(interp, arg, null, 0);
                if (cmd == null) {
                    return;
                }
                interp.setResult(interp.getCommandFullName(cmd));
                return;
            }
            case 1: {
                arg = objv[argIndex].toString();
                Var variable = Namespace.findNamespaceVar(interp, arg, null, 0);
                if (variable != null) {
                    interp.setResult(Var.getVariableFullName(interp, variable));
                }
                return;
            }
        }
    }

    @Override
    public void dispose() {
        Namespace.ResolvedNsName resName = this.otherValue;
        if (resName != null) {
            --resName.refCount;
            if (resName.refCount == 0) {
                Namespace ns = resName.ns;
                --ns.refCount;
                if (ns.refCount == 0 && (ns.flags & 2) != 0) {
                    Namespace.free(ns);
                }
                this.otherValue = null;
            }
        }
    }

    @Override
    public InternalRep duplicate() {
        Namespace.ResolvedNsName resName = this.otherValue;
        if (resName != null) {
            ++resName.refCount;
        }
        return this;
    }

    static void setNsNameFromAny(Interp interp, TclObject tobj) throws TclException {
        Namespace.ResolvedNsName resName;
        String name = tobj.toString();
        Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, name, null, 4096, gnfqnr);
        Namespace ns = gnfqnr.ns;
        if (ns != null) {
            Namespace currNs = Namespace.getCurrentNamespace(interp);
            ++ns.refCount;
            resName = new Namespace.ResolvedNsName();
            resName.ns = ns;
            resName.nsId = ns.nsId;
            resName.refNs = currNs;
            resName.refCount = 1;
        } else {
            resName = null;
        }
        NamespaceCmd wrap = new NamespaceCmd();
        wrap.otherValue = resName;
        tobj.setInternalRep(wrap);
    }

    static Namespace getNamespaceFromObj(Interp interp, TclObject obj) throws TclException {
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        if (!(obj.getInternalRep() instanceof NamespaceCmd)) {
            NamespaceCmd.setNsNameFromAny(interp, obj);
        }
        Namespace.ResolvedNsName resName = ((NamespaceCmd)obj.getInternalRep()).otherValue;
        Namespace ns = null;
        if (resName != null && resName.refNs == currNs && resName.nsId == resName.ns.nsId) {
            ns = resName.ns;
            if ((ns.flags & 2) != 0) {
                ns = null;
            }
        }
        if (ns == null) {
            NamespaceCmd.setNsNameFromAny(interp, obj);
            resName = ((NamespaceCmd)obj.getInternalRep()).otherValue;
            if (resName != null) {
                ns = resName.ns;
                if ((ns.flags & 2) != 0) {
                    ns = null;
                }
            }
        }
        return ns;
    }

    public String toString() {
        Namespace.ResolvedNsName resName = this.otherValue;
        String name = "";
        if (resName != null && resName.nsId == resName.ns.nsId) {
            Namespace ns = resName.ns;
            if ((ns.flags & 2) != 0) {
                ns = null;
            }
            if (ns != null) {
                name = ns.fullName;
            }
        }
        return name;
    }
}

