/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.channel.FileChannel;
import tcl.lang.channel.PipelineChannel;
import tcl.lang.channel.ResourceChannel;

public class OpenCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String fileName;
        int modeFlags;
        boolean isBinaryEncoding;
        boolean pipeline;
        block52: {
            TclObject mode;
            block53: {
                pipeline = false;
                isBinaryEncoding = false;
                boolean isReadWrite = false;
                modeFlags = 1;
                if (argv.length < 2 || argv.length > 4) {
                    throw new TclNumArgsException(interp, 1, argv, "fileName ?access? ?permissions?");
                }
                if (argv.length <= 2) break block52;
                mode = argv[2];
                String modeStr = mode.toString();
                int len = modeStr.length();
                if (len == 0 || modeStr.startsWith("r+") && len >= 4) {
                    throw new TclException(interp, "illegal access mode \"" + modeStr + "\"");
                }
                if (len > 1 && len < 4) {
                    String rest = modeStr.substring(1);
                    if (rest.equals("b") || rest.equals("+") || rest.equals("b+") || rest.equals("+b")) {
                        if (rest.equals("+") || rest.equals("+b") || rest.equals("b+")) {
                            isReadWrite = true;
                        }
                        if (rest.equals("b") || rest.equals("+b") || rest.equals("b+")) {
                            isBinaryEncoding = true;
                        }
                    } else {
                        throw new TclException(interp, "illegal access mode \"" + modeStr + "\"");
                    }
                }
                if (len >= 4) break block53;
                switch (modeStr.charAt(0)) {
                    case 'r': {
                        modeFlags = 1;
                        if (isReadWrite) {
                            modeFlags = 4;
                        }
                        break block52;
                    }
                    case 'w': {
                        modeFlags = 82;
                        if (isReadWrite) {
                            modeFlags = 84;
                        }
                        break block52;
                    }
                    case 'a': {
                        modeFlags = 10;
                        if (isReadWrite) {
                            modeFlags = 28;
                        }
                        break block52;
                    }
                    default: {
                        throw new TclException(interp, "illegal access mode \"" + modeStr + "\"");
                    }
                }
            }
            modeFlags = 0;
            boolean gotRorWflag = false;
            int mlen = 0;
            try {
                mlen = TclList.getLength(interp, mode);
            }
            catch (TclException e) {
                if (e.getCompletionCode() == 1) {
                    interp.addErrorInfo("\n    while processing open access modes \"" + mode + "\"");
                }
                throw e;
            }
            int i = 0;
            while (i < mlen) {
                TclObject marg = TclList.index(interp, mode, i);
                if (marg.toString().equals("RDONLY")) {
                    modeFlags |= 1;
                    gotRorWflag = true;
                } else if (marg.toString().equals("WRONLY")) {
                    modeFlags |= 2;
                    gotRorWflag = true;
                } else if (marg.toString().equals("RDWR")) {
                    modeFlags |= 4;
                    gotRorWflag = true;
                } else if (marg.toString().equals("APPEND")) {
                    modeFlags |= 8;
                } else if (marg.toString().equals("CREAT")) {
                    modeFlags |= 0x10;
                } else if (marg.toString().equals("EXCL")) {
                    modeFlags |= 0x20;
                } else if (marg.toString().equals("TRUNC")) {
                    modeFlags |= 0x40;
                } else if (marg.toString().equals("BINARY")) {
                    isBinaryEncoding = true;
                } else {
                    throw new TclException(interp, "invalid access mode \"" + marg.toString() + "\": must be RDONLY, WRONLY, RDWR, APPEND, " + "CREAT EXCL, NOCTTY, NONBLOCK, TRUNC, or BINARY");
                }
                ++i;
            }
            if (!gotRorWflag) {
                throw new TclException(interp, "access mode must include either RDONLY, WRONLY, or RDWR");
            }
        }
        if (argv.length == 4) {
            TclInteger.getInt(interp, argv[3]);
            throw new TclException(interp, "setting permissions not implemented yet");
        }
        if (argv[1].toString().length() > 0 && argv[1].toString().charAt(0) == '|') {
            pipeline = true;
        }
        if ((fileName = argv[1].toString()).length() == 0) {
            throw new TclException(interp, "couldn't open \"\": no such file or directory");
        }
        if (!pipeline) {
            try {
                if (fileName.startsWith("resource:/")) {
                    ResourceChannel resource = new ResourceChannel();
                    resource.open(interp, fileName.substring(9), modeFlags);
                    TclIO.registerChannel(interp, resource);
                    if (isBinaryEncoding) {
                        resource.setEncoding(null);
                    }
                    interp.setResult(resource.getChanName());
                }
                FileChannel file = new FileChannel();
                file.open(interp, fileName, modeFlags);
                TclIO.registerChannel(interp, file);
                if (isBinaryEncoding) {
                    file.setEncoding(null);
                }
                interp.setResult(file.getChanName());
            }
            catch (IOException iOException) {
                throw new TclException(interp, "cannot open file: " + fileName);
            }
        } else {
            if ((modeFlags & 2) == 2) {
                modeFlags = 2;
            }
            if ((modeFlags & 1) == 1) {
                modeFlags = 1;
            }
            if ((modeFlags & 4) == 4) {
                modeFlags = 4;
            }
            PipelineChannel pipelineChannel = new PipelineChannel();
            try {
                pipelineChannel.open(interp, fileName, modeFlags);
            }
            catch (IOException e) {
                throw new TclException(interp, "cannot open pipeline: " + e.getMessage());
            }
            TclIO.registerChannel(interp, pipelineChannel);
            if (isBinaryEncoding) {
                pipelineChannel.setEncoding(null);
            }
            interp.setResult(pipelineChannel.getChanName());
        }
    }
}

