/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.File;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.channel.Channel;
import tcl.lang.channel.PipelineChannel;

public class PidCmd
implements Command {
    public static int getPid() {
        try {
            return Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length == 1) {
            interp.setResult(PidCmd.getPid());
        } else if (objv.length == 2) {
            Channel channel = TclIO.getChannel(interp, objv[1].toString());
            if (channel == null) {
                throw new TclException(interp, "can not find channel named \"" + objv[1].toString() + "\"");
            }
            if (channel instanceof PipelineChannel) {
                int[] pids = ((PipelineChannel)channel).getPipeline().getProcessIdentifiers();
                TclObject rv = TclList.newInstance();
                int[] nArray = pids;
                int n = pids.length;
                int n2 = 0;
                while (n2 < n) {
                    int pid = nArray[n2];
                    TclList.append(interp, rv, TclInteger.newInstance(pid));
                    ++n2;
                }
                interp.setResult(rv);
            } else {
                interp.setResult("");
            }
        } else {
            throw new TclException(interp, "wrong # args: should be \"pid ?channelId?\"");
        }
    }
}

