/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.WrappedCommand;

public class ProcCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        WrappedCommand wcmd;
        if (objv.length != 4) {
            throw new TclNumArgsException(interp, 1, objv, "name args body");
        }
        String fullName = objv[1].toString();
        FindCommandNamespaceResult result = ProcCmd.FindCommandNamespace(interp, fullName);
        Procedure proc = new Procedure(interp, result.ns, result.cmdName, objv[2], objv[3], interp.getScriptFile(), interp.getArgLineNumber(3));
        interp.createCommand(result.cmdFullName, proc);
        proc.wcmd = wcmd = Namespace.findCommand(interp, result.cmdFullName, result.ns, 2);
    }

    public static FindCommandNamespaceResult FindCommandNamespace(Interp interp, String fullName) throws TclException {
        Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, fullName, null, 0, gnfqnr);
        Namespace ns = gnfqnr.ns;
        Namespace cfr_ignored_0 = gnfqnr.altNs;
        Namespace cfr_ignored_1 = gnfqnr.actualCxt;
        String procName = gnfqnr.simpleName;
        if (ns == null) {
            throw new TclException(interp, "can't create procedure \"" + fullName + "\": unknown namespace");
        }
        if (procName == null) {
            throw new TclException(interp, "can't create procedure \"" + fullName + "\": bad procedure name");
        }
        if (ns != Namespace.getGlobalNamespace(interp) && procName != null && procName.length() > 0 && procName.charAt(0) == ':') {
            throw new TclException(interp, "can't create procedure \"" + procName + "\" in non-global namespace with name starting with \":\"");
        }
        StringBuffer ds = new StringBuffer();
        if (ns != Namespace.getGlobalNamespace(interp)) {
            ds.append(ns.fullName);
            ds.append("::");
        }
        ds.append(procName);
        FindCommandNamespaceResult result = new FindCommandNamespaceResult();
        result.fullName = fullName;
        result.cmdName = procName;
        result.cmdFullName = ds.toString();
        result.ns = ns;
        return result;
    }

    public static class FindCommandNamespaceResult {
        String fullName;
        public String cmdName;
        public String cmdFullName;
        public Namespace ns;
    }
}

