/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public class ReadCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        int i = 1;
        int toRead = 0;
        boolean readAll = true;
        boolean noNewline = false;
        if (argv.length != 2 && argv.length != 3) {
            this.errorWrongNumArgs(interp, argv[0].toString());
        }
        if (argv[i].toString().equals("-nonewline")) {
            noNewline = true;
            ++i;
        }
        if (i == argv.length) {
            this.errorWrongNumArgs(interp, argv[0].toString());
        }
        if ((chan = TclIO.getChannel(interp, argv[i].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[i].toString() + "\"");
        }
        if (++i == argv.length) {
            readAll = true;
        } else {
            readAll = false;
            if (Character.isDigit(argv[i].toString().charAt(0))) {
                toRead = TclInteger.getInt(interp, argv[i]);
            } else {
                throw new TclException(interp, "bad argument \"" + argv[i] + "\": should be \"nonewline\"");
            }
        }
        try {
            TclObject result = chan.getEncoding() == null && !noNewline ? TclByteArray.newInstance() : TclString.newInstance(new StringBuffer(64));
            if (readAll) {
                chan.read(interp, result, 1, 0);
                if (noNewline && chan.eof()) {
                    String inStr = result.toString();
                    if (inStr.endsWith("\n")) {
                        interp.setResult(inStr.substring(0, inStr.length() - 1));
                    } else {
                        interp.setResult(result);
                    }
                } else {
                    interp.setResult(result);
                }
            } else {
                chan.read(interp, result, 3, toRead);
                interp.setResult(result);
            }
        }
        catch (IOException iOException) {
            throw new TclRuntimeError("ReadCmd.cmdProc() Error: IOException when reading " + chan.getChanName());
        }
    }

    private void errorWrongNumArgs(Interp interp, String cmd) throws TclException {
        throw new TclException(interp, "wrong # args: should be \"read channelId ?numChars?\" or \"read ?-nonewline? channelId\"");
    }
}

