/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.regex.PatternSyntaxException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Regex;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.cmd.RegsubCmd;

public class RegexpCmd
implements Command {
    private static final String[] validOpts = new String[]{"-all", "-about", "-indices", "-inline", "-expanded", "-line", "-linestop", "-lineanchor", "-nocase", "-start", "--"};
    private static final String[] validOptsWithXFlags = new String[]{"-all", "-about", "-indices", "-inline", "-expanded", "-line", "-linestop", "-lineanchor", "-nocase", "-start", "--", "-xflags"};
    private static final int OPT_ALL = 0;
    private static final int OPT_ABOUT = 1;
    private static final int OPT_INDICES = 2;
    private static final int OPT_INLINE = 3;
    private static final int OPT_EXPANDED = 4;
    private static final int OPT_LINE = 5;
    private static final int OPT_LINESTOP = 6;
    private static final int OPT_LINEANCHOR = 7;
    private static final int OPT_NOCASE = 8;
    private static final int OPT_START = 9;
    private static final int OPT_LAST = 10;
    private static final int OPT_XFLAGS = 11;
    private boolean allowXFlags = false;

    public static void init(Interp interp) {
        interp.createCommand("regexp", new RegexpCmd());
        interp.createCommand("regsub", new RegsubCmd());
    }

    public void setAllowXFlags(boolean allow) {
        this.allowXFlags = allow;
    }

    protected TclObject getAboutCompileError(Interp interp) throws TclException {
        TclObject props = TclList.newInstance();
        TclList.append(interp, props, TclString.newInstance("0"));
        TclList.append(interp, props, TclString.newInstance("COMPILE_ERROR"));
        return props;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int endMatch;
        boolean indices = false;
        boolean doinline = false;
        boolean about = false;
        boolean last = false;
        int all = 0;
        int offset = 0;
        int objc = 0;
        String xflags = null;
        int flags = 0;
        int i = 1;
        while (i < objv.length) {
            TclObject obj;
            if (last || (obj = objv[i]).toString().length() == 0 || obj.toString().charAt(0) != '-') break;
            int index = TclIndex.get(interp, obj, this.allowXFlags ? validOptsWithXFlags : validOpts, "switch", 0);
            switch (index) {
                case 1: {
                    about = true;
                    break;
                }
                case 4: {
                    flags |= 0x20;
                    break;
                }
                case 2: {
                    indices = true;
                    break;
                }
                case 6: {
                    flags |= 0x40;
                    break;
                }
                case 7: {
                    flags |= 0x80;
                    break;
                }
                case 5: {
                    flags |= 0x40;
                    flags |= 0x80;
                    break;
                }
                case 8: {
                    flags |= 8;
                    break;
                }
                case 0: {
                    all = 1;
                    break;
                }
                case 3: {
                    doinline = true;
                    break;
                }
                case 9: {
                    if (++i >= objv.length || (offset = TclInteger.getInt(interp, objv[i])) >= 0) break;
                    offset = 0;
                    break;
                }
                case 10: {
                    last = true;
                    break;
                }
                case 11: {
                    if (++i >= objv.length) break;
                    xflags = objv[i].toString();
                    last = true;
                }
            }
            ++i;
        }
        if (objv.length - i < 2 - (about ? 1 : 0)) {
            throw new TclNumArgsException(interp, 1, objv, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        if (doinline && objv.length - i - 2 != 0) {
            throw new TclException(interp, "regexp match variables not allowed when using -inline");
        }
        String exp = objv[i++].toString();
        String string = about ? "" : objv[i++].toString();
        Regex reg = null;
        TclInteger.newInstance(0L);
        try {
            reg = xflags == null ? new Regex(exp, string, offset, flags) : new Regex(exp, string, offset, flags, xflags);
        }
        catch (PatternSyntaxException ex) {
            interp.setErrorCode(TclString.newInstance("REGEXP COMPILE_ERROR {" + Regex.getPatternSyntaxMessage(ex) + "}"));
            throw new TclException(interp, Regex.getPatternSyntaxMessage(ex));
        }
        catch (Exception e) {
            interp.setErrorCode(TclString.newInstance("REGEXP COMPILE_ERROR {" + e.getMessage() + "}"));
            throw new TclException(interp, e.getMessage());
        }
        if (about) {
            interp.setResult(reg.getInfo(interp));
            return;
        }
        do {
            boolean matched;
            if (!(matched = reg.match())) {
                if (all > true) break;
                if (doinline) {
                    interp.resetResult();
                } else {
                    interp.setResult(0L);
                }
                return;
            }
            int groupCount = reg.groupCount();
            int group = 0;
            objc = doinline ? groupCount + 1 : objv.length - i;
            int j = 0;
            while (j < objc) {
                TclObject obj;
                if (indices) {
                    if (group <= groupCount) {
                        start = reg.start(group);
                        end = reg.end(group);
                        ++group;
                        if (end >= reg.getOffset()) {
                            --end;
                        }
                    } else {
                        start = -1;
                        end = -1;
                    }
                    obj = TclList.newInstance();
                    TclList.append(interp, obj, TclInteger.newInstance(start));
                    TclList.append(interp, obj, TclInteger.newInstance(end));
                } else if (group <= groupCount) {
                    start = reg.start(group);
                    if (start == -1) {
                        obj = TclList.newInstance();
                    } else {
                        end = reg.end(group);
                        String substr = string.substring(start, end);
                        obj = TclString.newInstance(substr);
                    }
                    ++group;
                } else {
                    obj = TclList.newInstance();
                }
                if (doinline) {
                    interp.appendElement(obj.toString());
                } else {
                    String varName = objv[i + j].toString();
                    try {
                        interp.setVar(varName, obj, 0);
                    }
                    catch (TclException tclException) {
                        throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
                    }
                }
                ++j;
            }
            if (all == 0) break;
            ++all;
            endMatch = reg.end();
            if (reg.start() != reg.end()) continue;
            ++endMatch;
        } while (endMatch < string.length());
        if (!doinline) {
            interp.setResult(all != 0 ? all - 1 : 1);
        }
    }
}

