/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.regex.PatternSyntaxException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Regex;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class RegsubCmd
implements Command {
    private static final String[] validOpts = new String[]{"-all", "-nocase", "-expanded", "-line", "-linestop", "-lineanchor", "-start", "--"};
    private static final int OPT_ALL = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_EXPANDED = 2;
    private static final int OPT_LINE = 3;
    private static final int OPT_LINESTOP = 4;
    private static final int OPT_LINEANCHOR = 5;
    private static final int OPT_START = 6;
    private static final int OPT_LAST = 7;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        boolean all = false;
        boolean last = false;
        int offset = 0;
        int flags = 0;
        int idx = 1;
        while (idx < objv.length) {
            TclObject obj;
            if (last || (obj = objv[idx]).toString().length() == 0 || obj.toString().charAt(0) != '-') break;
            int index = TclIndex.get(interp, obj, validOpts, "switch", 0);
            switch (index) {
                case 0: {
                    all = true;
                    break;
                }
                case 2: {
                    flags |= 0x20;
                    break;
                }
                case 4: {
                    flags |= 0x40;
                    break;
                }
                case 5: {
                    flags |= 0x80;
                    break;
                }
                case 3: {
                    flags |= 0x80;
                    flags |= 0x40;
                    break;
                }
                case 1: {
                    flags |= 8;
                    break;
                }
                case 6: {
                    if (++idx == objv.length || (offset = TclInteger.getInt(interp, objv[idx])) >= 0) break;
                    offset = 0;
                    break;
                }
                case 7: {
                    last = true;
                }
            }
            ++idx;
        }
        if (objv.length - idx < 3 || objv.length - idx > 4) {
            throw new TclNumArgsException(interp, 1, objv, "?switches? exp string subSpec ?varName?");
        }
        String exp = objv[idx++].toString();
        String string = objv[idx++].toString();
        String subSpec = objv[idx++].toString();
        String varName = null;
        if (objv.length - idx > 0) {
            varName = objv[idx++].toString();
        }
        Regex reg = null;
        try {
            reg = new Regex(exp, string, offset, flags);
        }
        catch (PatternSyntaxException ex) {
            interp.setErrorCode(TclString.newInstance("REGEXP COMPILE_ERROR {" + Regex.getPatternSyntaxMessage(ex) + "}"));
            throw new TclException(interp, Regex.getPatternSyntaxMessage(ex));
        }
        catch (Exception e) {
            interp.setErrorCode(TclString.newInstance("REGEXP COMPILE_ERROR {" + e.getMessage() + "}"));
            throw new TclException(interp, e.getMessage());
        }
        String result = reg.replace(subSpec, all);
        int matchCount = reg.getCount();
        if (all && exp.length() == 0 && string.length() == 0) {
            result = "";
            matchCount = 0;
        }
        try {
            if (varName != null) {
                interp.setResult(matchCount);
                interp.setVar(varName, result, 0);
            } else {
                interp.setResult(result);
            }
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }
}

