/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

public class ScanCmd
implements Command {
    private final int SCAN_NOSKIP = 1;
    private final int SCAN_SUPPRESS = 2;
    private final int SCAN_UNSIGNED = 4;
    private final int SCAN_WIDTH = 8;
    private final int SCAN_LONGER = 1024;
    private final int SCAN_BIG = 2048;

    /*
     * Unable to fully structure code
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        numVars = -1;
        totalVars = -1;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "string format ?varName varName ...?");
        }
        format = objv[2].toString();
        numVars = objv.length - 3;
        totalVars = this.validateFormat(interp, format, numVars);
        objs = new TclObject[totalVars];
        i = 0;
        while (i < totalVars) {
            objs[i] = null;
            ++i;
        }
        string = objv[1].toString();
        objIndex = 0;
        nconversions = 0;
        formatIndex = 0;
        stringIndex = 0;
        underflow = false;
        block27: while (formatIndex < format.length()) {
            ch = format.charAt(formatIndex++);
            flags = 0;
            if (Character.isWhitespace(ch)) {
                while (stringIndex < string.length() && Character.isWhitespace(string.charAt(stringIndex))) {
                    ++stringIndex;
                }
                if (stringIndex != string.length()) continue;
                break;
            }
            isLiteral = ch == '%' ? (ch = format.charAt(formatIndex++)) == '%' : true;
            if (isLiteral) {
                if (stringIndex == string.length()) {
                    underflow = true;
                    break;
                }
                if (ch == (sch = string.charAt(stringIndex++))) continue;
                break;
            }
            if (ch == '*') {
                flags |= 2;
                ch = format.charAt(formatIndex++);
            } else if (ch < '\u0080' && Character.isDigit(ch)) {
                Util.strtoul(format, formatIndex - 1, 10, interp.strtoulResult);
                value = interp.strtoulResult.value;
                if (format.charAt(interp.strtoulResult.index) == '$') {
                    formatIndex = interp.strtoulResult.index + 1;
                    ch = format.charAt(formatIndex++);
                    objIndex = (int)(value - 1L);
                }
            }
            if (ch < '\u0080' && Character.isDigit(ch)) {
                Util.strtoul(format, formatIndex - 1, 10, interp.strtoulResult);
                width = (int)interp.strtoulResult.value;
                formatIndex = interp.strtoulResult.index;
                ch = format.charAt(formatIndex++);
            } else {
                width = 0;
            }
            switch (ch) {
                case 'L': 
                case 'l': {
                    flags |= 1024;
                }
                case 'h': {
                    ch = format.charAt(formatIndex++);
                }
            }
            op = 32;
            radix = 0;
            switch (ch) {
                case 'n': {
                    if ((flags & 2) == 0) {
                        objPtr = TclInteger.newInstance(stringIndex);
                        objs[objIndex++] = objPtr;
                    }
                    ++nconversions;
                    break;
                }
                case 'd': {
                    op = 105;
                    radix = 10;
                    ** GOTO lbl106
                }
                case 'i': {
                    op = 105;
                    radix = 0;
                    ** GOTO lbl106
                }
                case 'o': {
                    op = 105;
                    radix = 8;
                    ** GOTO lbl106
                }
                case 'x': {
                    op = 105;
                    radix = 16;
                    ** GOTO lbl106
                }
                case 'b': {
                    op = 105;
                    radix = 2;
                    ** GOTO lbl106
                }
                case 'u': {
                    op = 105;
                    radix = 10;
                    flags |= 4;
                    ** GOTO lbl106
                }
                case 'e': 
                case 'f': 
                case 'g': {
                    op = 102;
                    ** GOTO lbl106
                }
                case 's': {
                    op = 115;
                    ** GOTO lbl106
                }
                case 'c': {
                    op = 99;
                    flags |= 1;
                    ** GOTO lbl106
                }
                case '[': {
                    op = 91;
                    flags |= 1;
                }
lbl106:
                // 11 sources

                default: {
                    if (stringIndex >= string.length()) {
                        underflow = true;
                        break block27;
                    }
                    if ((flags & 1) == 0) {
                        while (stringIndex < string.length()) {
                            if (!Character.isWhitespace(string.charAt(stringIndex))) break;
                            ++stringIndex;
                        }
                        if (stringIndex == string.length()) {
                            underflow = true;
                            break block27;
                        }
                    }
                    switch (op) {
                        case 115: {
                            if (width == 0) {
                                width = 0x7FFFFFFF;
                            }
                            end = stringIndex;
                            while (end < string.length()) {
                                sch = string.charAt(end);
                                if (Character.isWhitespace(sch)) break;
                                ++end;
                                if (--width == 0) break;
                            }
                            if ((flags & 2) == 0) {
                                objPtr = TclString.newInstance(string.substring(stringIndex, end));
                                objs[objIndex++] = objPtr;
                            }
                            stringIndex = end;
                            ** GOTO lbl193
                        }
                        case 91: {
                            cset = new CharSet(format, formatIndex);
                            formatIndex = cset.getEndOfFormat();
                            if (width == 0) {
                                width = 0x7FFFFFFF;
                            }
                            end = stringIndex;
                            while (end < string.length()) {
                                sch = string.charAt(end);
                                if (!cset.charInSet(sch)) break;
                                ++end;
                                if (--width == 0) break;
                            }
                            if (stringIndex == end) break block27;
                            if ((flags & 2) == 0) {
                                objPtr = TclString.newInstance(string.substring(stringIndex, end));
                                objs[objIndex++] = objPtr;
                            }
                            stringIndex = end;
                            ** GOTO lbl193
                        }
                        case 99: {
                            sch = string.charAt(stringIndex++);
                            if ((flags & 2) != 0) ** GOTO lbl193
                            objPtr = TclInteger.newInstance(sch);
                            objs[objIndex++] = objPtr;
                            ** GOTO lbl193
                        }
                        case 105: {
                            if (width == 0) {
                                Util.strtoul(string, stringIndex, radix, interp.strtoulResult);
                            } else {
                                if (stringIndex + width > string.length()) {
                                    underflow = true;
                                    break block27;
                                }
                                truncString = string.substring(0, stringIndex + width);
                                Util.strtoul(truncString, stringIndex, radix, interp.strtoulResult);
                            }
                            if (interp.strtoulResult.errno == -1) ** GOTO lbl173
                            v = interp.strtoulResult.errno == -2 ? -1L : interp.strtoulResult.value;
                            stringIndex = interp.strtoulResult.index;
                            if ((flags & 2) == 0) {
                                objs[objIndex++] = TclInteger.newInstance(v);
                            }
                            ** GOTO lbl193
lbl173:
                            // 1 sources

                            if (width != 1 && string.length() != 1) break block27;
                            underflow = string.charAt(stringIndex) == '-' || string.charAt(stringIndex) == '+';
                            break block27;
                        }
                        case 102: {
                            if (width == 0) {
                                Util.strtod(string, stringIndex, -1, interp.strtodResult);
                            } else {
                                if (stringIndex + width > string.length()) {
                                    underflow = true;
                                    break block27;
                                }
                                truncString = string.substring(0, stringIndex + width);
                                Util.strtod(truncString, stringIndex, -1, interp.strtodResult);
                            }
                            if (interp.strtodResult.errno == 0) {
                                stringIndex = interp.strtodResult.index;
                                if ((flags & 2) == 0) {
                                    objs[objIndex++] = TclDouble.newInstance(interp.strtodResult.value);
                                }
                            } else {
                                if (width != 1 && string.length() != 1) break block27;
                                underflow = string.charAt(stringIndex) == '-' || string.charAt(stringIndex) == '+';
                                break block27;
                            }
                        }
lbl193:
                        // 7 sources

                        default: {
                            ++nconversions;
                        }
                    }
                }
            }
        }
        result = 0;
        if (numVars > 0) {
            varErrors = null;
            i = 0;
            while (i < totalVars) {
                if (objs[i] != null) {
                    ++result;
                    try {
                        interp.setVar(objv[i + 3].toString(), objs[i], 0);
                    }
                    catch (TclException v0) {
                        if (varErrors == null) {
                            varErrors = new StringBuffer();
                        }
                        varErrors.append("couldn't set variable \"").append(objv[i + 3].toString()).append('\"');
                    }
                }
                ++i;
            }
            if (varErrors != null) {
                throw new TclException(interp, varErrors.toString());
            }
        } else {
            objPtr = TclList.newInstance();
            i = 0;
            while (i < totalVars) {
                if (objs[i] != null) {
                    TclList.append(interp, objPtr, objs[i]);
                } else {
                    TclList.append(interp, objPtr, TclString.newInstance(""));
                }
                ++i;
            }
            interp.setResult(objPtr);
        }
        if (underflow && nconversions == 0) {
            if (numVars > 0) {
                interp.setResult(-1L);
            } else {
                interp.setResult("");
            }
        } else if (numVars > 0) {
            interp.setResult(result);
        }
    }

    private int validateFormat(Interp interp, String format, int numVars) throws TclException {
        boolean gotXpg = false;
        boolean gotSequential = false;
        int xpgSize = 0;
        int objIndex = 0;
        int flags = 0;
        int[] nassign = new int[numVars == 0 ? 1 : numVars];
        int i = 0;
        while (i < nassign.length) {
            nassign[i] = 0;
            ++i;
        }
        int formatIndex = 0;
        while (formatIndex < format.length()) {
            int value;
            StrtoulResult result;
            char ch = format.charAt(formatIndex++);
            flags = 0;
            if (ch != '%' || (ch = format.charAt(formatIndex++)) == '%') continue;
            if (ch == '*') {
                flags |= 2;
                ch = format.charAt(formatIndex++);
            } else if (ch < '\u0080' && Character.isDigit(ch)) {
                result = new StrtoulResult();
                Util.strtoul(format, formatIndex - 1, 10, result);
                int endIndex = result.index;
                if (endIndex >= format.length()) {
                    throw new TclException(interp, "bad scan conversion character \"\"");
                }
                if (format.charAt(endIndex) != '$') {
                    gotSequential = true;
                    if (gotXpg) {
                        ScanCmd.errorBadField(interp, '$');
                    }
                } else {
                    formatIndex = endIndex + 1;
                    ch = format.charAt(formatIndex++);
                    gotXpg = true;
                    if (gotSequential) {
                        ScanCmd.errorBadField(interp, '$');
                    }
                    if ((objIndex = (value = (int)result.value) - 1) < 0 || numVars != 0 && objIndex >= numVars) {
                        ScanCmd.errorDiffVars(interp, gotXpg);
                    } else if (numVars == 0) {
                        xpgSize = xpgSize > (int)result.value ? xpgSize : (int)result.value;
                    }
                }
            } else {
                gotSequential = true;
                if (gotXpg) {
                    ScanCmd.errorCannotMix(interp, '$');
                }
            }
            if (ch < '\u0080' && Character.isDigit(ch)) {
                result = new StrtoulResult();
                Util.strtoul(format, formatIndex - 1, 10, result);
                value = result.errno != 0 ? 0 : (int)result.value;
                formatIndex = result.index;
                flags |= 8;
                ch = format.charAt(formatIndex++);
            }
            switch (ch) {
                case 'L': 
                case 'l': {
                    flags |= 0x400;
                }
                case 'h': {
                    ch = format.charAt(formatIndex++);
                }
            }
            if ((flags & 2) == 0 && numVars > 0 && objIndex >= numVars) {
                ScanCmd.errorDiffVars(interp, gotXpg);
            }
            switch (ch) {
                case 'c': {
                    if ((flags & 8) != 0) {
                        ScanCmd.errorCharFieldWidth(interp);
                    }
                }
                case 'n': 
                case 's': {
                    if ((flags & 0xC00) == 0) break;
                    ScanCmd.errorLonger(interp, ch);
                }
                case 'b': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'i': 
                case 'o': 
                case 'x': {
                    break;
                }
                case 'u': {
                    if ((flags & 0x800) == 0) break;
                    throw new TclException(interp, "unsigned bignum scans are invalid");
                }
                case '[': {
                    if ((flags & 0xC00) != 0) {
                        ScanCmd.errorLonger(interp, ch);
                    }
                    if (formatIndex >= format.length()) {
                        ScanCmd.errorBadSet(interp);
                    }
                    if ((ch = format.charAt(formatIndex++)) == '^') {
                        if (formatIndex >= format.length()) {
                            ScanCmd.errorBadSet(interp);
                        }
                        ch = format.charAt(formatIndex++);
                    }
                    if (ch == ']') {
                        if (formatIndex >= format.length()) {
                            ScanCmd.errorBadSet(interp);
                        }
                        ch = format.charAt(formatIndex++);
                    }
                    while (ch != ']') {
                        if (formatIndex >= format.length()) {
                            ScanCmd.errorBadSet(interp);
                        }
                        ch = format.charAt(formatIndex++);
                    }
                    break;
                }
                default: {
                    ScanCmd.errorBadConvChar(interp, ch);
                }
            }
            if ((flags & 2) != 0) continue;
            if (objIndex >= nassign.length) {
                int nspace = xpgSize > 0 ? xpgSize : nassign.length + 16;
                int[] newNassign = new int[nspace];
                System.arraycopy(nassign, 0, newNassign, 0, nassign.length);
                int i2 = nassign.length;
                while (i2 < newNassign.length) {
                    newNassign[i2] = 0;
                    ++i2;
                }
                nassign = newNassign;
            }
            int n = objIndex++;
            nassign[n] = nassign[n] + 1;
        }
        if (numVars == 0) {
            numVars = xpgSize != 0 ? xpgSize : objIndex;
        }
        int i3 = 0;
        while (i3 < numVars) {
            if (nassign[i3] > 1) {
                ScanCmd.errorMultipleAssignments(interp);
            } else if (xpgSize == 0 && nassign[i3] == 0) {
                ScanCmd.errorNotAssigned(interp);
            }
            ++i3;
        }
        return numVars;
    }

    private static final void errorDiffVars(Interp interp, boolean gotXpg) throws TclException {
        if (gotXpg) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
        throw new TclException(interp, "different numbers of variable names and field specifiers");
    }

    private static final void errorCannotMix(Interp interp, char fieldSpecifier) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n" + fieldSpecifier + "\" conversion specifiers");
    }

    private static final void errorBadField(Interp interp, char fieldSpecifier) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n" + fieldSpecifier + "\" conversion specifiers");
    }

    private static final void errorCharFieldWidth(Interp interp) throws TclException {
        throw new TclException(interp, "field width may not be specified in %c conversion");
    }

    private static final void errorLonger(Interp interp, char ch) throws TclException {
        throw new TclException(interp, "'l' modifier may not be specified in " + ch + " conversion");
    }

    private static final void errorBadSet(Interp interp) throws TclException {
        throw new TclException(interp, "unmatched [ in format string");
    }

    private static final void errorBadConvChar(Interp interp, char ch) throws TclException {
        throw new TclException(interp, "bad scan conversion character \"" + ch + "\"");
    }

    private static final void errorMultipleAssignments(Interp interp) throws TclException {
        throw new TclException(interp, "variable is assigned by multiple \"%n$\" conversion specifiers");
    }

    private static final void errorNotAssigned(Interp interp) throws TclException {
        throw new TclException(interp, "variable is not assigned by any conversion specifiers");
    }

    private static class CharSet {
        boolean exclude = false;
        String chars = null;
        Range[] ranges = null;
        int endOfFormat;

        CharSet(String format, int formatIndex) {
            int offset = 0;
            int endIndex = 0;
            char ch = format.charAt(formatIndex);
            offset = 1;
            if (ch == '^') {
                this.exclude = true;
                ch = format.charAt(formatIndex += offset);
                offset = 1;
            }
            endIndex = formatIndex + offset;
            if (ch == ']') {
                ch = format.charAt(endIndex++);
            }
            int nranges = 0;
            while (ch != ']' && endIndex < format.length()) {
                if (ch == '-') {
                    ++nranges;
                }
                ch = format.charAt(endIndex++);
            }
            StringBuffer charsbuf = new StringBuffer();
            this.ranges = nranges > 0 ? new Range[nranges] : null;
            nranges = 0;
            char start = ch = format.charAt(formatIndex++);
            if (ch == ']' || ch == '-') {
                charsbuf.append(ch);
                ch = format.charAt(formatIndex++);
            }
            while (ch != ']') {
                char nextChar;
                char c = nextChar = formatIndex < format.length() ? format.charAt(formatIndex) : (char)'\u0000';
                if (nextChar == '-') {
                    start = ch;
                } else if (ch == '-') {
                    if (nextChar == ']') {
                        charsbuf.append(start);
                        charsbuf.append(ch);
                    } else {
                        ch = format.charAt(formatIndex++);
                        this.ranges[nranges] = new Range(start, ch);
                        ++nranges;
                    }
                } else {
                    charsbuf.append(ch);
                }
                ch = format.charAt(formatIndex++);
            }
            this.endOfFormat = formatIndex;
            this.chars = charsbuf.toString();
        }

        int getEndOfFormat() {
            return this.endOfFormat;
        }

        private boolean charInSet(char ch) {
            boolean match = false;
            if (this.chars.indexOf(ch) >= 0) {
                match = true;
            } else if (this.ranges != null) {
                int i = 0;
                while (i < this.ranges.length) {
                    if (this.ranges[i] != null && this.ranges[i].isInRange(ch)) {
                        match = true;
                        break;
                    }
                    ++i;
                }
            }
            return this.exclude ? !match : match;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            if (this.exclude) {
                sb.append('^');
            }
            if (this.chars != null) {
                sb.append(this.chars);
            }
            if (this.ranges != null) {
                Range[] rangeArray = this.ranges;
                int n = this.ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    Range r = rangeArray[n2];
                    if (r != null) {
                        sb.append(r.start).append('-').append(r.end);
                    }
                    ++n2;
                }
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static class Range {
        char start;
        char end;

        Range(char a, char b) {
            if (a < b) {
                this.start = a;
                this.end = b;
            } else {
                this.start = b;
                this.end = a;
            }
        }

        final boolean isInRange(char c) {
            return c >= this.start && c <= this.end;
        }
    }
}

