/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public class SeekCmd
implements Command {
    private static final String[] validOrigins = new String[]{"start", "current", "end"};
    static final int OPT_START = 0;
    static final int OPT_CURRENT = 1;
    static final int OPT_END = 2;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 1, argv, "channelId offset ?origin?");
        }
        int mode = 1;
        if (argv.length == 4) {
            int index = TclIndex.get(interp, argv[3], validOrigins, "origin", 0);
            switch (index) {
                case 0: {
                    mode = 1;
                    break;
                }
                case 1: {
                    mode = 2;
                    break;
                }
                case 2: {
                    mode = 3;
                }
            }
        }
        if ((chan = TclIO.getChannel(interp, argv[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        long offset = TclInteger.getLong(interp, argv[2]);
        try {
            chan.seek(interp, offset, mode);
        }
        catch (IOException e) {
            throw new TclRuntimeError("SeekCmd.cmdProc() Error: IOException when seeking " + chan.getChanName() + ":" + e.toString());
        }
    }
}

