/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.channel.ServerSocketChannel;
import tcl.lang.channel.SocketChannel;

public class SocketCmd
implements Command {
    private static final String[] validCmds = new String[]{"-async", "-myaddr", "-myport", "-server"};
    static final int OPT_ASYNC = 0;
    static final int OPT_MYADDR = 1;
    static final int OPT_MYPORT = 2;
    static final int OPT_SERVER = 3;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean server = false;
        boolean async = false;
        String myaddr = "";
        String script = "";
        String host = "";
        int myport = 0;
        int port = 0;
        int i = 1;
        while (i < argv.length) {
            if (argv[i].toString().length() <= 0 || argv[i].toString().charAt(0) != '-') break;
            int index = TclIndex.get(interp, argv[i], validCmds, "option", 0);
            switch (index) {
                case 0: {
                    if (server) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    async = true;
                    break;
                }
                case 1: {
                    if (++i >= argv.length) {
                        throw new TclException(interp, "no argument given for -myaddr option");
                    }
                    myaddr = argv[i].toString();
                    break;
                }
                case 2: {
                    if (++i >= argv.length) {
                        throw new TclException(interp, "no argument given for -myport option");
                    }
                    myport = SocketCmd.getPort(interp, argv[i]);
                    break;
                }
                case 3: {
                    if (async) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    server = true;
                    if (++i >= argv.length) {
                        throw new TclException(interp, "no argument given for -server option");
                    }
                    script = argv[i].toString();
                    break;
                }
                default: {
                    throw new TclException(interp, "bad option \"" + argv[i] + "\", must be -async, -myaddr, -myport," + " or -server");
                }
            }
            ++i;
        }
        if (server) {
            host = myaddr;
            if (myport != 0) {
                throw new TclException(interp, "Option -myport is not valid for servers");
            }
        } else if (i + 1 < argv.length) {
            host = argv[i].toString();
            ++i;
        } else {
            SocketCmd.errorWrongNumArgs(interp, argv[0].toString());
        }
        if (i == argv.length - 1) {
            port = SocketCmd.getPort(interp, argv[i]);
        } else {
            SocketCmd.errorWrongNumArgs(interp, argv[0].toString());
        }
        if (server) {
            TclObject scr = TclString.newInstance(script);
            ServerSocketChannel sock = new ServerSocketChannel(interp, myaddr, port, scr);
            TclIO.registerChannel(interp, sock);
            interp.setResult(sock.getChanName());
        } else {
            try {
                SocketChannel sock = new SocketChannel(interp, 4, myaddr, myport, async, host, port);
                TclIO.registerChannel(interp, sock);
                interp.setResult(sock.getChanName());
            }
            catch (IOException e) {
                throw new TclException(interp, "couldn't open socket: " + e.getMessage().toLowerCase());
            }
        }
    }

    private static void errorWrongNumArgs(Interp interp, String cmdName) throws TclException {
        throw new TclException(interp, "wrong # args: should be either:\n" + cmdName + " ?-myaddr addr? ?-myport myport? ?-async? host port\n" + cmdName + " -server command ?-myaddr addr? port");
    }

    private static int getPort(Interp interp, TclObject tobj) throws TclException {
        long num = Util.getInt(interp, tobj.toString());
        if (num > 65535L) {
            throw new TclException(interp, "couldn't open socket: port number too high");
        }
        return (int)num;
    }
}

