/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.cmd.EncodingCmd;

public class SourceCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String fileName = null;
        boolean url = false;
        String encoding = EncodingCmd.systemTclEncoding;
        int i = 1;
        while (i < argv.length) {
            String argstr = argv[i].toString();
            if (i == argv.length - 1) {
                fileName = argstr;
            } else if (argstr.equals("-url")) {
                url = true;
            } else if (argstr.equals("-encoding")) {
                encoding = i == argv.length - 1 ? null : argv[++i].toString();
            } else {
                throw new TclException(interp, "bad option \"" + argstr + "\": must be -encoding or -url");
            }
            ++i;
        }
        if (fileName == null || encoding == null) {
            throw new TclNumArgsException(interp, 1, argv, "?-encoding name? ?-url? fileName");
        }
        String javaEncoding = EncodingCmd.getJavaName(encoding);
        if (javaEncoding == null) {
            throw new TclException(interp, "unknown encoding \"" + encoding + "\"");
        }
        try {
            if (fileName.startsWith("resource:/")) {
                interp.evalResource(fileName.substring(9), javaEncoding);
            } else if (url) {
                interp.evalURL(null, fileName, javaEncoding);
            } else {
                interp.evalFile(fileName, javaEncoding);
            }
        }
        catch (TclException e) {
            int code = e.getCompletionCode();
            if (code == 2) {
                int realCode = interp.updateReturnInfo();
                if (realCode != 0) {
                    e.setCompletionCode(realCode);
                    throw e;
                }
            }
            throw e;
        }
    }
}

