/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SplitCmd
implements Command {
    private static final char[] defSplitChars = new char[]{' ', '\n', '\t', '\r'};

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int numSplitChars;
        String splitString = null;
        if (objv.length == 2) {
            numSplitChars = defSplitChars.length;
        } else if (objv.length == 3) {
            splitString = objv[2].toString();
            numSplitChars = splitString.equals("") ? 0 : (splitString.length() == 1 ? 1 : splitString.length());
        } else {
            throw new TclNumArgsException(interp, 1, objv, "string ?splitChars?");
        }
        String string = objv[1].toString();
        int slen = string.length();
        int elemStart = 0;
        int i = 0;
        TclObject list = TclList.newInstance();
        list.preserve();
        try {
            if (numSplitChars == 0) {
                while (i < slen) {
                    TclObject tobj = interp.checkCommonCharacter(string.charAt(i));
                    if (tobj == null) {
                        tobj = TclString.newInstance(string.substring(i, i + 1));
                    }
                    TclList.append(interp, list, tobj);
                    ++i;
                }
            } else if (numSplitChars == 1) {
                char splitChar = splitString.charAt(0);
                while (i < slen) {
                    if (string.charAt(i) == splitChar) {
                        SplitCmd.appendElement(interp, list, string, elemStart, i);
                        elemStart = i + 1;
                    }
                    ++i;
                }
                if (i != 0) {
                    SplitCmd.appendElement(interp, list, string, elemStart, i);
                }
            } else {
                char[] splitChars = objv.length == 2 ? defSplitChars : splitString.toCharArray();
                while (i < slen) {
                    char c = string.charAt(i);
                    int j = 0;
                    while (j < numSplitChars) {
                        if (c == splitChars[j]) {
                            SplitCmd.appendElement(interp, list, string, elemStart, i);
                            elemStart = i + 1;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (i != 0) {
                    SplitCmd.appendElement(interp, list, string, elemStart, i);
                }
            }
            interp.setResult(list);
        }
        finally {
            list.release();
        }
    }

    static void appendElement(Interp interp, TclObject list, String string, int starti, int endi) throws TclException {
        TclObject tobj;
        switch (endi - starti) {
            case 0: {
                tobj = interp.checkCommonString(null);
                break;
            }
            case 1: {
                tobj = interp.checkCommonCharacter(string.charAt(starti));
                if (tobj != null) break;
            }
            default: {
                tobj = TclString.newInstance(string.substring(starti, endi));
            }
        }
        TclList.append(interp, list, tobj);
    }
}

