/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.BackSlashResult;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class SubstCmd
implements Command {
    private static final String[] validCmds = new String[]{"-nobackslashes", "-nocommands", "-novariables"};
    static final int OPT_NOBACKSLASHES = 0;
    static final int OPT_NOCOMMANDS = 1;
    static final int OPT_NOVARS = 2;

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int objc = argv.length - 1;
        boolean doBackslashes = true;
        boolean doCmds = true;
        boolean doVars = true;
        StringBuffer result = new StringBuffer();
        if (objc == 0) {
            throw new TclNumArgsException(interp, 1, argv, "?-nobackslashes? ?-nocommands? ?-novariables? string");
        }
        int currentObjIndex = 1;
        while (currentObjIndex < objc) {
            int opt = TclIndex.get(interp, argv[currentObjIndex], validCmds, "switch", 0);
            switch (opt) {
                case 0: {
                    doBackslashes = false;
                    break;
                }
                case 1: {
                    doCmds = false;
                    break;
                }
                case 2: {
                    doVars = false;
                    break;
                }
                default: {
                    throw new TclException(interp, "SubstCmd.cmdProc: bad option " + opt + " index to cmds");
                }
            }
            ++currentObjIndex;
        }
        String s = argv[currentObjIndex].toString();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '[' && doCmds) {
                interp.evalFlags = 1;
                try {
                    interp.eval(s.substring(i + 1, len));
                    i = SubstCmd.doCmdOrVarSub(null, s, i, interp.getResult().toString(), result, interp);
                }
                catch (TclException e) {
                    i = SubstCmd.doCmdOrVarSub(e, s, i, interp.getResult().toString(), result, interp);
                }
                continue;
            }
            if (c == '$' && doVars) {
                ParseResult vres = null;
                try {
                    try {
                        vres = Parser.parseVar(interp, s.substring(i, len));
                        result.append(vres.value.toString());
                        i += vres.nextIndex;
                    }
                    catch (TclException e) {
                        i = SubstCmd.doCmdOrVarSub(e, s, i, vres == null ? "" : vres.value.toString(), result, interp);
                        if (vres == null) continue;
                        vres.release();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (vres != null) {
                        vres.release();
                    }
                    throw throwable;
                }
                if (vres == null) continue;
                vres.release();
                continue;
            }
            if (c == '\\' && doBackslashes) {
                BackSlashResult bs = Interp.backslash(s, i, len);
                i = bs.nextIndex;
                if (bs.isWordSep) break;
                result.append(bs.c);
                continue;
            }
            result.append(c);
            ++i;
        }
        interp.setResult(result.toString());
    }

    private static int doCmdOrVarSub(TclException e, String originalString, int offset, String replacementSubstring, StringBuffer result, Interp interp) throws TclException {
        if (e != null && e.getCompletionCode() == 1) {
            throw e;
        }
        int bracketLevel = 0;
        int braceLevel = 0;
        int parenLevel = 0;
        int end = offset;
        boolean done = false;
        while (!done && end < originalString.length()) {
            switch (originalString.charAt(end)) {
                case '\\': {
                    ++end;
                    break;
                }
                case '[': {
                    if (braceLevel != 0) break;
                    ++bracketLevel;
                    break;
                }
                case ']': {
                    if (braceLevel != 0 || --bracketLevel != 0 || originalString.charAt(offset) != '[') break;
                    done = true;
                    break;
                }
                case '{': {
                    ++braceLevel;
                    break;
                }
                case '}': {
                    --braceLevel;
                    break;
                }
                case '(': {
                    if (braceLevel != 0) break;
                    ++parenLevel;
                    break;
                }
                case ')': {
                    if (braceLevel != 0 || --parenLevel != 0 || originalString.charAt(offset) != '$') break;
                    done = true;
                }
            }
            ++end;
        }
        int ccode = e == null ? 0 : e.getCompletionCode();
        int newOffset = end;
        switch (ccode) {
            case 0: {
                result.append(replacementSubstring);
                break;
            }
            case 2: {
                result.append(interp.getResult().toString());
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                newOffset = originalString.length();
            }
        }
        if (!done && end >= originalString.length()) {
            if (braceLevel > 0) {
                throw new TclException(interp, "missing close-brace");
            }
            if (bracketLevel > 0) {
                throw new TclException(interp, "missing close-bracket");
            }
            if (parenLevel > 0) {
                throw new TclException(interp, "missing close-parenthesis");
            }
        }
        int trailingIndex = offset + interp.termOffset + 1;
        if (ccode != 0 && ccode != 3 && originalString.charAt(offset) == '[' && originalString.charAt(trailingIndex - 1) == ';') {
            while (trailingIndex < end && Character.isWhitespace(originalString.charAt(trailingIndex))) {
                ++trailingIndex;
            }
            if (!Parser.isParseableScript(originalString.substring(trailingIndex, end - 1), false)) {
                result.append(originalString.substring(trailingIndex, end));
            }
        }
        return newOffset;
    }
}

