/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class SwitchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp", "--"};
    private static final int EXACT = 0;
    private static final int GLOB = 1;
    private static final int REGEXP = 2;
    private static final int LAST = 3;

    /*
     * Unable to fully structure code
     */
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        switchObjv = null;
        mode = 0;
        foundmode = false;
        i = 1;
        while (i < objv.length) {
            if (!objv[i].toString().startsWith("-")) break;
            opt = TclIndex.get(interp, objv[i], SwitchCmd.validCmds, "option", 0);
            if (opt == 3) {
                ++i;
                break;
            }
            if (opt > 3) {
                throw new TclException(interp, "SwitchCmd.cmdProc: bad option " + opt + " index to validCmds");
            }
            if (foundmode) {
                throw new TclException(interp, "bad option \"" + objv[i] + "\": " + SwitchCmd.validCmds[mode] + " option already found");
            }
            foundmode = true;
            mode = opt;
            ++i;
        }
        if (objv.length - i < 2) {
            throw new TclNumArgsException(interp, 1, objv, "?switches? string pattern body ... ?default body?");
        }
        string = objv[i].toString();
        splitObjs = false;
        if (objv.length - ++i == 1) {
            switchObjv = TclList.getElements(interp, objv[i]);
            if (switchObjv.length == 0) {
                throw new TclNumArgsException(interp, 1, objv, "?switches? string {pattern body ... ?default body?}");
            }
            pbStart = 0;
            splitObjs = true;
        } else {
            switchObjv = objv;
            pbStart = i;
        }
        if ((switchObjv.length - pbStart) % 2 != 0) {
            interp.resetResult();
            if (splitObjs) {
                off = pbStart;
                while (off < switchObjv.length) {
                    if (switchObjv[off].toString().startsWith("#")) {
                        throw new TclException(interp, "extra switch pattern with no body, this may be due to a comment incorrectly placed outside of a switch body - see the \"switch\" documentation");
                    }
                    off += 2;
                }
            }
            throw new TclException(interp, "extra switch pattern with no body");
        }
        pbOffset = SwitchCmd.getBodyOffset(interp, switchObjv, pbStart, string, mode);
        if (pbOffset != -1) {
            try {
                switchObjv[pbStart + pbOffset].fixCommandStart();
                interp.eval(switchObjv[pbStart + pbOffset], 0);
                return;
            }
            catch (TclException e) {
                pIndex = pbStart + pbOffset - 1;
                ** while (pIndex >= pbStart)
            }
lbl-1000:
            // 1 sources

            {
                if (!switchObjv[pIndex].toString().equals("-")) break;
                pIndex -= 2;
                continue;
            }
lbl54:
            // 2 sources

            if (e.getCompletionCode() == 1) {
                interp.addErrorInfo("\n    (\"" + switchObjv[pIndex] + "\" arm line " + interp.errorLine + ")");
            }
            throw e;
        }
    }

    public static int getBodyOffset(Interp interp, TclObject[] switchObjv, int pbStart, String string, int mode) throws TclException {
        int slen = switchObjv.length;
        if (switchObjv[slen - 1] != null && switchObjv[slen - 1].toString().equals("-")) {
            interp.resetResult();
            throw new TclException(interp, "no body specified for pattern \"" + switchObjv[slen - 2].toString() + "\"");
        }
        int i = pbStart;
        while (i < slen) {
            boolean matched = false;
            String pattern = switchObjv[i].toString();
            if (i == slen - 2 && pattern.equals("default")) {
                matched = true;
            } else {
                switch (mode) {
                    case 0: {
                        matched = string.equals(pattern);
                        break;
                    }
                    case 1: {
                        matched = Util.stringMatch(string, pattern);
                        break;
                    }
                    case 2: {
                        matched = Util.regExpMatch(interp, string, switchObjv[i]);
                    }
                }
            }
            if (matched) {
                int body = i + 1;
                while (true) {
                    if (body >= slen) {
                        throw new TclRuntimeError("fall-out when searching for body to match pattern");
                    }
                    if (switchObjv[body] == null || !switchObjv[body].toString().equals("-")) break;
                    body += 2;
                }
                return body - pbStart;
            }
            i += 2;
        }
        return -1;
    }
}

