/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import java.util.ArrayList;
import tcl.lang.Command;
import tcl.lang.CommandTrace;
import tcl.lang.ExecutionTrace;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TraceRecord;
import tcl.lang.Var;
import tcl.lang.cmd.VarTraceProc;

public class TraceCmd
implements Command {
    private static final String[] validCmds = new String[]{"add", "info", "remove", "variable", "vdelete", "vinfo"};
    private static final int OPT_ADD = 0;
    private static final int OPT_INFO = 1;
    private static final int OPT_REMOVE = 2;
    private static final int OPT_VARIABLE = 3;
    private static final int OPT_VDELETE = 4;
    private static final int OPT_VINFO = 5;
    private static final String[] subCmds = new String[]{"variable", "command", "execution"};
    private static final int TYPE_VARIABLE = 0;
    private static final int TYPE_COMMAND = 1;
    private static final int TYPE_EXECUTION = 2;
    private static final String[] commandOps = new String[]{"delete", "rename"};
    private static final int OP_RENAME = 1;
    private static final int OP_DELETE = 0;
    private static final String[] executionOps = new String[]{"enter", "leave", "enterstep", "leavestep"};
    private static final int OP_ENTER = 0;
    private static final int OP_LEAVE = 1;
    private static final int OP_ENTERSTEP = 2;
    private static final int OP_LEAVESTEP = 3;
    private static TclObject[] opStr = TraceCmd.initOptStr();
    private static TclObject[] opArrayStr = TraceCmd.initOptArrayStr();
    private static TclObject[] opNewStyleStr = TraceCmd.initOptNewStyleStr();
    private static TclObject[] opNewStyleArrayStr = TraceCmd.initOptNewStyleArrayStr();

    private static TclObject[] initOptStr() {
        TclObject[] strings = new TclObject[]{TclString.newInstance("error"), TclString.newInstance("r"), TclString.newInstance("w"), TclString.newInstance("rw"), TclString.newInstance("u"), TclString.newInstance("ru"), TclString.newInstance("wu"), TclString.newInstance("rwu")};
        int i = 0;
        while (i < 8) {
            strings[i].preserve();
            ++i;
        }
        return strings;
    }

    private static TclObject[] initOptArrayStr() {
        TclObject[] strings = new TclObject[]{TclString.newInstance("a"), TclString.newInstance("ra"), TclString.newInstance("wa"), TclString.newInstance("rwa"), TclString.newInstance("ua"), TclString.newInstance("rua"), TclString.newInstance("wua"), TclString.newInstance("rwua")};
        int i = 0;
        while (i < 8) {
            strings[i].preserve();
            ++i;
        }
        return strings;
    }

    private static TclObject[] initOptNewStyleStr() {
        TclObject[] strings = new TclObject[]{TclString.newInstance("error"), TclString.newInstance("read"), TclString.newInstance("write"), TclString.newInstance("read write"), TclString.newInstance("unset"), TclString.newInstance("read unset"), TclString.newInstance("write unset"), TclString.newInstance("read write unset")};
        int i = 0;
        while (i < 8) {
            strings[i].preserve();
            ++i;
        }
        return strings;
    }

    private static TclObject[] initOptNewStyleArrayStr() {
        TclObject[] strings = new TclObject[]{TclString.newInstance("array"), TclString.newInstance("array read"), TclString.newInstance("array write"), TclString.newInstance("array read write"), TclString.newInstance("array unset"), TclString.newInstance("array read unset"), TclString.newInstance("array write unset"), TclString.newInstance("array read write unset")};
        int i = 0;
        while (i < 8) {
            strings[i].preserve();
            ++i;
        }
        return strings;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, objv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: 
            case 1: 
            case 2: {
                if (objv.length < 3) {
                    throw new TclNumArgsException(interp, 2, objv, "type ?arg arg ...?");
                }
                if (opt == 1) {
                    if (objv.length != 4) {
                        throw new TclNumArgsException(interp, 3, objv, "name");
                    }
                } else if (objv.length != 6) {
                    throw new TclNumArgsException(interp, 3, objv, "name opList command");
                }
                int subOpt = TclIndex.get(interp, objv[2], subCmds, "option", 0);
                switch (subOpt) {
                    case 0: {
                        this.traceVariable(interp, opt, objv, 3);
                        break;
                    }
                    case 1: {
                        this.traceCommand(interp, opt, objv);
                        break;
                    }
                    case 2: {
                        this.traceExecution(interp, opt, objv);
                    }
                }
                break;
            }
            case 3: {
                if (objv.length != 5) {
                    throw new TclNumArgsException(interp, 1, objv, "variable name ops command");
                }
                this.traceVariable(interp, 0, objv, 2);
                break;
            }
            case 4: {
                if (objv.length != 5) {
                    throw new TclNumArgsException(interp, 1, objv, "vdelete name ops command");
                }
                this.traceVariable(interp, 2, objv, 2);
                break;
            }
            case 5: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "name");
                }
                this.traceVariable(interp, 5, objv, 2);
            }
        }
    }

    private void traceExecution(Interp interp, int opt, TclObject[] objv) throws TclException {
        String commandName;
        String string = commandName = objv.length >= 4 ? objv[3].toString() : null;
        if (opt == 1) {
            interp.setResult(interp.traceExecutionInfo(commandName));
        }
        if (opt == 0 || opt == 2) {
            TclObject[] ops = TclList.getElements(interp, objv[4]);
            if (ops.length == 0) {
                throw new TclException(interp, "bad operation list \"\": must be one or more of enter, leave, enterstep, or leavestep");
            }
            boolean enter = false;
            boolean leave = false;
            boolean enterStep = false;
            boolean leaveStep = false;
            TclObject[] tclObjectArray = ops;
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                TclObject op = tclObjectArray[n2];
                int operation = TclIndex.get(interp, op, executionOps, "operation", 1);
                switch (operation) {
                    case 0: {
                        enter = true;
                        break;
                    }
                    case 1: {
                        leave = true;
                        break;
                    }
                    case 2: {
                        enterStep = true;
                        break;
                    }
                    case 3: {
                        leaveStep = true;
                    }
                }
                ++n2;
            }
            switch (opt) {
                case 0: {
                    ExecutionTrace trace;
                    if (enter) {
                        trace = new ExecutionTrace(interp, 0, objv[5]);
                        interp.traceExecution(commandName, trace);
                    }
                    if (leave) {
                        trace = new ExecutionTrace(interp, 1, objv[5]);
                        interp.traceExecution(commandName, trace);
                    }
                    if (enterStep) {
                        trace = new ExecutionTrace(interp, 2, objv[5]);
                        interp.traceExecution(commandName, trace);
                    }
                    if (!leaveStep) break;
                    trace = new ExecutionTrace(interp, 3, objv[5]);
                    interp.traceExecution(commandName, trace);
                    break;
                }
                case 2: {
                    if (enter) {
                        interp.untraceExecution(commandName, 0, objv[5]);
                    }
                    if (leave) {
                        interp.untraceExecution(commandName, 1, objv[5]);
                    }
                    if (enterStep) {
                        interp.untraceExecution(commandName, 2, objv[5]);
                    }
                    if (!leaveStep) break;
                    interp.untraceExecution(commandName, 3, objv[5]);
                }
            }
        }
    }

    private void traceCommand(Interp interp, int opt, TclObject[] objv) throws TclException {
        String commandName;
        String string = commandName = objv.length >= 4 ? objv[3].toString() : null;
        if (opt == 1) {
            interp.setResult(interp.traceCommandInfo(commandName));
        }
        if (opt == 0 || opt == 2) {
            TclObject[] ops = TclList.getElements(interp, objv[4]);
            if (ops.length == 0) {
                throw new TclException(interp, "bad operation list \"\": must be one or more of delete or rename");
            }
            boolean rename = false;
            boolean delete = false;
            TclObject[] tclObjectArray = ops;
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                TclObject op = tclObjectArray[n2];
                int operation = TclIndex.get(interp, op, commandOps, "operation", 1);
                switch (operation) {
                    case 1: {
                        rename = true;
                        break;
                    }
                    case 0: {
                        delete = true;
                    }
                }
                ++n2;
            }
            switch (opt) {
                case 0: {
                    CommandTrace trace;
                    if (rename) {
                        trace = new CommandTrace(interp, 1, objv[5]);
                        interp.traceCommand(commandName, trace);
                    }
                    if (!delete) break;
                    trace = new CommandTrace(interp, 0, objv[5]);
                    interp.traceCommand(commandName, trace);
                    break;
                }
                case 2: {
                    if (rename) {
                        interp.untraceCommand(commandName, 1, objv[5]);
                    }
                    if (!delete) break;
                    interp.untraceCommand(commandName, 0, objv[5]);
                }
            }
        }
    }

    private void traceVariable(Interp interp, int opt, TclObject[] objv, int start) throws TclException {
        block1 : switch (opt) {
            case 0: 
            case 2: {
                int len;
                int i;
                int flags = 0;
                boolean isNewStyle = false;
                if (start == 3) {
                    isNewStyle = true;
                    TclObject[] opsArray = TclList.getElements(interp, objv[start + 1]);
                    i = 0;
                    while (i < opsArray.length) {
                        if ("read".equals(opsArray[i].toString())) {
                            flags |= 0x10;
                        } else if ("write".equals(opsArray[i].toString())) {
                            flags |= 0x20;
                        } else if ("unset".equals(opsArray[i].toString())) {
                            flags |= 0x40;
                        } else if ("array".equals(opsArray[i].toString())) {
                            flags |= 0x800;
                        } else {
                            throw new TclException(interp, "bad operation \"" + opsArray[i].toString() + "\": must be array, read, unset, or write");
                        }
                        ++i;
                    }
                    if (flags == 0) {
                        throw new TclException(interp, "bad operation list \"" + objv[start + 1] + "\": must be one or more of array, read, unset, or write");
                    }
                } else {
                    String ops = objv[3].toString();
                    len = ops.length();
                    i = 0;
                    block14: while (i < len) {
                        switch (ops.charAt(i)) {
                            case 'r': {
                                flags |= 0x10;
                                break;
                            }
                            case 'w': {
                                flags |= 0x20;
                                break;
                            }
                            case 'u': {
                                flags |= 0x40;
                                break;
                            }
                            case 'a': {
                                flags |= 0x800;
                                break;
                            }
                            default: {
                                flags = 0;
                                break block14;
                            }
                        }
                        ++i;
                    }
                    if (flags == 0) {
                        throw new TclException(interp, "bad operations \"" + objv[3] + "\": should be one or more of rwua");
                    }
                }
                if (opt == 0) {
                    VarTraceProc trace = new VarTraceProc(objv[start + 2].toString(), flags, isNewStyle);
                    Var.traceVar(interp, objv[start].toString(), null, flags, trace);
                    break;
                }
                ArrayList traces = Var.getTraces(interp, objv[start].toString(), null, 0);
                if (traces == null) break;
                len = traces.size();
                i = 0;
                while (i < len) {
                    TraceRecord rec = (TraceRecord)traces.get(i);
                    if (rec.trace instanceof VarTraceProc) {
                        VarTraceProc proc = (VarTraceProc)rec.trace;
                        if (proc.flags == flags && proc.command.toString().equals(objv[start + 2].toString())) {
                            Var.untraceVar(interp, objv[start].toString(), null, flags, proc);
                            break block1;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 5: {
                ArrayList traces = Var.getTraces(interp, objv[start].toString(), null, 0);
                if (traces == null) break;
                int len = traces.size();
                TclObject list = TclList.newInstance();
                TclObject cmd = null;
                list.preserve();
                try {
                    int i = 0;
                    while (i < len) {
                        TraceRecord rec = (TraceRecord)traces.get(i);
                        if (rec.trace instanceof VarTraceProc) {
                            VarTraceProc proc = (VarTraceProc)rec.trace;
                            int mode = proc.flags;
                            boolean hasArrayTrace = (mode & 0x800) == 2048;
                            mode &= 0x70;
                            TclObject[] modeStrs = hasArrayTrace ? (opt == 1 ? opNewStyleArrayStr : opArrayStr) : (opt == 1 ? opNewStyleStr : opStr);
                            cmd = TclList.newInstance();
                            TclList.append(interp, cmd, modeStrs[mode /= 16]);
                            TclList.append(interp, cmd, TclString.newInstance(proc.command));
                            TclList.append(interp, list, cmd);
                        }
                        ++i;
                    }
                    interp.setResult(list);
                }
                finally {
                    list.release();
                }
            }
        }
    }
}

