/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.VarTrace;

class VarTraceProc
implements VarTrace {
    String command;
    int flags;
    boolean newStyle;

    VarTraceProc(String cmd, int newFlags, boolean isNewStyle) {
        this.command = cmd;
        this.flags = newFlags;
        this.newStyle = isNewStyle;
    }

    @Override
    public void traceProc(Interp interp, String part1, String part2, int flags) throws TclException {
        if ((this.flags & flags) != 0 && (flags & 0x100) == 0) {
            StringBuffer sbuf = new StringBuffer(this.command);
            try {
                Util.appendElement(interp, sbuf, part1);
                if (part2 != null) {
                    Util.appendElement(interp, sbuf, part2);
                } else {
                    Util.appendElement(interp, sbuf, "");
                }
                if (this.newStyle) {
                    if ((flags & 0x10) != 0) {
                        Util.appendElement(interp, sbuf, "read");
                    } else if ((flags & 0x20) != 0) {
                        Util.appendElement(interp, sbuf, "write");
                    } else if ((flags & 0x40) != 0) {
                        Util.appendElement(interp, sbuf, "unset");
                    } else if ((flags & 0x800) != 0) {
                        Util.appendElement(interp, sbuf, "array");
                    }
                } else if ((flags & 0x10) != 0) {
                    Util.appendElement(interp, sbuf, "r");
                } else if ((flags & 0x20) != 0) {
                    Util.appendElement(interp, sbuf, "w");
                } else if ((flags & 0x40) != 0) {
                    Util.appendElement(interp, sbuf, "u");
                } else if ((flags & 0x800) != 0) {
                    Util.appendElement(interp, sbuf, "a");
                }
            }
            catch (TclException e) {
                throw new TclRuntimeError("unexpected TclException: " + e);
            }
            interp.eval(sbuf.toString(), 0);
        }
    }
}

