/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.cmd;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Var;
import tcl.lang.cmd.NamespaceCmd;

public class VariableCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length == 1) {
            throw new TclException(interp, "wrong # args: should be \"variable ?name value...? name ?value?\"");
        }
        int i = 1;
        while (i < objv.length) {
            TclObject varValue;
            String varName = objv[i].toString();
            if (varName.endsWith(")") && varName.contains("(")) {
                throw new TclException(interp, "can't define \"" + varName + "\": name refers to an element in an array");
            }
            Var[] result = Var.lookupVar(interp, varName, null, 514, "define", true, false);
            if (result == null) {
                throw new TclException(interp, "");
            }
            Var var = result[0];
            Var cfr_ignored_0 = result[1];
            if (!var.isVarNamespace()) {
                var.setVarNamespace();
                ++var.refCount;
            }
            if (i + 1 < objv.length && (varValue = Var.setVar(interp, objv[i].toString(), null, objv[i + 1], 514)) == null) {
                throw new TclException(interp, "");
            }
            if (interp.varFrame != null && interp.varFrame.isProcCallFrame) {
                String varTail = NamespaceCmd.tail(varName);
                Var.makeUpvar(interp, null, varName, null, 2, varTail, 0, -1);
            }
            i += 2;
        }
    }
}

