/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.embed.jsr223;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.embed.jsr223.JtclScriptEngineFactory;
import tcl.pkg.java.ReflectObject;

public class JtclScriptEngine
extends AbstractScriptEngine {
    private ScriptEngineFactory factory;
    private static ThreadLocal<Interp> interpreters = new ThreadLocal();
    private static final String CONTEXT = "javax.script.ScriptContext";

    private static TclObject java2tcl(Interp interp, Object javaObj) throws TclException {
        Class cls;
        Class clazz = cls = javaObj == null ? Object.class : javaObj.getClass();
        if (cls == Integer.class) {
            return TclInteger.newInstance(((Integer)javaObj).intValue());
        }
        if (cls == Long.class) {
            return TclString.newInstance(javaObj.toString());
        }
        if (cls == Short.class) {
            return TclInteger.newInstance(((Short)javaObj).intValue());
        }
        if (cls == Byte.class) {
            return TclInteger.newInstance(((Byte)javaObj).intValue());
        }
        if (cls == Double.class) {
            return TclDouble.newInstance((Double)javaObj);
        }
        if (cls == Float.class) {
            return TclDouble.newInstance(((Float)javaObj).doubleValue());
        }
        if (cls == Boolean.class) {
            return TclBoolean.newInstance((Boolean)javaObj);
        }
        if (cls == Character.class) {
            return TclString.newInstance(((Character)javaObj).toString());
        }
        if (cls == String.class) {
            return TclString.newInstance((String)javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    private static Object tcl2java(Interp interp, TclObject tclObj) throws TclException {
        Object javaObject = null;
        boolean isReflectObj = false;
        try {
            javaObject = ReflectObject.get(interp, tclObj);
            isReflectObj = true;
        }
        catch (TclException tclException) {
            interp.resetResult();
        }
        if (isReflectObj) {
            return javaObject;
        }
        InternalRep rep = tclObj.getInternalRep();
        if (rep instanceof TclBoolean) {
            return new Boolean(TclBoolean.get(interp, tclObj));
        }
        if (rep instanceof TclInteger) {
            return new Integer(TclInteger.get(interp, tclObj));
        }
        if (rep instanceof TclDouble) {
            return new Double(TclDouble.get(interp, tclObj));
        }
        if (rep instanceof TclString) {
            return tclObj.toString();
        }
        return tclObj;
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        Interp interp = this.getInterp();
        AssocData oldAssocData = interp.getAssocData(CONTEXT);
        try {
            interp.setAssocData(CONTEXT, new ContextData(ctx));
            ctx.setAttribute("context", ctx, 100);
            interp.eval(str);
            TclObject tclObject = interp.getResult();
            return tclObject;
        }
        catch (TclException exp) {
            String errMsg = interp.getResult().toString();
            ScriptException se = new ScriptException(errMsg);
            se.initCause(exp);
            throw se;
        }
        finally {
            if (oldAssocData != null) {
                interp.setAssocData(CONTEXT, oldAssocData);
            }
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JtclScriptEngine jtclScriptEngine = this;
        synchronized (jtclScriptEngine) {
            if (this.factory == null) {
                this.factory = new JtclScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private Interp getInterp() {
        Interp interp = interpreters.get();
        if (interp == null) {
            interp = new Interp();
            ContextCommand cmd = new ContextCommand();
            interp.createCommand("context", cmd);
            interp.createCommand("var", cmd);
            interp.createCommand("echo", new EchoCommand());
            interpreters.set(interp);
        }
        return interp;
    }

    private static class ContextCommand
    implements Command {
        private ContextCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getVariable(Interp interp, ScriptContext ctx, String name) throws TclException {
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                int scope = ctx.getAttributesScope(name);
                if (scope == -1) {
                    throw new TclException(interp, "can't read \"" + name + "\": no such context variable");
                }
                Object val = ctx.getAttribute(name, scope);
                interp.setResult(JtclScriptEngine.java2tcl(interp, val));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setVariable(Interp interp, ScriptContext ctx, String name, TclObject value) throws TclException {
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                int scope = ctx.getAttributesScope(name);
                if (scope == -1) {
                    scope = 100;
                }
                ctx.setAttribute(name, JtclScriptEngine.tcl2java(interp, value), scope);
                interp.setResult(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteVariable(Interp interp, ScriptContext ctx, String name) throws TclException {
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                int scope = ctx.getAttributesScope(name);
                if (scope == -1) {
                    interp.setResult(false);
                } else {
                    ctx.removeAttribute(name, scope);
                    interp.setResult(true);
                }
            }
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            block8: {
                block7: {
                    AssocData data = interp.getAssocData(JtclScriptEngine.CONTEXT);
                    if (data == null || !(data instanceof ContextData)) break block7;
                    ScriptContext context = ((ContextData)data).getContext();
                    switch (argv.length) {
                        case 1: {
                            this.getVariable(interp, context, "context");
                            break block8;
                        }
                        case 2: {
                            this.getVariable(interp, context, argv[1].toString());
                            break block8;
                        }
                        case 3: {
                            String arg1 = argv[1].toString();
                            if (arg1.equals("-del")) {
                                String arg2 = argv[2].toString();
                                this.deleteVariable(interp, context, arg2);
                            } else {
                                this.setVariable(interp, context, argv[1].toString(), argv[2]);
                            }
                            break block8;
                        }
                        default: {
                            throw new TclNumArgsException(interp, 1, argv, "?varName? ?-del? ?newValue?");
                        }
                    }
                }
                throw new TclException(interp, "invalid script context");
            }
        }
    }

    private static class ContextData
    implements AssocData {
        private ScriptContext context;

        ContextData(ScriptContext ctx) {
            this.context = ctx;
        }

        ScriptContext getContext() {
            return this.context;
        }

        @Override
        public void disposeAssocData(Interp interp) {
        }
    }

    private static class EchoCommand
    implements Command {
        private EchoCommand() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
            Writer writer;
            AssocData data = interp.getAssocData(JtclScriptEngine.CONTEXT);
            if (data != null && data instanceof ContextData) {
                ScriptContext context = ((ContextData)data).getContext();
                writer = context.getWriter();
            } else {
                writer = new PrintWriter(System.out);
            }
            try {
                int i = 1;
                while (i < argv.length) {
                    writer.write(argv[i].toString());
                    writer.write(32);
                    ++i;
                }
                writer.flush();
            }
            catch (IOException exp) {
                throw new TclException(interp, "I/O error: " + exp.getMessage());
            }
        }
    }
}

