/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import tcl.lang.ManagedSystemInStream;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.process.Redirect;
import tcl.lang.process.TclProcess;

public class JavaProcess
extends TclProcess {
    protected Process process = null;
    protected ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
    protected InputStream stdinStream = null;
    protected OutputStream stdoutStream = null;
    protected OutputStream stderrStream = null;
    protected Coupler stdoutCoupler = null;
    protected Coupler stderrCoupler = null;

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    @Override
    public int exitValue() throws IllegalThreadStateException {
        if (this.process == null) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        return this.process.exitValue();
    }

    private void initializeEnv(ProcessBuilder processBuilder) {
        Map<String, String> pbenv = processBuilder.environment();
        pbenv.clear();
        pbenv.putAll(this.getenv());
    }

    @Override
    public void start() throws IOException {
        this.processBuilder.command(this.command);
        this.initializeEnv(this.processBuilder);
        if (this.stderrRedirect != null && this.stderrRedirect.type == Redirect.Type.MERGE_ERROR) {
            this.processBuilder.redirectErrorStream(true);
        }
        this.process = this.processBuilder.start();
        if (this.stdinRedirect != null) {
            switch (this.stdinRedirect.type) {
                case FILE: {
                    this.stdinStream = new BufferedInputStream(new FileInputStream(this.stdinRedirect.file));
                    break;
                }
                case PIPE: {
                    JavaProcess upstream = (JavaProcess)this.stdinRedirect.pipePartner;
                    this.stdinStream = upstream.getInputStream();
                    break;
                }
                case INHERIT: {
                    this.stdinStream = new ManagedSystemInStream();
                    break;
                }
                case STREAM: {
                    this.stdinStream = null;
                    break;
                }
                case TCL_CHANNEL: {
                    this.stdinStream = new InputStream(){
                        TclObject tclbuf = TclByteArray.newInstance();

                        @Override
                        public int read() throws IOException {
                            block4: {
                                try {
                                    if (!JavaProcess.this.stdinRedirect.channel.eof()) break block4;
                                    return -1;
                                }
                                catch (TclException e) {
                                    throw new IOException(e.getMessage());
                                }
                            }
                            int cnt = JavaProcess.this.stdinRedirect.channel.read(JavaProcess.this.interp, this.tclbuf, 3, 1);
                            if (cnt > 0) {
                                return TclByteArray.getBytes(JavaProcess.this.interp, this.tclbuf)[0];
                            }
                            return -1;
                        }
                    };
                }
            }
        }
        if (this.stdinStream != null) {
            Coupler coupler = new Coupler(this.stdinStream, this.process.getOutputStream(), true, true);
            coupler.setDaemon(true);
            coupler.setName("JavaProcess Coupler stdin");
            coupler.start();
        } else if (this.stdinRedirect != null && this.stdinRedirect.getType() == Redirect.Type.STREAM) {
            this.stdinRedirect.setOutputStream(this.process.getOutputStream());
        } else {
            this.process.getOutputStream().close();
        }
        boolean closeOutput = true;
        if (this.stdoutRedirect != null) {
            switch (this.stdoutRedirect.type) {
                case FILE: {
                    this.stdoutStream = new BufferedOutputStream(new FileOutputStream(this.stdoutRedirect.file, this.stdoutRedirect.appendToFile));
                    break;
                }
                case INHERIT: {
                    this.stdoutStream = new FileOutputStream(FileDescriptor.out);
                    closeOutput = false;
                    break;
                }
                case STREAM: {
                    this.stdoutStream = null;
                    break;
                }
                case TCL_CHANNEL: {
                    this.stdoutStream = new OutputStream(){
                        byte[] buf = new byte[1];
                        TclObject tclbuf;

                        @Override
                        public void write(int b) throws IOException {
                            this.buf[0] = (byte)(b & 0xFF);
                            this.tclbuf = TclByteArray.newInstance(this.buf);
                            try {
                                JavaProcess.this.stdoutRedirect.channel.write(JavaProcess.this.interp, this.tclbuf);
                            }
                            catch (TclException e) {
                                throw new IOException(e.getMessage());
                            }
                        }

                        @Override
                        public void flush() throws IOException {
                            super.flush();
                            try {
                                JavaProcess.this.stdoutRedirect.channel.flush(JavaProcess.this.interp);
                            }
                            catch (TclException e) {
                                throw new IOException(e.getMessage());
                            }
                        }
                    };
                }
            }
        }
        if (this.stdoutStream != null) {
            this.stdoutCoupler = new Coupler(this.process.getInputStream(), this.stdoutStream, closeOutput, this.stdoutRedirect.type == Redirect.Type.INHERIT);
            this.stdoutCoupler.setDaemon(true);
            this.stdoutCoupler.setName("JavaProcess Coupler stdout");
            this.stdoutCoupler.start();
        } else if (this.stdoutRedirect != null && this.stdoutRedirect.getType() == Redirect.Type.STREAM) {
            this.stdoutRedirect.setInputStream(this.process.getInputStream());
        }
        closeOutput = true;
        if (this.stderrRedirect != null && this.stderrRedirect.type != Redirect.Type.MERGE_ERROR) {
            switch (this.stderrRedirect.type) {
                case FILE: {
                    this.stderrStream = new BufferedOutputStream(new FileOutputStream(this.stderrRedirect.file, this.stderrRedirect.appendToFile));
                    break;
                }
                case INHERIT: {
                    this.stderrStream = new FileOutputStream(FileDescriptor.err);
                    closeOutput = false;
                    break;
                }
                case STREAM: {
                    this.stderrStream = null;
                    break;
                }
                case TCL_CHANNEL: {
                    closeOutput = false;
                    this.stderrStream = new OutputStream(){
                        byte[] buf = new byte[1];
                        TclObject tclbuf;

                        @Override
                        public void write(int b) throws IOException {
                            this.buf[0] = (byte)(b & 0xFF);
                            this.tclbuf = TclByteArray.newInstance(this.buf);
                            try {
                                try {
                                    try {
                                        JavaProcess.this.stderrRedirect.channel.waitForOwnership(2);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    JavaProcess.this.stderrRedirect.channel.write(JavaProcess.this.interp, this.tclbuf);
                                }
                                catch (TclException e) {
                                    throw new IOException(e.getMessage());
                                }
                            }
                            finally {
                                JavaProcess.this.stderrRedirect.channel.setOwnership(false, 2);
                            }
                        }

                        @Override
                        public void write(byte[] b, int off, int len) throws IOException {
                            this.tclbuf = TclByteArray.newInstance(b, off, len);
                            try {
                                try {
                                    try {
                                        JavaProcess.this.stderrRedirect.channel.waitForOwnership(2);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    JavaProcess.this.stderrRedirect.channel.write(JavaProcess.this.interp, this.tclbuf);
                                }
                                catch (TclException e) {
                                    throw new IOException(e.getMessage());
                                }
                            }
                            finally {
                                JavaProcess.this.stderrRedirect.channel.setOwnership(false, 2);
                            }
                        }

                        @Override
                        public void flush() throws IOException {
                            super.flush();
                            try {
                                try {
                                    try {
                                        JavaProcess.this.stderrRedirect.channel.waitForOwnership(2);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    JavaProcess.this.stderrRedirect.channel.flush(JavaProcess.this.interp);
                                }
                                catch (TclException e) {
                                    throw new IOException(e.getMessage());
                                }
                            }
                            finally {
                                JavaProcess.this.stderrRedirect.channel.setOwnership(false, 2);
                            }
                        }
                    };
                }
            }
        }
        if (this.stderrStream != null) {
            this.stderrCoupler = new Coupler(this.process.getErrorStream(), this.stderrStream, closeOutput, true);
            this.stderrCoupler.setDaemon(true);
            this.stderrCoupler.setName("JavaProcess Coupler stderr");
            this.stderrCoupler.start();
        } else if (this.stderrRedirect != null && this.stderrRedirect.getType() == Redirect.Type.STREAM) {
            this.stderrRedirect.setInputStream(this.process.getErrorStream());
        }
    }

    @Override
    protected int implWaitFor() throws InterruptedException, IOException {
        if (this.process == null) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        int rv = this.process.waitFor();
        if (this.stdinRedirect != null && this.stdinRedirect.type == Redirect.Type.INHERIT && this.stdinStream != null) {
            this.stdinStream.close();
        }
        if (this.stdoutCoupler != null) {
            this.stdoutCoupler.join();
        }
        if (this.stderrCoupler != null) {
            this.stderrCoupler.join();
        }
        return rv;
    }

    @Override
    public int getPid() throws IllegalThreadStateException {
        String[] pidFields;
        if (this.process == null) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        String[] stringArray = pidFields = new String[]{"pid", "handle"};
        int n = pidFields.length;
        int n2 = 0;
        while (n2 < n) {
            String pidField = stringArray[n2];
            try {
                Field f = this.process.getClass().getDeclaredField(pidField);
                f.setAccessible(true);
                return f.getInt(this.process);
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return -1;
    }

    @Override
    public boolean isStarted() {
        return this.process != null;
    }

    @Override
    public void setWorkingDir(File workingDir) {
        this.processBuilder.directory(workingDir);
    }

    @Override
    public void destroy() {
        if (this.stdinRedirect != null && this.stdinRedirect.type == Redirect.Type.INHERIT) {
            try {
                this.stdinStream.close();
            }
            catch (IOException iOException) {}
        }
        this.process.destroy();
    }

    @Override
    public boolean canInheritFileDescriptors() {
        return false;
    }

    private class Coupler
    extends Thread {
        InputStream in = null;
        OutputStream out = null;
        boolean closeOut;
        boolean flushOut;

        public Coupler(InputStream in, OutputStream out, boolean closeOut, boolean flushOut) {
            this.in = in;
            this.out = out;
            this.closeOut = closeOut;
            this.flushOut = flushOut;
        }

        @Override
        public void run() {
            byte[] buf = new byte[256];
            while (true) {
                int b = -1;
                try {
                    int avail = this.in.available();
                    avail = avail > buf.length ? buf.length : avail;
                    avail = avail == 0 ? 1 : avail;
                    b = this.in.read(buf, 0, avail);
                    if (b == -1) {
                        if (!this.closeOut) break;
                        this.out.close();
                        break;
                    }
                    this.out.write(buf, 0, b);
                    if (!this.flushOut) continue;
                    this.out.flush();
                }
                catch (IOException e) {
                    if (!e.getMessage().toLowerCase().contains("pipe closed")) {
                        JavaProcess.this.saveIOException(e);
                    }
                    try {
                        if (this.closeOut) {
                            this.out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
        }
    }
}

