/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.process;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import tcl.lang.channel.Channel;
import tcl.lang.process.TclProcess;

public class Redirect {
    protected Type type;
    protected Channel channel = null;
    protected File file = null;
    protected String specifiedFilePath = null;
    protected TclProcess pipePartner = null;
    protected boolean closeChannel = false;
    protected boolean appendToFile = false;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;

    private Redirect(Type type) {
        this.type = type;
    }

    public Redirect(TclProcess partner) {
        this.type = Type.PIPE;
        this.pipePartner = partner;
    }

    public Redirect(File f, String specifiedPath, boolean append) {
        this.type = Type.FILE;
        this.file = f;
        this.specifiedFilePath = specifiedPath;
        this.appendToFile = append;
    }

    public Redirect(Channel channel, boolean close) {
        this.type = Type.TCL_CHANNEL;
        this.channel = channel;
        this.closeChannel = close;
    }

    public static Redirect stream() {
        return new Redirect(Type.STREAM);
    }

    public static Redirect inherit() {
        return new Redirect(Type.INHERIT);
    }

    public static Redirect stderrToStdout() {
        return new Redirect(Type.MERGE_ERROR);
    }

    public Type getType() {
        return this.type;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public static enum Type {
        INHERIT,
        PIPE,
        FILE,
        TCL_CHANNEL,
        MERGE_ERROR,
        STREAM;

    }
}

