/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.process;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.process.JavaProcess;
import tcl.lang.process.Redirect;

public abstract class TclProcess {
    protected Redirect stdinRedirect = null;
    protected Redirect stdoutRedirect = null;
    protected Redirect stderrRedirect = null;
    protected List<String> command = null;
    protected Interp interp;
    protected IOException savedException = null;

    public static TclProcess newInstance(Interp interp) {
        JavaProcess p = new JavaProcess();
        p.interp = interp;
        return p;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public List<String> command() {
        return this.command;
    }

    protected Map<String, String> getenv() {
        return this.interp.getenv();
    }

    public abstract void start() throws IOException;

    public abstract int exitValue() throws IllegalThreadStateException;

    public int waitFor() throws IllegalThreadStateException, InterruptedException, IOException {
        if (!this.isStarted()) {
            throw new IllegalThreadStateException("Process not yet started");
        }
        int rv = this.implWaitFor();
        if (this.stdoutRedirect != null && this.stdoutRedirect.type == Redirect.Type.TCL_CHANNEL && this.stdoutRedirect.closeChannel) {
            TclIO.unregisterChannel(this.interp, this.stdoutRedirect.channel);
        }
        if (this.stderrRedirect != null && this.stderrRedirect.type == Redirect.Type.TCL_CHANNEL && this.stderrRedirect.closeChannel) {
            TclIO.unregisterChannel(this.interp, this.stderrRedirect.channel);
        }
        this.throwAnyExceptions();
        return rv;
    }

    protected abstract int implWaitFor() throws InterruptedException, IOException;

    public abstract int getPid() throws IllegalThreadStateException;

    public abstract boolean isStarted();

    public abstract void setWorkingDir(File var1);

    public abstract void destroy();

    public abstract boolean canInheritFileDescriptors();

    public Redirect getStdinRedirect() {
        return this.stdinRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveIOException(IOException e) {
        TclProcess tclProcess = this;
        synchronized (tclProcess) {
            if (this.savedException == null) {
                this.savedException = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwAnyExceptions() throws IOException {
        TclProcess tclProcess = this;
        synchronized (tclProcess) {
            if (this.savedException != null) {
                throw this.savedException;
            }
        }
    }

    public void setStdinRedirect(Redirect stdinRedirect) throws TclException {
        if (stdinRedirect == null) {
            this.stdinRedirect = null;
            return;
        }
        if (stdinRedirect.type == Redirect.Type.MERGE_ERROR) {
            throw new TclRuntimeError("Output redirects cannot be attached to process stdin");
        }
        if (stdinRedirect.type == Redirect.Type.TCL_CHANNEL && stdinRedirect.channel.isWriteOnly()) {
            throw new TclException(this.interp, "channel \"" + stdinRedirect.channel.getChanName() + "\" wasn't opened for reading");
        }
        if (stdinRedirect.type == Redirect.Type.FILE && !stdinRedirect.file.exists()) {
            throw new TclPosixException(this.interp, 2, true, "couldn't read file \"" + stdinRedirect.specifiedFilePath + "\"");
        }
        this.stdinRedirect = stdinRedirect.type == Redirect.Type.TCL_CHANNEL && "stdin".equals(stdinRedirect.channel.getChanName()) ? Redirect.inherit() : stdinRedirect;
    }

    public Redirect getStdoutRedirect() {
        return this.stdoutRedirect;
    }

    public void setStdoutRedirect(Redirect stdoutRedirect) throws TclException {
        if (stdoutRedirect.type == Redirect.Type.MERGE_ERROR) {
            throw new TclRuntimeError("Stdout  cannot be attached to MERGE_ERROR");
        }
        if (stdoutRedirect.type == Redirect.Type.TCL_CHANNEL) {
            if (stdoutRedirect.channel.isReadOnly()) {
                throw new TclException(this.interp, "channel \"" + stdoutRedirect.channel.getChanName() + "\" wasn't opened for writing");
            }
            try {
                stdoutRedirect.channel.flush(this.interp);
            }
            catch (IOException e) {
                throw new TclException(this.interp, e.getMessage());
            }
        }
        if (stdoutRedirect.type == Redirect.Type.FILE) {
            File testFile = stdoutRedirect.file;
            if (!stdoutRedirect.appendToFile) {
                testFile = testFile.getAbsoluteFile().getParentFile();
            }
            if (!testFile.exists()) {
                throw new TclPosixException(this.interp, 2, true, "couldn't write file \"" + stdoutRedirect.specifiedFilePath + "\"");
            }
        }
        this.stdoutRedirect = stdoutRedirect.type == Redirect.Type.TCL_CHANNEL && "stdout".equals(stdoutRedirect.channel.getChanName()) ? Redirect.inherit() : stdoutRedirect;
    }

    public Redirect getStderrRedirect() {
        return this.stderrRedirect;
    }

    public void setStderrRedirect(Redirect stderrRedirect) throws TclException {
        if (stderrRedirect.type == Redirect.Type.PIPE) {
            throw new TclRuntimeError("Stderr cannot be attached to Pipe, use MERGE_ERROR");
        }
        if (stderrRedirect.type == Redirect.Type.TCL_CHANNEL) {
            if (stderrRedirect.channel.isReadOnly()) {
                throw new TclException(this.interp, "channel \"" + stderrRedirect.channel.getChanName() + "\" wasn't opened for writing");
            }
            try {
                stderrRedirect.channel.flush(this.interp);
            }
            catch (IOException e) {
                throw new TclException(this.interp, e.getMessage());
            }
        }
        if (stderrRedirect.type == Redirect.Type.FILE) {
            File testFile = stderrRedirect.file;
            if (!stderrRedirect.appendToFile) {
                testFile = testFile.getAbsoluteFile().getParentFile();
            }
            if (!testFile.exists()) {
                throw new TclPosixException(this.interp, 2, true, "couldn't write file \"" + stderrRedirect.specifiedFilePath + "\"");
            }
        }
        this.stderrRedirect = stderrRedirect.type == Redirect.Type.TCL_CHANNEL && "stderr".equals(stderrRedirect.channel.getChanName()) ? Redirect.inherit() : stderrRedirect;
    }
}

