/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class ArgOptions {
    private final Interp interp;
    private final TclObject[] argv;
    private final int start;
    private final boolean[] used;

    public ArgOptions(Interp interp, TclObject[] argv, int start) {
        this.interp = interp;
        this.argv = argv;
        this.start = start;
        this.used = new boolean[argv.length];
    }

    public String get(String optName, String defValue) throws TclException {
        int i = this.start;
        while (i < this.argv.length && i < this.used.length) {
            String arg;
            if (!this.used[i] && optName.startsWith(arg = this.argv[i].toString())) {
                this.used[i] = true;
                if (++i >= this.argv.length || i >= this.used.length) {
                    throw new TclException(this.interp, "No value for argument \"" + optName + "\"");
                }
                this.used[i] = true;
                defValue = this.argv[i].toString();
                break;
            }
            ++i;
        }
        return defValue;
    }

    public double get(String optName, double defValue) throws TclException {
        int i = this.start;
        while (i < this.argv.length && i < this.used.length) {
            String arg;
            if (!this.used[i] && optName.startsWith(arg = this.argv[i].toString())) {
                this.used[i] = true;
                if (++i >= this.argv.length || i >= this.used.length) {
                    throw new TclException(this.interp, "No value for argument \"" + optName + "\"");
                }
                this.used[i] = true;
                defValue = TclDouble.get(this.interp, this.argv[i]);
                break;
            }
            ++i;
        }
        return defValue;
    }

    public int get(String optName, int defValue) throws TclException {
        int i = this.start;
        while (i < this.argv.length && i < this.used.length) {
            String arg;
            if (!this.used[i] && optName.startsWith(arg = this.argv[i].toString())) {
                this.used[i] = true;
                if (++i >= this.argv.length || i >= this.used.length) {
                    throw new TclException(this.interp, "No value for argument \"" + optName + "\"");
                }
                this.used[i] = true;
                defValue = TclInteger.get(this.interp, this.argv[i]);
                break;
            }
            ++i;
        }
        return defValue;
    }

    public boolean get(String optName) throws TclException {
        boolean defValue = false;
        int i = this.start;
        while (i < this.argv.length && i < this.used.length) {
            String arg;
            if (!this.used[i] && optName.startsWith(arg = this.argv[i].toString())) {
                this.used[i] = true;
                return true;
            }
            ++i;
        }
        return defValue;
    }

    public boolean getOptDoubleList(String optName, ArrayList<Double> defValue) throws TclException {
        int i = this.start;
        while (i < this.argv.length && i < this.used.length) {
            String arg;
            if (!this.used[i] && optName.startsWith(arg = this.argv[i].toString())) {
                TclObject[] regions;
                this.used[i] = true;
                if (++i >= this.argv.length || i >= this.used.length) {
                    throw new TclException(this.interp, "No value for argument \"" + optName + "\"");
                }
                this.used[i] = true;
                TclObject[] tclObjectArray = regions = TclList.getElements(this.interp, this.argv[i]);
                int n = regions.length;
                int n2 = 0;
                while (n2 < n) {
                    TclObject regionPt = tclObjectArray[n2];
                    defValue.add(TclDouble.get(this.interp, regionPt));
                    ++n2;
                }
                break;
            }
            ++i;
        }
        return defValue.size() > 0;
    }

    public double[] get(String optName, double[] defValue) throws TclException {
        int i = this.start;
        while (i < this.argv.length && i < this.used.length) {
            String arg;
            if (!this.used[i] && optName.startsWith(arg = this.argv[i].toString())) {
                this.used[i] = true;
                if (++i >= this.argv.length || i >= this.used.length) {
                    throw new TclException(this.interp, "No value for argument \"" + optName + "\"");
                }
                this.used[i] = true;
                TclObject[] regions = TclList.getElements(this.interp, this.argv[i]);
                defValue = new double[regions.length];
                int j = 0;
                TclObject[] tclObjectArray = regions;
                int n = regions.length;
                int n2 = 0;
                while (n2 < n) {
                    TclObject regionPt = tclObjectArray[n2];
                    defValue[j++] = TclDouble.get(this.interp, regionPt);
                    ++n2;
                }
                break;
            }
            ++i;
        }
        return defValue;
    }
}

