/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclDict;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.fleet.ArgOptions;
import tcl.pkg.fleet.FleetMember;
import tcl.pkg.fleet.Message;

public class FleetCmd
implements Command {
    private static long fleetCount = 0L;
    private long memberCount = 0L;
    Namespace ns;
    String fleetName;
    private static final HashMap<String, FleetMember> fleetMembers = new HashMap();
    private static HashMap<String, SubCmds> aliasMap = new HashMap();

    /*
     * Unable to fully structure code
     */
    SubCmds getSubCmd(Interp interp, String name) throws TclException {
        block12: {
            try {
                subCmd = SubCmds.valueOf(name);
                break block12;
            }
            catch (IllegalArgumentException v0) {
                subCmd = FleetCmd.aliasMap.get(name);
                if (subCmd != null) break block12;
                count = 0;
                sValues = new ArrayList<String>();
                var9_6 = SubCmds.values();
                var8_7 = ((SubCmds[])var9_6).length;
                var7_9 = 0;
                ** while (var7_9 < var8_7)
            }
lbl-1000:
            // 1 sources

            {
                testCmd = var9_6[var7_9];
                if (testCmd.name().startsWith(name)) {
                    sValues.add(testCmd.name());
                    subCmd = testCmd;
                    ++count;
                }
                ++var7_9;
                continue;
            }
lbl21:
            // 1 sources

            if (count == 1) {
                FleetCmd.aliasMap.put(name, subCmd);
            } else {
                if (count == 0) {
                    sValues.clear();
                    var9_6 = SubCmds.values();
                    var8_7 = ((SubCmds[])var9_6).length;
                    var7_9 = 0;
                    while (var7_9 < var8_7) {
                        value = var9_6[var7_9];
                        sValues.add(value.name());
                        ++var7_9;
                    }
                }
                Collections.sort(sValues);
                valueString = new StringBuilder();
                i = 0;
                for (String value : sValues) {
                    if (i != sValues.size() - 1) {
                        valueString.append(value);
                        valueString.append(", ");
                    } else {
                        valueString.append("or ");
                        valueString.append(value);
                    }
                    ++i;
                }
                if (count == 0) {
                    throw new TclException(interp, "bad option \"" + name + "\": must be " + valueString);
                }
                throw new TclException(interp, "ambiguous option \"" + name + "\": must be " + valueString);
            }
        }
        return subCmd;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "opt");
        }
        try {
            SubCmds subCmd = this.getSubCmd(interp, argv[1].toString());
            subCmd.eval(interp, argv, this);
        }
        catch (TclException tclE) {
            throw tclE;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TclException(interp, argv[0] + " " + argv[1] + " " + e.getMessage());
        }
    }

    static void sendCommand(Interp interp, FleetMember member, TclObject messageList, String readyCmd, String readyVar) throws TclException {
        Message cjobj = new Message(interp, messageList, readyCmd, readyVar);
        member.execCommand(cjobj);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SubCmds {
        create{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                Namespace ns;
                ArgOptions argOptions = new ArgOptions(interp, argv, 2);
                String name = argOptions.get("-name", "fleet" + fleetCount);
                ++fleetCount;
                FleetCmd fleetCmd = new FleetCmd();
                interp.createCommand(name, fleetCmd);
                fleetCmd.fleetName = name;
                interp.setResult(name);
                fleetCmd.ns = ns = Namespace.createNamespace(interp, "::fleet::" + name, null);
            }
        }
        ,
        member{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                ArgOptions argOptions = new ArgOptions(interp, argv, 2);
                String name = argOptions.get("-name", "member" + mCmd.memberCount);
                ++mCmd.memberCount;
                FleetMember fleetMember = new FleetMember(mCmd, name);
                fleetMembers.put(name, fleetMember);
                interp.setResult(name);
            }
        }
        ,
        tell{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                ArgOptions argOptions = new ArgOptions(interp, argv, 4);
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 2, argv, "memberName msg ?-reply reply? ?-var varName?");
                }
                String replyCmd = argOptions.get("-reply", (String)null);
                String doneVar = argOptions.get("-var", (String)null);
                String memberName = argv[2].toString();
                TclObject[] cmdArgs = TclList.getElements(interp, argv[3]);
                if (memberName.equals("*")) {
                    for (FleetMember member : fleetMembers.values()) {
                        TclObject messageList = TclList.newInstance();
                        messageList.preserve();
                        TclObject[] tclObjectArray = cmdArgs;
                        int n = cmdArgs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TclObject cmdArg = tclObjectArray[n2];
                            cmdArg.preserve();
                            TclList.append(interp, messageList, cmdArg);
                            ++n2;
                        }
                        FleetCmd.sendCommand(interp, member, messageList, replyCmd, doneVar);
                    }
                } else {
                    TclObject messageList = TclList.newInstance();
                    messageList.preserve();
                    TclObject[] tclObjectArray = cmdArgs;
                    int n = cmdArgs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TclObject cmdArg = tclObjectArray[n3];
                        cmdArg.preserve();
                        TclList.append(interp, messageList, cmdArg);
                        ++n3;
                    }
                    FleetMember member = fleetMembers.get(memberName);
                    if (member == null) {
                        throw new TclException(interp, "Can't find member \"" + memberName + "\" in fleet \"" + mCmd.fleetName + "\"");
                    }
                    FleetCmd.sendCommand(interp, member, messageList, replyCmd, doneVar);
                }
            }
        }
        ,
        forget{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "memberName");
                }
                String memberName = argv[2].toString();
                FleetMember member = fleetMembers.get(memberName);
                if (member == null) {
                    throw new TclException(interp, "Can't find member \"" + memberName + "\" in fleet \"" + mCmd.fleetName + "\"");
                }
                int size = member.forget();
                interp.setResult(size);
            }
        }
        ,
        count{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "-messages memberName");
                }
                ArgOptions argOptions = new ArgOptions(interp, argv, 2);
                String memberName = argOptions.get("-messages", "");
                if (!memberName.equals("")) {
                    FleetMember member = fleetMembers.get(memberName);
                    if (member == null) {
                        throw new TclException(interp, "Can't find member \"" + memberName + "\" in fleet \"" + mCmd.fleetName + "\"");
                    }
                    int size = member.messageCount();
                    interp.setResult(size);
                }
            }
        }
        ,
        stats{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "-member memberName");
                }
                ArgOptions argOptions = new ArgOptions(interp, argv, 2);
                String memberName = argOptions.get("-member", "");
                if (!memberName.equals("")) {
                    FleetMember member = fleetMembers.get(memberName);
                    if (member == null) {
                        throw new TclException(interp, "Can't find member \"" + memberName + "\" in fleet \"" + mCmd.fleetName + "\"");
                    }
                    TclObject tDict = TclDict.newInstance();
                    double processingTime = member.getProcessingTime();
                    double waitingTime = member.getWaitingTime();
                    TclDict.put(interp, tDict, TclString.newInstance("processing"), TclDouble.newInstance(processingTime));
                    TclDict.put(interp, tDict, TclString.newInstance("waiting"), TclDouble.newInstance(waitingTime));
                    interp.setResult(tDict);
                }
            }
        }
        ,
        destroy{

            @Override
            void eval(Interp interp, TclObject[] argv, FleetCmd mCmd) throws TclException {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?memberName?");
                }
                if (argv.length == 3) {
                    String memberName = argv[2].toString();
                    FleetMember member = fleetMembers.get(memberName);
                    if (member == null) {
                        throw new TclException(interp, "Can't find member \"" + memberName + "\" in fleet \"" + mCmd.fleetName + "\"");
                    }
                    member.execCommand(null);
                    fleetMembers.remove(memberName);
                } else {
                    Namespace.deleteNamespace(mCmd.ns);
                    int result = interp.deleteCommand(mCmd.fleetName);
                    interp.setResult(result);
                }
            }
        };


        abstract void eval(Interp var1, TclObject[] var2, FleetCmd var3) throws TclException;
    }
}

