/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.fleet.FleetCmd;
import tcl.pkg.fleet.Message;

public class FleetMember
implements Runnable {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    private static boolean debug = false;
    private boolean terminated = false;
    private Thread thread = null;
    private BlockingQueue queue = new LinkedBlockingQueue();
    private Interp interp = null;
    private final FleetCmd fleet;
    private final String name;
    private long processingTime = 0L;
    private long waitingTime = 0L;

    FleetMember(FleetCmd fleet, String name) {
        this.name = name;
        this.fleet = fleet;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName(String.valueOf(name) + " service");
        if (debug) {
            System.out.println("thread create");
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execCommand(Message callback) {
        if (debug) {
            System.out.println("execCommand ");
        }
        ExecEvent event = new ExecEvent(callback);
        this.queue.add(event);
        FleetMember fleetMember = this;
        synchronized (fleetMember) {
            if (debug) {
                System.out.println("notify in execCommand");
            }
            this.notify();
        }
    }

    public int forget() {
        int size = this.queue.size();
        this.queue.clear();
        return size;
    }

    public int messageCount() {
        int size = this.queue.size();
        return size;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        if (debug) {
            System.out.println("thread start");
        }
        try {
            while (true) {
                long startTime = System.nanoTime();
                ExecEvent event = (ExecEvent)this.queue.take();
                if (event.callback != null) {
                    this.waitingTime += System.nanoTime() - startTime;
                    this.processEvent(event);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ieE) {
            ieE.printStackTrace();
        }
        this.terminated = true;
        if (this.interp != null) {
            if (debug) {
                System.out.println("Invoking interp.dispose()");
            }
            this.interp.dispose();
            this.interp = null;
        }
    }

    private void processEvent(ExecEvent event) {
        block20: {
            block19: {
                if (debug) {
                    System.out.println("PROCESS QUEUE EVENT: " + event);
                }
                try {
                    try {
                        if (this.interp == null) {
                            if (debug) {
                                System.out.println("Interp() and init");
                            }
                            this.interp = new Interp();
                        }
                        this.evalScript(event.callback);
                        break block19;
                    }
                    catch (TclException te) {
                        StringBuffer msg = new StringBuffer(128);
                        msg.append("TclException: ");
                        try {
                            TclObject ei = this.interp.getVar("errorInfo", null, 1);
                            msg.append(ei.toString());
                        }
                        catch (TclException tclException) {
                            msg.append(te.getMessage());
                        }
                        if (debug) {
                            System.out.println(msg.toString());
                        }
                        event.callback.completed(1, this.fleet, this, TclString.newInstance(msg.toString()));
                        try {
                            TclObject[] cmdArgs;
                            TclObject[] tclObjectArray = cmdArgs = TclList.getElements(this.interp, event.callback.messageList);
                            int n = cmdArgs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TclObject cmdArg = tclObjectArray[n2];
                                cmdArg.release();
                                ++n2;
                            }
                            break block20;
                        }
                        catch (TclException tclException) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        TclObject[] cmdArgs;
                        TclObject[] tclObjectArray = cmdArgs = TclList.getElements(this.interp, event.callback.messageList);
                        int n = cmdArgs.length;
                        int n3 = 0;
                        while (n3 < n) {
                            TclObject cmdArg = tclObjectArray[n3];
                            cmdArg.release();
                            ++n3;
                        }
                    }
                    catch (TclException tclException) {}
                }
                throw throwable;
            }
            try {
                TclObject[] cmdArgs;
                TclObject[] tclObjectArray = cmdArgs = TclList.getElements(this.interp, event.callback.messageList);
                int n = cmdArgs.length;
                int n4 = 0;
                while (n4 < n) {
                    TclObject cmdArg = tclObjectArray[n4];
                    cmdArg.release();
                    ++n4;
                }
            }
            catch (TclException tclException) {}
        }
    }

    public double getProcessingTime() {
        return (double)this.processingTime / 1.0E9;
    }

    public double getWaitingTime() {
        return (double)this.waitingTime / 1.0E9;
    }

    private void evalScript(Message callback) throws TclException {
        if (debug) {
            System.out.println("evalCmd ");
        }
        long startTime = System.nanoTime();
        this.interp.eval(callback.messageList, 131072);
        TclObject result = this.interp.getResult().duplicate();
        result.preserve();
        this.processingTime += System.nanoTime() - startTime;
        callback.completed(0, this.fleet, this, result);
    }

    protected void finalize() throws Throwable {
        if (debug) {
            System.out.println("TclThread finalized");
        }
        super.finalize();
    }

    private static class ExecEvent {
        final Message callback;

        ExecEvent(Message callback) {
            this.callback = callback;
        }
    }

    public static interface MessageResult {
        public void completed(int var1, FleetCmd var2, FleetMember var3, TclObject var4);
    }
}

