/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.fleet;

import tcl.lang.Interp;
import tcl.lang.TclDict;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.fleet.FleetCmd;
import tcl.pkg.fleet.FleetMember;

class Message
extends TclEvent
implements FleetMember.MessageResult {
    final boolean debug = false;
    final TclObject messageList;
    final Interp interp;
    final String readyCmd;
    final String readyVar;
    boolean status;
    private TclObject result;
    String errorMsg = "";
    FleetCmd fleet = null;
    String memberName = "";
    int count = 0;

    Message(Interp interp, TclObject messageList, String readyCmd, String readyVar) {
        this.interp = interp;
        this.messageList = messageList;
        this.readyCmd = readyCmd;
        this.readyVar = readyVar;
    }

    @Override
    public void completed(int status, FleetCmd fleet, FleetMember member, TclObject result) {
        this.fleet = fleet;
        this.memberName = member.getName();
        this.count = member.messageCount();
        if (status == 0) {
            this.status = true;
            this.result = result;
        } else {
            this.status = false;
            this.result = result;
        }
        this.interp.getNotifier().queueEvent(this, 0);
    }

    @Override
    public int processEvent(int flags) {
        this.readyReport();
        return 1;
    }

    void readyReport() {
        try {
            if (this.readyVar != null) {
                TclObject tDict = TclDict.newInstance();
                if (this.status) {
                    TclDict.put(this.interp, tDict, TclString.newInstance("status"), TclString.newInstance("OK"));
                } else {
                    TclDict.put(this.interp, tDict, TclString.newInstance("status"), TclString.newInstance("FAIL"));
                }
                TclDict.put(this.interp, tDict, TclString.newInstance("fleet"), TclString.newInstance(this.fleet.fleetName));
                TclDict.put(this.interp, tDict, TclString.newInstance("member"), TclString.newInstance(this.memberName));
                TclDict.put(this.interp, tDict, TclString.newInstance("value"), this.result);
                TclDict.put(this.interp, tDict, TclString.newInstance("count"), TclInteger.newInstance(this.count));
                this.interp.setVar(this.readyVar, null, tDict, 1);
            } else if (this.readyCmd != null) {
                TclObject tlist = TclList.newInstance();
                TclList.append(this.interp, tlist, TclString.newInstance(this.readyCmd));
                TclObject tDict = TclDict.newInstance();
                if (this.status) {
                    TclDict.put(this.interp, tDict, TclString.newInstance("status"), TclString.newInstance("OK"));
                } else {
                    TclDict.put(this.interp, tDict, TclString.newInstance("status"), TclString.newInstance("FAIL"));
                }
                TclDict.put(this.interp, tDict, TclString.newInstance("fleet"), TclString.newInstance(this.fleet.fleetName));
                TclDict.put(this.interp, tDict, TclString.newInstance("member"), TclString.newInstance(this.memberName));
                TclDict.put(this.interp, tDict, TclString.newInstance("value"), this.result);
                TclDict.put(this.interp, tDict, TclString.newInstance("count"), TclInteger.newInstance(this.count));
                TclList.append(this.interp, tlist, tDict);
                this.interp.eval(tlist, 131072);
            }
        }
        catch (TclException te) {
            te.printStackTrace(System.err);
        }
    }
}

