/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.BiMethod;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.Ensemble;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclContext;
import tcl.pkg.itcl.ItclHierIter;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclMember;
import tcl.pkg.itcl.ItclMemberCode;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Linkage;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Objects;
import tcl.pkg.itcl.Util;

class BiCmds {
    private static BiMethod[] BiMethodList = new BiMethod[]{new BiMethod("cget", "-option", "@itcl-builtin-cget", new BiCgetCmd()), new BiMethod("configure", "?-option? ?value -option value...?", "@itcl-builtin-configure", new BiConfigureCmd()), new BiMethod("isa", "className", "@itcl-builtin-isa", new BiIsaCmd())};
    private static final int BiMethodListLen = BiMethodList.length;

    BiCmds() {
    }

    public static void BiInit(Interp interp) throws TclException {
        int i = 0;
        while (i < BiMethodListLen) {
            Linkage.RegisterObjC(interp, BiCmds.BiMethodList[i].registration.substring(1), BiCmds.BiMethodList[i].proc);
            ++i;
        }
        interp.createCommand("::itcl::builtin::chain", new BiChainCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::builtin::info");
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "class", "", (Command)new BiInfoClassCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "inherit", "", (Command)new BiInfoInheritCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "heritage", "", (Command)new BiInfoHeritageCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "function", "?name? ?-protection? ?-type? ?-name? ?-args? ?-body?", (Command)new BiInfoFunctionCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "variable", "?name? ?-protection? ?-type? ?-name? ?-init? ?-value? ?-config?", (Command)new BiInfoVariableCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "args", "procname", (Command)new BiInfoArgsCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "body", "procname", (Command)new BiInfoBodyCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::builtin::info", "@error", "", (Command)new DefaultInfoCmd());
        Namespace itclBiNs = Namespace.findNamespace(interp, "::itcl::builtin", null, 512);
        if (itclBiNs == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        Namespace.exportList(interp, itclBiNs, "*", true);
    }

    public static void InstallBiMethods(Interp interp, ItclClass cdefn) throws TclException {
        boolean foundMatch = false;
        int i = 0;
        while (i < BiMethodListLen) {
            ItclHierIter hier = new ItclHierIter();
            Class.InitHierIter(hier, cdefn);
            ItclClass cd = Class.AdvanceHierIter(hier);
            while (cd != null) {
                if (cd.functions.containsKey(BiCmds.BiMethodList[i].name)) {
                    foundMatch = true;
                    break;
                }
                cd = Class.AdvanceHierIter(hier);
            }
            Class.DeleteHierIter(hier);
            if (!foundMatch) {
                Methods.CreateMethod(interp, cdefn, BiCmds.BiMethodList[i].name, BiCmds.BiMethodList[i].usage, BiCmds.BiMethodList[i].registration);
            }
            ++i;
        }
    }

    private static TclObject ReportPublicOpt(Interp interp, ItclVarDefn vdefn, ItclObject contextObj) {
        TclObject list = TclList.newInstance();
        StringBuffer optName = new StringBuffer(64);
        optName.append("-");
        ItclClass cdefn = contextObj.classDefn;
        ItclVarLookup vlookup = (ItclVarLookup)cdefn.resolveVars.get(vdefn.member.fullname);
        Util.Assert(vlookup != null, "vlookup != null");
        optName.append(vlookup.leastQualName);
        TclObject obj = TclString.newInstance(optName.toString());
        try {
            TclList.append(interp, list, obj);
        }
        catch (TclException ex) {
            throw new TclRuntimeError("unexpected TclException " + ex.getMessage());
        }
        optName = null;
        obj = vdefn.init != null ? TclString.newInstance(vdefn.init) : TclString.newInstance("<undefined>");
        try {
            TclList.append(interp, list, obj);
        }
        catch (TclException ex) {
            throw new TclRuntimeError("unexpected TclException " + ex.getMessage());
        }
        String val = Objects.GetInstanceVar(interp, vdefn.member.fullname, contextObj, contextObj.classDefn);
        obj = val != null ? TclString.newInstance(val) : TclString.newInstance("<undefined>");
        try {
            TclList.append(interp, list, obj);
        }
        catch (TclException ex) {
            throw new TclRuntimeError("unexpected TclException " + ex.getMessage());
        }
        return list;
    }

    static class BiCgetCmd
    implements Command {
        BiCgetCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Methods.GetContextResult gcr = Methods.GetContext(interp);
            ItclClass contextClass = gcr.cdefn;
            ItclObject contextObj = gcr.odefn;
            if (contextObj == null || objv.length != 2) {
                throw new TclException(interp, "improper usage: should be \"object cget -option\"");
            }
            contextClass = contextObj.classDefn;
            String name = objv[1].toString();
            ItclVarLookup vlookup = null;
            vlookup = (ItclVarLookup)contextClass.resolveVars.get(name.substring(1));
            if (vlookup == null || vlookup.vdefn.member.protection != 1) {
                throw new TclException(interp, "unknown option \"" + name + "\"");
            }
            String val = Objects.GetInstanceVar(interp, vlookup.vdefn.member.fullname, contextObj, contextObj.classDefn);
            if (val != null) {
                interp.setResult(val);
            } else {
                interp.setResult("<undefined>");
            }
        }
    }

    static class BiChainCmd
    implements Command {
        BiChainCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass cdefn;
            ItclHierIter hier;
            ItclObject contextObj;
            ItclClass contextClass;
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                contextObj = gcr.odefn;
            }
            catch (TclException tclException) {
                interp.resetResult();
                throw new TclException(interp, "cannot chain functions outside of a class context");
            }
            CallFrame frame = Migrate.GetCallFrame(interp, 0);
            TclObject[] fobjv = ItclAccess.getCallFrameObjv(frame);
            if (frame == null || fobjv == null) {
                return;
            }
            String cmd = fobjv[0].toString();
            Util.ParseNamespPathResult res = Util.ParseNamespPath(cmd);
            String cfr_ignored_0 = res.head;
            cmd = res.tail;
            if (contextObj != null) {
                hier = new ItclHierIter();
                Class.InitHierIter(hier, contextObj.classDefn);
                while ((cdefn = Class.AdvanceHierIter(hier)) != null) {
                    if (cdefn != contextClass) {
                        continue;
                    }
                    break;
                }
            } else {
                hier = new ItclHierIter();
                Class.InitHierIter(hier, contextClass);
                Class.AdvanceHierIter(hier);
            }
            while ((cdefn = Class.AdvanceHierIter(hier)) != null) {
                TclObject[] newobjv;
                ItclMemberFunc mfunc = (ItclMemberFunc)cdefn.functions.get(cmd);
                if (mfunc == null) continue;
                TclObject cmdline = Util.CreateArgs(interp, mfunc.member.fullname, objv, 1);
                try {
                    newobjv = TclList.getElements(interp, cmdline);
                }
                catch (TclException ex) {
                    throw new TclRuntimeError("unexpected TclException " + ex.getMessage());
                }
                Util.EvalArgs(interp, newobjv);
                break;
            }
            Class.DeleteHierIter(hier);
        }
    }

    static class BiConfigureCmd
    implements Command {
        BiConfigureCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Methods.GetContextResult gcr = Methods.GetContext(interp);
            ItclClass contextClass = gcr.cdefn;
            ItclObject contextObj = gcr.odefn;
            if (contextObj == null) {
                throw new TclException(interp, "improper usage: should be \"object configure ?-option? ?value -option value...?\"");
            }
            contextClass = contextObj.classDefn;
            if (objv.length == 1) {
                ItclClass cd;
                TclObject result = TclList.newInstance();
                ItclHierIter hier = new ItclHierIter();
                Class.InitHierIter(hier, contextClass);
                while ((cd = Class.AdvanceHierIter(hier)) != null) {
                    for (Map.Entry entry : cd.variables.entrySet()) {
                        String cfr_ignored_0 = (String)entry.getKey();
                        ItclVarDefn vdefn = (ItclVarDefn)entry.getValue();
                        if (vdefn.member.protection != 1) continue;
                        TclObject obj = BiCmds.ReportPublicOpt(interp, vdefn, contextObj);
                        TclList.append(interp, result, obj);
                    }
                }
                Class.DeleteHierIter(hier);
                interp.setResult(result);
                return;
            }
            if (objv.length == 2) {
                String token = objv[1].toString();
                if (token.length() < 2 || token.charAt(0) != '-') {
                    throw new TclException(interp, "improper usage: should be \"object configure ?-option? ?value -option value...?\"");
                }
                ItclVarLookup vlookup = (ItclVarLookup)contextClass.resolveVars.get(token.substring(1));
                if (vlookup != null && vlookup.vdefn.member.protection != 1) {
                    vlookup = null;
                }
                if (vlookup == null) {
                    throw new TclException(interp, "unknown option \"" + token + "\"");
                }
                TclObject result = BiCmds.ReportPublicOpt(interp, vlookup.vdefn, contextObj);
                interp.setResult(result);
                return;
            }
            ItclContext context = new ItclContext(interp);
            Methods.PushContext(interp, null, contextObj.classDefn, contextObj, context);
            try {
                StringBuffer buffer = new StringBuffer(64);
                int i = 1;
                while (i < objv.length) {
                    ItclVarLookup vlookup = null;
                    String token = objv[i].toString();
                    if (token.length() >= 2 && token.charAt(0) == '-') {
                        vlookup = (ItclVarLookup)contextClass.resolveVars.get(token.substring(1));
                    }
                    if (vlookup == null || vlookup.vdefn.member.protection != 1) {
                        throw new TclException(interp, "unknown option \"" + token + "\"");
                    }
                    if (i == objv.length - 1) {
                        throw new TclException(interp, "value for \"" + token + "\" missing");
                    }
                    ItclMember member = vlookup.vdefn.member;
                    TclObject tmp = interp.getVar(member.fullname, 0);
                    buffer.setLength(0);
                    if (tmp != null) {
                        String lastval = tmp.toString();
                        buffer.append(lastval);
                    }
                    token = objv[i + 1].toString();
                    try {
                        interp.setVar(member.fullname, TclString.newInstance(token), 0);
                    }
                    catch (TclException ex) {
                        interp.addErrorInfo("\n    (error in configuration of public variable \"" + member.fullname + "\")");
                        throw ex;
                    }
                    ItclMemberCode mcode = member.code;
                    if (mcode != null && Methods.IsMemberCodeImplemented(mcode)) {
                        String cfr_ignored_1 = mcode.body;
                        CallFrame uplevelFrame = Migrate.GetCallFrame(interp, 1);
                        CallFrame oldFrame = Migrate.ActivateCallFrame(interp, uplevelFrame);
                        try {
                            try {
                                Methods.EvalMemberCode(interp, null, member, contextObj, null);
                                interp.resetResult();
                            }
                            catch (TclException ex) {
                                String msg = "\n    (error in configuration of public variable \"" + member.fullname + "\")";
                                interp.addErrorInfo(msg);
                                interp.setVar(member.fullname, TclString.newInstance(buffer.toString()), 0);
                                throw ex;
                            }
                        }
                        finally {
                            Migrate.ActivateCallFrame(interp, oldFrame);
                        }
                    }
                    i += 2;
                }
            }
            finally {
                Methods.PopContext(interp, context);
            }
        }
    }

    static class BiInfoArgsCmd
    implements Command {
        BiInfoArgsCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass contextClass;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "function");
            }
            String name = objv[1].toString();
            if (!Class.IsClassNamespace(Namespace.getCurrentNamespace(interp))) {
                name = objv[1].toString();
                interp.eval("::info args {" + name + "}");
                return;
            }
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                ItclObject cfr_ignored_0 = gcr.odefn;
            }
            catch (TclException tclException) {
                name = objv[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + name + "... }");
            }
            ItclMemberFunc mfunc = (ItclMemberFunc)contextClass.resolveCmds.get(name);
            if (mfunc == null) {
                throw new TclException(interp, "\"" + name + "\" isn't a procedure");
            }
            ItclMemberCode mcode = mfunc.member.code;
            TclObject obj = mcode != null && mcode.arglist != null ? Methods.ArgList(mcode.argcount, mcode.arglist) : ((mfunc.member.flags & ItclInt.ARG_SPEC) != 0 ? Methods.ArgList(mfunc.argcount, mfunc.arglist) : TclString.newInstance("<undefined>"));
            interp.setResult(obj);
        }
    }

    static class BiInfoBodyCmd
    implements Command {
        BiInfoBodyCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass contextClass;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "function");
            }
            if (!Class.IsClassNamespace(Namespace.getCurrentNamespace(interp))) {
                String name = objv[1].toString();
                interp.eval("::info body {" + name + "}");
                return;
            }
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                ItclObject cfr_ignored_0 = gcr.odefn;
            }
            catch (TclException tclException) {
                String name = objv[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + name + "... }");
            }
            String name = objv[1].toString();
            ItclMemberFunc mfunc = (ItclMemberFunc)contextClass.resolveCmds.get(name);
            if (mfunc == null) {
                throw new TclException(interp, "\"" + name + "\" isn't a procedure");
            }
            ItclMemberCode mcode = mfunc.member.code;
            TclObject obj = mcode != null && Methods.IsMemberCodeImplemented(mcode) ? TclString.newInstance(mcode.body) : TclString.newInstance("<undefined>");
            interp.setResult(obj);
        }
    }

    static class BiInfoClassCmd
    implements Command {
        BiInfoClassCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObject contextObj;
            ItclClass contextClass;
            Namespace activeNs = Namespace.getCurrentNamespace(interp);
            Namespace contextNs = null;
            if (objv.length != 1) {
                throw new TclNumArgsException(interp, 1, objv, "");
            }
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                contextObj = gcr.odefn;
            }
            catch (TclException tclException) {
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + objv[0] + "... }");
            }
            if (contextObj != null) {
                contextNs = contextObj.classDefn.namesp;
            } else {
                Util.Assert(contextClass != null, "contextClass != null");
                Util.Assert(contextClass.namesp != null, "contextClass.namesp != null");
                contextNs = contextClass.namesp;
            }
            String name = contextNs == null ? activeNs.fullName : (contextNs.parent == activeNs ? contextNs.name : contextNs.fullName);
            interp.setResult(name);
        }
    }

    static class BiInfoFunctionCmd
    implements Command {
        static String[] options = new String[]{"-args", "-body", "-name", "-protection", "-type"};
        private static final int BIfArgsIdx = 0;
        private static final int BIfBodyIdx = 1;
        private static final int BIfNameIdx = 2;
        private static final int BIfProtectIdx = 3;
        private static final int BIfTypeIdx = 4;
        static int[] DefInfoFunction;

        static {
            int[] nArray = new int[5];
            nArray[0] = 3;
            nArray[1] = 4;
            nArray[2] = 2;
            nArray[4] = 1;
            DefInfoFunction = nArray;
        }

        BiInfoFunctionCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass contextClass;
            String cmdName = null;
            TclObject result = null;
            TclObject obj = null;
            int[] iflistStorage = new int[5];
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                ItclObject cfr_ignored_0 = gcr.odefn;
            }
            catch (TclException tclException) {
                String name = objv[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + name + "... }");
            }
            int objc = objv.length;
            int skip = 0;
            ++skip;
            if (--objc > 0) {
                cmdName = objv[skip].toString();
                --objc;
                ++skip;
            }
            if (cmdName != null) {
                int i;
                int[] iflist;
                ItclMemberFunc mfunc = (ItclMemberFunc)contextClass.resolveCmds.get(cmdName);
                if (mfunc == null) {
                    throw new TclException(interp, "\"" + cmdName + "\" isn't a member function in class \"" + contextClass.namesp.fullName + "\"");
                }
                ItclMemberCode mcode = mfunc.member.code;
                if (objc == 0) {
                    objc = 5;
                    iflist = DefInfoFunction;
                } else {
                    iflist = iflistStorage;
                    i = 0;
                    while (i < objc) {
                        iflist[i] = TclIndex.get(interp, objv[i + skip], options, "option", 0);
                        ++i;
                    }
                }
                if (objc > 1) {
                    result = TclList.newInstance();
                }
                i = 0;
                while (i < objc) {
                    switch (iflist[i]) {
                        case 0: {
                            if (mcode != null && mcode.arglist != null) {
                                obj = Methods.ArgList(mcode.argcount, mcode.arglist);
                                break;
                            }
                            if ((mfunc.member.flags & ItclInt.ARG_SPEC) != 0) {
                                obj = Methods.ArgList(mfunc.argcount, mfunc.arglist);
                                break;
                            }
                            obj = TclString.newInstance("<undefined>");
                            break;
                        }
                        case 1: {
                            if (mcode != null && Methods.IsMemberCodeImplemented(mcode)) {
                                obj = TclString.newInstance(mcode.body);
                                break;
                            }
                            obj = TclString.newInstance("<undefined>");
                            break;
                        }
                        case 2: {
                            obj = TclString.newInstance(mfunc.member.fullname);
                            break;
                        }
                        case 3: {
                            String val = Util.ProtectionStr(mfunc.member.protection);
                            obj = TclString.newInstance(val);
                            break;
                        }
                        case 4: {
                            String val = (mfunc.member.flags & ItclInt.COMMON) != 0 ? "proc" : "method";
                            obj = TclString.newInstance(val);
                        }
                    }
                    if (objc == 1) {
                        result = obj;
                    } else {
                        TclList.append(interp, result, obj);
                    }
                    ++i;
                }
                interp.setResult(result);
            } else {
                ItclClass cdefn;
                result = TclList.newInstance();
                ItclHierIter hier = new ItclHierIter();
                Class.InitHierIter(hier, contextClass);
                while ((cdefn = Class.AdvanceHierIter(hier)) != null) {
                    for (Map.Entry entry : cdefn.functions.entrySet()) {
                        String cfr_ignored_1 = (String)entry.getKey();
                        ItclMemberFunc mfunc = (ItclMemberFunc)entry.getValue();
                        obj = TclString.newInstance(mfunc.member.fullname);
                        TclList.append(interp, result, obj);
                    }
                }
                Class.DeleteHierIter(hier);
                interp.setResult(result);
            }
        }
    }

    static class BiInfoHeritageCmd
    implements Command {
        BiInfoHeritageCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass cdefn;
            ItclClass contextClass;
            Namespace activeNs = Namespace.getCurrentNamespace(interp);
            if (objv.length != 1) {
                throw new TclNumArgsException(interp, 1, objv, "");
            }
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                ItclObject cfr_ignored_0 = gcr.odefn;
            }
            catch (TclException tclException) {
                String name = objv[0].toString();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + name + "... }");
            }
            TclObject list = TclList.newInstance();
            ItclHierIter hier = new ItclHierIter();
            Class.InitHierIter(hier, contextClass);
            while ((cdefn = Class.AdvanceHierIter(hier)) != null) {
                TclObject obj = cdefn.namesp.parent == activeNs ? TclString.newInstance(cdefn.namesp.name) : TclString.newInstance(cdefn.namesp.fullName);
                TclList.append(interp, list, obj);
            }
            Class.DeleteHierIter(hier);
            interp.setResult(list);
        }
    }

    static class BiInfoInheritCmd
    implements Command {
        BiInfoInheritCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass contextClass;
            Namespace activeNs = Namespace.getCurrentNamespace(interp);
            if (objv.length != 1) {
                throw new TclNumArgsException(interp, 1, objv, "");
            }
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                ItclObject cfr_ignored_0 = gcr.odefn;
            }
            catch (TclException tclException) {
                String name = objv[0].toString();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + name + "... }");
            }
            TclObject list = TclList.newInstance();
            Itcl_ListElem elem = Util.FirstListElem(contextClass.bases);
            while (elem != null) {
                ItclClass cdefn = (ItclClass)Util.GetListValue(elem);
                TclObject obj = cdefn.namesp.parent == activeNs ? TclString.newInstance(cdefn.namesp.name) : TclString.newInstance(cdefn.namesp.fullName);
                TclList.append(interp, list, obj);
                elem = Util.NextListElem(elem);
            }
            interp.setResult(list);
        }
    }

    static class BiInfoVariableCmd
    implements Command {
        static String[] options = new String[]{"-config", "-init", "-name", "-protection", "-type", "-value"};
        private static final int BIvConfigIdx = 0;
        private static final int BIvInitIdx = 1;
        private static final int BIvNameIdx = 2;
        private static final int BIvProtectIdx = 3;
        private static final int BIvTypeIdx = 4;
        private static final int BIvValueIdx = 5;
        static int[] DefInfoVariable = new int[]{3, 4, 2, 1, 5};
        static int[] DefInfoPubVariable;

        static {
            int[] nArray = new int[6];
            nArray[0] = 3;
            nArray[1] = 4;
            nArray[2] = 2;
            nArray[3] = 1;
            nArray[5] = 5;
            DefInfoPubVariable = nArray;
        }

        BiInfoVariableCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObject contextObj;
            ItclClass contextClass;
            String varName = null;
            TclObject result = null;
            TclObject obj = null;
            int[] ivlistStorage = new int[6];
            try {
                Methods.GetContextResult gcr = Methods.GetContext(interp);
                contextClass = gcr.cdefn;
                contextObj = gcr.odefn;
            }
            catch (TclException tclException) {
                String name = objv[0].toString();
                interp.resetResult();
                throw new TclException(interp, "\nget info like this instead: \n  namespace eval className { info " + name + "... }");
            }
            int objc = objv.length;
            int skip = 0;
            ++skip;
            if (--objc > 0) {
                varName = objv[skip].toString();
                --objc;
                ++skip;
            }
            if (varName != null) {
                int i;
                int[] ivlist;
                ItclVarLookup vlookup = (ItclVarLookup)contextClass.resolveVars.get(varName);
                if (vlookup == null) {
                    throw new TclException(interp, "\"" + varName + "\" isn't a variable in class \"" + contextClass.namesp.fullName + "\"");
                }
                ItclMember member = vlookup.vdefn.member;
                if (objc == 0) {
                    if (member.protection == 1 && (member.flags & ItclInt.COMMON) == 0) {
                        ivlist = DefInfoPubVariable;
                        objc = 6;
                    } else {
                        ivlist = DefInfoVariable;
                        objc = 5;
                    }
                } else {
                    ivlist = ivlistStorage;
                    i = 0;
                    while (i < objc) {
                        ivlist[i] = TclIndex.get(interp, objv[i + skip], options, "option", 0);
                        ++i;
                    }
                }
                if (objc > 1) {
                    result = TclList.newInstance();
                }
                i = 0;
                while (i < objc) {
                    switch (ivlist[i]) {
                        case 0: {
                            if (member.code != null && Methods.IsMemberCodeImplemented(member.code)) {
                                obj = TclString.newInstance(member.code.body);
                                break;
                            }
                            obj = TclString.newInstance("");
                            break;
                        }
                        case 1: {
                            if ((member.flags & ItclInt.THIS_VAR) != 0) {
                                if (contextObj != null && contextObj.accessCmd != null) {
                                    String name = contextObj.classDefn.interp.getCommandFullName(contextObj.w_accessCmd);
                                    obj = TclString.newInstance(name);
                                    break;
                                }
                                obj = TclString.newInstance("<objectName>");
                                break;
                            }
                            if (vlookup.vdefn.init != null) {
                                obj = TclString.newInstance(vlookup.vdefn.init);
                                break;
                            }
                            obj = TclString.newInstance("<undefined>");
                            break;
                        }
                        case 2: {
                            obj = TclString.newInstance(member.fullname);
                            break;
                        }
                        case 3: {
                            String val = Util.ProtectionStr(member.protection);
                            obj = TclString.newInstance(val);
                            break;
                        }
                        case 4: {
                            String val = (member.flags & ItclInt.COMMON) != 0 ? "common" : "variable";
                            obj = TclString.newInstance(val);
                            break;
                        }
                        case 5: {
                            String val;
                            if ((member.flags & ItclInt.COMMON) != 0) {
                                val = Class.GetCommonVar(interp, member.fullname, member.classDefn);
                            } else {
                                if (contextObj == null) {
                                    interp.resetResult();
                                    throw new TclException(interp, "cannot access object-specific info without an object context");
                                }
                                val = Objects.GetInstanceVar(interp, member.fullname, contextObj, member.classDefn);
                            }
                            if (val == null) {
                                val = "<undefined>";
                            }
                            obj = TclString.newInstance(val);
                        }
                    }
                    if (objc == 1) {
                        result = obj;
                    } else {
                        TclList.append(interp, result, obj);
                    }
                    ++i;
                }
                interp.setResult(result);
            } else {
                ItclClass cdefn;
                result = TclList.newInstance();
                ItclHierIter hier = new ItclHierIter();
                Class.InitHierIter(hier, contextClass);
                while ((cdefn = Class.AdvanceHierIter(hier)) != null) {
                    for (Map.Entry entry : cdefn.variables.entrySet()) {
                        String cfr_ignored_0 = (String)entry.getKey();
                        ItclVarDefn vdefn = (ItclVarDefn)entry.getValue();
                        if ((vdefn.member.flags & ItclInt.THIS_VAR) != 0) {
                            if (cdefn != contextClass) continue;
                            obj = TclString.newInstance(vdefn.member.fullname);
                            TclList.append(interp, result, obj);
                            continue;
                        }
                        obj = TclString.newInstance(vdefn.member.fullname);
                        TclList.append(interp, result, obj);
                    }
                }
                Class.DeleteHierIter(hier);
                interp.setResult(result);
            }
        }
    }

    static class BiIsaCmd
    implements Command {
        BiIsaCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Methods.GetContextResult gcr = Methods.GetContext(interp);
            ItclClass cfr_ignored_0 = gcr.cdefn;
            ItclObject contextObj = gcr.odefn;
            if (contextObj == null) {
                throw new TclException(interp, "improper usage: should be \"object isa className\"");
            }
            if (objv.length != 2) {
                String token = objv[0].toString();
                throw new TclException(interp, "wrong # args: should be \"object " + token + " className\"");
            }
            String token = objv[1].toString();
            ItclClass cdefn = Class.FindClass(interp, token, true);
            if (cdefn == null) {
                throw new TclException(interp, interp.getResult().toString());
            }
            if (Objects.ObjectIsa(contextObj, cdefn)) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }

    static class DefaultInfoCmd
    implements Command {
        DefaultInfoCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            block5: {
                WrappedCommand wcmd = Namespace.findCommand(interp, "::info", null, 0);
                if (wcmd == null) {
                    String name = objv[0].toString();
                    interp.resetResult();
                    StringBuffer result = new StringBuffer(64);
                    result.append("bad option \"" + name + "\" should be one of...\n");
                    Ensemble.GetEnsembleUsageForObj(interp, objv[0], result);
                    throw new TclException(interp, result.toString());
                }
                Command cmd = wcmd.cmd;
                try {
                    if (wcmd.mustCallInvoke(interp)) {
                        wcmd.invoke(interp, objv);
                    } else {
                        cmd.cmdProc(interp, objv);
                    }
                }
                catch (TclException tclException) {
                    String ires = interp.getResult().toString();
                    if (!ires.startsWith("bad option")) break block5;
                    StringBuffer result = new StringBuffer(64);
                    result.append(ires);
                    result.append("\nor");
                    Ensemble.GetEnsembleUsageForObj(interp, objv[0], result);
                    throw new TclException(interp, result.toString());
                }
            }
        }
    }
}

