/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.HashMap;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.BiCmds;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.Ensemble;
import tcl.pkg.itcl.Itcl;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_Stack;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Objects;
import tcl.pkg.itcl.Parse;
import tcl.pkg.itcl.Util;

class Cmds {
    static String initScript = "namespace eval ::itcl { source resource:/tcl/pkg/itcl/library/itcl.tcl }";
    static String safeInitScript = "proc ::itcl::local {class name args} {\n    set ptr [uplevel [list $class $name] $args]\n    uplevel [list set itcl-local-$ptr $ptr]\n    set cmd [uplevel namespace which -command $ptr]\n    uplevel [list trace variable itcl-local-$ptr u \"::itcl::delete object $cmd; list\"]\n    return $ptr\n}";
    static int itclCompatFlags = -1;

    Cmds() {
    }

    static void Initialize(Interp interp) throws TclException {
        String TCL_VERSION = "8.0";
        interp.pkgRequire("Tcl", TCL_VERSION, false);
        if (interp.getCommand("::itcl::class") != null) {
            throw new TclException(interp, "already installed: [incr Tcl]");
        }
        itclCompatFlags = 0;
        Ensemble.EnsembleInit(interp);
        ItclObjectInfo info = new ItclObjectInfo();
        info.interp = interp;
        info.objects = new HashMap();
        info.transparentFrames = new Itcl_Stack();
        Util.InitStack(info.transparentFrames);
        info.contextFrames = new HashMap();
        info.protection = 4;
        info.cdefnStack = new Itcl_Stack();
        Util.InitStack(info.cdefnStack);
        interp.setAssocData(ItclInt.INTERP_DATA, info);
        interp.createCommand("::itcl::class", new Parse.ClassCmd(info));
        Util.PreserveData(info);
        interp.createCommand("::itcl::body", new Methods.BodyCmd());
        interp.createCommand("::itcl::configbody", new Methods.ConfigBodyCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::find");
        Ensemble.AddEnsemblePart(interp, "::itcl::find", "classes", "?pattern?", (Command)new FindClassesCmd(info));
        Util.PreserveData(info);
        Ensemble.AddEnsemblePart(interp, "::itcl::find", "objects", "?-class className? ?-isa className? ?pattern?", (Command)new FindObjectsCmd(info));
        Util.PreserveData(info);
        Ensemble.CreateEnsemble(interp, "::itcl::delete");
        Ensemble.AddEnsemblePart(interp, "::itcl::delete", "class", "name ?name...?", (Command)new DelClassCmd(info));
        Util.PreserveData(info);
        Ensemble.AddEnsemblePart(interp, "::itcl::delete", "object", "name ?name...?", (Command)new DelObjectCmd(info));
        Util.PreserveData(info);
        Ensemble.CreateEnsemble(interp, "::itcl::is");
        Ensemble.AddEnsemblePart(interp, "::itcl::is", "class", "name", (Command)new IsClassCmd(info));
        Util.PreserveData(info);
        Ensemble.AddEnsemblePart(interp, "::itcl::is", "object", "?-class classname? name", (Command)new IsObjectCmd(info));
        Util.PreserveData(info);
        interp.createCommand("::itcl::code", new CodeCmd());
        interp.createCommand("::itcl::scope", new ScopeCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::import::stub");
        Ensemble.AddEnsemblePart(interp, "::itcl::import::stub", "create", "name", (Command)new StubCreateCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::import::stub", "exists", "name", (Command)new StubExistsCmd());
        Objects.ScopedVarResolverImpl resolver = new Objects.ScopedVarResolverImpl();
        interp.addInterpResolver("itcl", resolver);
        Parse.ParseInit(interp, info);
        BiCmds.BiInit(interp);
        Namespace itclNs = Namespace.findNamespace(interp, "::itcl", null, 512);
        if (itclNs == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        Namespace.exportList(interp, itclNs, "body", true);
        Namespace.exportList(interp, itclNs, "class", false);
        Namespace.exportList(interp, itclNs, "code", false);
        Namespace.exportList(interp, itclNs, "configbody", false);
        Namespace.exportList(interp, itclNs, "delete", false);
        Namespace.exportList(interp, itclNs, "delete_helper", false);
        Namespace.exportList(interp, itclNs, "ensemble", false);
        Namespace.exportList(interp, itclNs, "find", false);
        Namespace.exportList(interp, itclNs, "local", false);
        Namespace.exportList(interp, itclNs, "scope", false);
        interp.setVar("::itcl::patchLevel", TclString.newInstance(Itcl.PATCH_LEVEL), 2);
        interp.setVar("::itcl::version", TclString.newInstance(Itcl.VERSION), 2);
    }

    static void Init(Interp interp) throws TclException {
        Cmds.Initialize(interp);
        interp.eval(initScript);
    }

    static void SafeInit(Interp interp) throws TclException {
        Cmds.Initialize(interp);
        interp.eval(safeInitScript);
    }

    static void DelObjectInfo(ItclObjectInfo info) {
        ItclObject contextObj;
        while ((contextObj = (ItclObject)ItclAccess.FirstHashEntry(info.objects)) != null) {
            info.interp.deleteCommandFromToken(contextObj.w_accessCmd);
        }
        info.objects.clear();
        info.objects = null;
        for (Map.Entry entry : info.contextFrames.entrySet()) {
            contextObj = (ItclObject)entry.getValue();
            Util.ReleaseData(contextObj);
        }
        info.contextFrames.clear();
        info.contextFrames = null;
        Util.DeleteStack(info.transparentFrames);
        info.transparentFrames = null;
        Util.DeleteStack(info.cdefnStack);
        info.cdefnStack = null;
    }

    static boolean IsStub(WrappedCommand wcmd) {
        return wcmd.cmd instanceof HandleStubCmd;
    }

    static void ItclDeleteStub(Object cdata) {
    }

    static class CodeCmd
    implements Command {
        CodeCmd() {
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Namespace contextNs = Namespace.getCurrentNamespace(interp);
            int pos = 1;
            while (pos < objv.length) {
                String token = objv[pos].toString();
                if (token.length() < 2 || token.charAt(0) != '-') break;
                if (token.equals("-namespace")) {
                    if (objv.length == 2) {
                        throw new TclNumArgsException(interp, 1, objv, "?-namespace name? command ?arg arg...?");
                    }
                    token = objv[pos + 1].toString();
                    contextNs = Namespace.findNamespace(interp, token, null, 512);
                    if (contextNs == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++pos;
                } else {
                    if (token.equals("--")) {
                        ++pos;
                        break;
                    }
                    throw new TclException(interp, "bad option \"" + token + "\": should be -namespace or --");
                }
                ++pos;
            }
            if (objv.length < 2) {
                throw new TclNumArgsException(interp, 1, objv, "?-namespace name? command ?arg arg...?");
            }
            TclObject list = TclList.newInstance();
            TclList.append(interp, list, TclString.newInstance("namespace"));
            TclList.append(interp, list, TclString.newInstance("inscope"));
            TclObject obj = contextNs == Namespace.getGlobalNamespace(interp) ? TclString.newInstance("::") : TclString.newInstance(contextNs.fullName);
            TclList.append(interp, list, obj);
            if (objv.length - pos == 1) {
                obj = objv[pos];
            } else {
                obj = TclList.newInstance();
                int i = pos;
                while (i < objv.length) {
                    TclList.append(interp, obj, objv[i]);
                    ++i;
                }
            }
            TclList.append(interp, list, obj);
            interp.setResult(list);
        }
    }

    static class DelClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        DelClassCmd(ItclObjectInfo info) {
            this.info = info;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass cdefn;
            String name;
            int i = 1;
            while (i < objv.length) {
                name = objv[i].toString();
                cdefn = Class.FindClass(interp, name, true);
                if (cdefn == null) {
                    throw new TclException(interp, interp.getResult().toString());
                }
                ++i;
            }
            i = 1;
            while (i < objv.length) {
                name = objv[i].toString();
                cdefn = Class.FindClass(interp, name, false);
                if (cdefn != null) {
                    interp.resetResult();
                    Class.DeleteClass(interp, cdefn);
                }
                ++i;
            }
            interp.resetResult();
        }
    }

    static class DelObjectCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        DelObjectCmd(ItclObjectInfo info) {
            this.info = info;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            int i = 1;
            while (i < objv.length) {
                String name = objv[i].toString();
                ItclObject contextObj = Objects.FindObject(interp, name);
                if (contextObj == null) {
                    throw new TclException(interp, "object \"" + name + "\" not found");
                }
                Objects.DeleteObject(interp, contextObj);
                ++i;
            }
        }
    }

    public static class FindClassesCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        FindClassesCmd(ItclObjectInfo info) {
            this.info = info;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String pattern;
            Namespace activeNs = Namespace.getCurrentNamespace(interp);
            Namespace globalNs = Namespace.getGlobalNamespace(interp);
            boolean forceFullNames = false;
            if (objv.length > 2) {
                throw new TclNumArgsException(interp, 1, objv, "?pattern?");
            }
            if (objv.length == 2) {
                pattern = objv[1].toString();
                forceFullNames = pattern.indexOf("::") != -1;
            } else {
                pattern = null;
            }
            Itcl_Stack search = new Itcl_Stack();
            Util.InitStack(search);
            Util.PushStack(globalNs, search);
            Util.PushStack(activeNs, search);
            HashMap<WrappedCommand, String> unique = new HashMap<WrappedCommand, String>();
            TclObject result = TclList.newInstance();
            boolean handledActiveNs = false;
            while (Util.GetStackSize(search) > 0) {
                Namespace ns = (Namespace)Util.PopStack(search);
                if (ns == activeNs && handledActiveNs) continue;
                for (Map.Entry<String, WrappedCommand> entry : ns.cmdTable.entrySet()) {
                    boolean newEntry;
                    TclObject obj;
                    String cmdName;
                    entry.getKey();
                    WrappedCommand cmd = entry.getValue();
                    if (!Class.IsClass(cmd)) continue;
                    WrappedCommand originalCmd = Namespace.getOriginalCommand(cmd);
                    if (forceFullNames || ns != activeNs || originalCmd != null) {
                        cmdName = interp.getCommandFullName(cmd);
                        obj = TclString.newInstance(cmdName);
                    } else {
                        cmdName = interp.getCommandName(cmd);
                        obj = TclString.newInstance(cmdName);
                    }
                    if (originalCmd != null) {
                        cmd = originalCmd;
                    }
                    boolean bl = newEntry = unique.put(cmd, "") == null;
                    if (!newEntry || pattern != null && !tcl.lang.Util.stringMatch(cmdName, pattern)) continue;
                    TclList.append(interp, result, obj);
                }
                handledActiveNs = true;
                for (Map.Entry<String, Object> entry : ns.childTable.entrySet()) {
                    entry.getKey();
                    Namespace child = (Namespace)entry.getValue();
                    Util.PushStack(child, search);
                }
            }
            unique.clear();
            Util.DeleteStack(search);
            interp.setResult(result);
        }
    }

    public static class FindObjectsCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        FindObjectsCmd(ItclObjectInfo info) {
            this.info = info;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Namespace activeNs = Namespace.getCurrentNamespace(interp);
            Namespace globalNs = Namespace.getGlobalNamespace(interp);
            boolean forceFullNames = false;
            String pattern = null;
            ItclClass classDefn = null;
            ItclClass isaDefn = null;
            String name = null;
            String token = null;
            String cmdName = null;
            TclObject result = TclList.newInstance();
            int pos = 0;
            while (++pos < objv.length) {
                token = objv[pos].toString();
                if (token.length() == 0 || token.charAt(0) != '-') {
                    if (pattern != null) break;
                    pattern = token;
                    forceFullNames = pattern.indexOf("::") != -1;
                    continue;
                }
                if (pos + 1 < objv.length && token.equals("-class")) {
                    name = objv[pos + 1].toString();
                    classDefn = Class.FindClass(interp, name, true);
                    if (classDefn == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++pos;
                    continue;
                }
                if (pos + 1 < objv.length && token.equals("-isa")) {
                    name = objv[pos + 1].toString();
                    isaDefn = Class.FindClass(interp, name, true);
                    if (isaDefn == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++pos;
                    continue;
                }
                if (pos != objv.length - 1 || pattern != null) break;
                pattern = token;
                boolean bl = forceFullNames = pattern.indexOf("::") != -1;
            }
            if (pos < objv.length) {
                throw new TclNumArgsException(interp, 1, objv, "?-class className? ?-isa className? ?pattern?");
            }
            Itcl_Stack search = new Itcl_Stack();
            Util.InitStack(search);
            Util.PushStack(globalNs, search);
            Util.PushStack(activeNs, search);
            HashMap<WrappedCommand, String> unique = new HashMap<WrappedCommand, String>();
            boolean handledActiveNs = false;
            while (Util.GetStackSize(search) > 0) {
                Namespace ns = (Namespace)Util.PopStack(search);
                if (ns == activeNs && handledActiveNs) continue;
                for (Map.Entry<String, WrappedCommand> entry : ns.cmdTable.entrySet()) {
                    TclObject obj;
                    entry.getKey();
                    WrappedCommand wcmd = entry.getValue();
                    if (!Objects.IsObject(wcmd)) continue;
                    WrappedCommand originalCmd = Namespace.getOriginalCommand(wcmd);
                    if (originalCmd != null) {
                        wcmd = originalCmd;
                    }
                    ItclObject contextObj = Objects.GetContextFromObject(wcmd);
                    if (forceFullNames || ns != activeNs || originalCmd != null) {
                        cmdName = interp.getCommandFullName(wcmd);
                        obj = TclString.newInstance(cmdName);
                    } else {
                        cmdName = interp.getCommandName(wcmd);
                        obj = TclString.newInstance(cmdName);
                    }
                    boolean newEntry = unique.put(wcmd, "") == null;
                    boolean match = false;
                    if (newEntry && (pattern == null || tcl.lang.Util.stringMatch(cmdName, pattern)) && (classDefn == null || contextObj.classDefn == classDefn)) {
                        if (isaDefn == null) {
                            match = true;
                        } else if (contextObj.classDefn.heritage.get(isaDefn) != null) {
                            match = true;
                        }
                    }
                    if (!match) continue;
                    TclList.append(interp, result, obj);
                }
                handledActiveNs = true;
                for (Map.Entry<String, Object> entry : ns.childTable.entrySet()) {
                    Namespace child = (Namespace)entry.getValue();
                    Util.PushStack(child, search);
                }
            }
            unique.clear();
            Util.DeleteStack(search);
            interp.setResult(result);
        }
    }

    public static class HandleStubCmd
    implements CommandWithDispose {
        WrappedCommand wcmd;

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String cmdName = interp.getCommandFullName(this.wcmd);
            interp.eval("::auto_load \"" + cmdName + "\"");
            TclObject obj = interp.getResult();
            boolean err = false;
            int loaded = 0;
            try {
                loaded = TclInteger.getInt(interp, obj);
            }
            catch (TclException tclException) {
                err = true;
            }
            if (err || loaded != 1) {
                interp.resetResult();
                throw new TclException(interp, "can't autoload \"" + cmdName + "\"");
            }
            TclObject cmdline = Util.CreateArgs(interp, cmdName, objv, 1);
            TclObject[] cmdlinev = TclList.getElements(interp, cmdline);
            interp.resetResult();
            Util.EvalArgs(interp, cmdlinev);
        }

        @Override
        public void disposeCmd() {
            Cmds.ItclDeleteStub(null);
        }
    }

    public static class IsClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        IsClassCmd(ItclObjectInfo info) {
            this.info = info;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass classDefn = null;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "commandname");
            }
            String name = objv[1].toString();
            Util.DecodeScopedCommandResult res = Util.DecodeScopedCommand(interp, name);
            Namespace cfr_ignored_0 = res.rNS;
            String cname = res.rCmd;
            classDefn = Class.FindClass(interp, cname, false);
            if (classDefn != null) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }

    public static class IsObjectCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        IsObjectCmd(ItclObjectInfo info) {
            this.info = info;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObject contextObj;
            boolean classFlag = false;
            int idx = 0;
            String name = null;
            Namespace contextNs = null;
            ItclClass classDefn = null;
            if (objv.length != 2 && objv.length != 4) {
                throw new TclNumArgsException(interp, 1, objv, "?-class classname? commandname");
            }
            idx = 1;
            while (idx < objv.length) {
                String token = objv[idx].toString();
                if (token.equals("-class")) {
                    String cname = objv[idx + 1].toString();
                    classDefn = Class.FindClass(interp, cname, false);
                    if (classDefn == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++idx;
                    classFlag = true;
                } else {
                    name = objv[idx].toString();
                }
                ++idx;
            }
            if (name == null) {
                throw new TclRuntimeError("name not assigned in objc loop");
            }
            Util.DecodeScopedCommandResult res = Util.DecodeScopedCommand(interp, name);
            String cmdName = res.rCmd;
            contextNs = res.rNS;
            WrappedCommand wcmd = Namespace.findCommand(interp, cmdName, contextNs, 0);
            if (wcmd == null || !Objects.IsObject(wcmd)) {
                interp.setResult(false);
                return;
            }
            if (classFlag && !Objects.ObjectIsa(contextObj = Objects.GetContextFromObject(wcmd), classDefn)) {
                interp.setResult(false);
                return;
            }
            interp.setResult(true);
        }
    }

    public static class ProtectionCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            throw new TclRuntimeError("unused function");
        }
    }

    public static class ScopeCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Namespace contextNs = Namespace.getCurrentNamespace(interp);
            String openParen = null;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "varname");
            }
            String token = objv[1].toString();
            if (token.startsWith("::")) {
                interp.setResult(objv[1]);
                return;
            }
            int openParenEnd = -1;
            int openParenStart = -1;
            int p = 0;
            while (p < token.length()) {
                if (token.charAt(p) == '(') {
                    openParenStart = p;
                } else if (token.charAt(p) == ')' && openParenStart != -1) {
                    openParenEnd = p;
                    break;
                }
                ++p;
            }
            if (openParenStart != -1 && openParenEnd != -1) {
                openParen = token.substring(openParenStart, openParenEnd + 1);
                token = token.substring(0, openParenStart);
            }
            if (Class.IsClassNamespace(contextNs)) {
                ItclClass contextClass = Class.GetClassFromNamespace(contextNs);
                ItclVarLookup vlookup = (ItclVarLookup)contextClass.resolveVars.get(token);
                if (vlookup == null) {
                    throw new TclException(interp, "variable \"" + token + "\" not found in class \"" + contextClass.fullname + "\"");
                }
                if ((vlookup.vdefn.member.flags & ItclInt.COMMON) != 0) {
                    StringBuffer buffer = new StringBuffer(64);
                    buffer.append(vlookup.vdefn.member.fullname);
                    if (openParen != null) {
                        buffer.append(openParen);
                        openParen = null;
                    }
                    interp.setResult(buffer.toString());
                    return;
                }
                CallFrame frame = Migrate.GetCallFrame(interp, 0);
                ItclObjectInfo info = contextClass.info;
                ItclObject contextObj = (ItclObject)info.contextFrames.get(frame);
                if (contextObj == null) {
                    throw new TclException(interp, "can't scope variable \"" + token + "\": missing object context\"");
                }
                TclObject list = TclList.newInstance();
                TclList.append(interp, list, TclString.newInstance("@itcl"));
                TclList.append(interp, list, TclString.newInstance(interp.getCommandFullName(contextObj.w_accessCmd)));
                StringBuffer buffer = new StringBuffer(64);
                buffer.append(vlookup.vdefn.member.fullname);
                if (openParen != null) {
                    buffer.append(openParen);
                    openParen = null;
                }
                TclList.append(interp, list, TclString.newInstance(buffer.toString()));
                interp.setResult(list);
            } else {
                StringBuffer buffer = new StringBuffer(64);
                Var var = Namespace.findNamespaceVar(interp, token, contextNs, 2);
                if (var == null) {
                    throw new TclException(interp, "variable \"" + token + "\" not found in namespace \"" + contextNs.fullName + "\"");
                }
                String fname = Var.getVariableFullName(interp, var);
                buffer.append(fname);
                if (openParen != null) {
                    buffer.append(openParen);
                    openParen = null;
                }
                interp.setResult(buffer.toString());
            }
        }
    }

    public static class StubCreateCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            WrappedCommand wcmd;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "name");
            }
            String cmdName = objv[1].toString();
            interp.createCommand(cmdName, new HandleStubCmd());
            ((HandleStubCmd)wcmd.cmd).wcmd = wcmd = Namespace.findCommand(interp, cmdName, null, 2);
        }
    }

    public static class StubExistsCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "name");
            }
            String cmdName = objv[1].toString();
            WrappedCommand wcmd = Namespace.findCommand(interp, cmdName, null, 0);
            if (wcmd != null && Cmds.IsStub(wcmd)) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }
}

